/*     cassage de boucles / optimisation cache
*/

/* Saisit n, R1, R2, le domaine D et le contexte dans cet ordre */

#include <stdio.h>
#include "types.h"
#include "vector.h"
#include "polyhedron.h"
#include "polyparam.h"

#define WS 1000
#define AFF_POLY(P) {	fprintf( stderr, "\n"#P" = "); \
                        Polyhedron_Print( stderr, "%3d ", P ); }

#define AFFCONTRAINTES(p) {	printf( "\n# "#p "\n" ); \
                        AffContraintes( p ); }

void AffContraintes( Polyhedron *p )
{
	int i,j;
	for( ; p ; p=p->next )
	{
		printf( "%d %d\n", p->NbConstraints, p->Dimension+2 );
		for( i=0 ; i<p->NbConstraints ; i++ )
		{
			for( j=0 ; j<p->Dimension+2 ; j++ )
				printf( "%d ", p->Constraint[i][j] );
			printf( "\n" );
		}
	}
}
int main()
{
	Matrix *a, *r1, *r2, *ri, *t, *context;
	Polyhedron *D, *P1, *P2, *D1, *D2, *p, *pp, *C, *L;
	Polyhedron *D12, *D21, *TiD2, *D1C2, *C1C2, *D2C1;
	int s, i, j, n;

	scanf("%d",&n); /* inutilise ici */

	r1 = Matrix_Read();
	r2 = Matrix_Read();
	s = r1->NbColumns;
	if( s != r2->NbColumns || s != r2->NbRows || s != r1->NbRows )
	{
		fprintf(stderr,
		"Les matrices r1 et r2 doivent etre carrees et avoir la meme taille\n" );
		exit(0);
	}
	a = Matrix_Read();
	D = Constraints2Polyhedron(a, WS );
	Matrix_Free(a);
	context = Matrix_Read();

	ri = Matrix_Alloc(s, s+1);
	if( !MatInverse( r2, ri ) )
	{
		fprintf( stderr, "r2 non inversible!\n");
		exit(0);
	}
	t = Matrix_Alloc(s, s );
	for( i=0 ; i<s ; i++ )
		for( j=0 ; j<s ; j++ )
		{
			int z,k;
			z=0;
			for( k=0 ; k<s ; k++ )
				z += ri->p[i][k] * r1->p[k][j];
			if( z % ri->p[i][s] != 0 )
			{
				fprintf(stderr,
					"Les matrices r1 et r2 n'ont pas le meme determinant\n" );
				exit(0);
			}
			t->p[i][j] = z / ri->p[i][s];
		}
	Matrix_Free( ri );
	Matrix_Free( r1 );
	Matrix_Free( r2 );

	fprintf( stderr, "t = ");
	Matrix_Print( stderr, "%3d ", t );
	AFF_POLY( D );

	p = DomainPreimage( D, t, WS );
	P1 = DomainIntersection( D, p, WS );
	Domain_Free( p );
	p = DomainImage( D, t, WS );
	P2 = DomainIntersection( D, p, WS );
	Domain_Free( p );
	AFF_POLY( P1 );
	AFF_POLY( P2 );

	D1 = DomainDifference( P1, P2, WS);
	D2 = DomainDifference( P2, P1, WS);
	AFF_POLY( D1 );
	AFF_POLY( D2 );

	C = DomainIntersection( P1, P2, WS );
	AFF_POLY( C );

	p = DomainDifference( D, P1, WS );
	L = DomainDifference( p, P2, WS );
	Domain_Free( p );
	AFF_POLY( L );

	TiD2 = DomainPreimage( D2, t, WS );
	D12 = DomainIntersection( D1, TiD2, WS );
	p = DomainImage( D1, t, WS );
	D21 = DomainIntersection( D2, p, WS );
	Domain_Free( p );
	AFF_POLY( D12 );
	AFF_POLY( D21 );

	p = DomainIntersection( C, TiD2, WS );
	Domain_Free( TiD2 );
	pp = DomainPreimage( p, t, WS );
	D1C2 = DomainIntersection( D1, pp, WS );
	Domain_Free( pp );
	Domain_Free( p );
	C1C2 = DomainImage( D1C2, t, WS );
	D2C1 = DomainImage( C1C2, t, WS );
	AFF_POLY( D1C2 );
	AFF_POLY( C1C2 );
	AFF_POLY( D2C1 );

/*	AFFCONTRAINTES(D); */
	AFFCONTRAINTES(L);
	AFFCONTRAINTES(C);
	AFFCONTRAINTES(D1);
	AFFCONTRAINTES(D2);
	AFFCONTRAINTES(D2C1);
	AFFCONTRAINTES(D1C2);
	AFFCONTRAINTES(C1C2);
	AFFCONTRAINTES(D21);
	AFFCONTRAINTES(D12);

	printf( "\n# Contexte = \n");
	Matrix_Print( stdout, "%d ", context );


	Domain_Free(D12);
	Domain_Free(D21);
	Domain_Free(D1);
	Domain_Free(D2);
	Domain_Free(P1);
	Domain_Free(P2);
	Domain_Free(C);
	Domain_Free(D);
	return 0;
}
