/* int pgcd_slow(int a, int b): calcul recursif du pgcd de deux entiers;
 * le pgcd retourne est toujours positif; par extension, pgcd_slow(0,0)==1;
 * il vaudrait peut-etre mieux retourner 0 dans l'espoir de provoquer une
 * exception ulterieure par devision par 0; ou aborter immediatement;
 */





/* int pgcd_fast(int a, int b): calcul iteratif du pgcd de deux entiers;
 * le pgcd retourne est toujours positif; il n'est pas defini si
 * a et b sont nuls (abort);
 */





/* int pgcd_interne(int a, int b): calcul iteratif du pgcd de deux entiers
 * strictement positifs tels que a > b;
 * le pgcd retourne est toujours positif;
 */





/* int gcd_subtract(int a, int b): find the gcd (pgcd) of two integers
 *
 *	There is no precondition on the input. Negative input is handled
 *	in the same way as positive ones. If one input is zero the output
 *	is equal to the other input - thus an input of two zeros is the
 *	only way an output of zero is created.
 *
 *	Postcondition:	gcd(a,b) > 0 ; gcd(a,b)==0 iff a==0 and b==0
 *                      whereas it should be undefined (F. Irigoin)
 *
 *      Exception: gcd(0,0) aborts
 *
 *      Implementation: by subtractions
 *
 * Note: the signs of a and b do not matter because they can be exactly
 * divided by the gcd
 */





/* int vecteur_bezout(int u[], int v[], int l): calcul du vecteur v
 * qui verifie le theoreme de bezout pour le vecteur u; les vecteurs u et
 * v sont de dimension l
 *
 *   ->  ->        ->
 * < u . v > = gcd(u )
 *              i
 */





/* int bezout(int a, int b, int *x, int *y): calcule x et y, les deux
 * nombres qui verifient le theoreme de Bezout pour a et b; le pgcd de
 * a et b est retourne par valeur
 *
 * a * x + b * y = gcd(a,b)
 * return gcd(a,b)
 */





/* int bezout_grl(int a, int b, int *x, int *y): calcule x et y, les deux
 * entiers quelconcs qui verifient le theoreme de Bezout pour a et b; le pgcd
 * de a et b est retourne par valeur
 *
 * a * x + b * y = gcd(a,b)
 * return gcd(a,b)
 * gcd () >=0
 * le pre et le post conditions de pgcd  sont comme la fonction gcd_subtract().
 * les situations speciaux sont donnes ci_dessous:
 *  si (a==0 et b==0)  x=y=0; gcd()=0,
 *  si (a==0)(ou b==0) x=1(ou -1) y=0 (ou x=0 y=1(ou -1)) 
 *  et gcd()=a(ou -a) (ou gcd()=b(ou -b))
 */





/* package arithmetique */
/*LINTLIBRARY*/
/* int modulo_fast(int a, int b): calcul du modulo de a par b;
 * le modulo retourne est toujours positif
 *
 * Il y a quatre configuration de signe a traiter:
 *  1. a>0 && b>0: a % b
 *  2. a<0 && b>0: a % b == 0 ? 0 : b - (-a)%b
 *  3. a>0 && b<0: cf. 1. apres changement de signe de b
 *  4. a<0 && b<0: cf. 2. apres changement de signe de b
 */





/* package arithmetique */
/*LINTLIBRARY*/
/* int divide(int a, int b): calcul du divide de a par b;
 * le reste (qui n'est pas retourne) est toujours positif; il
 * est fourni par la fonction modulo()
 *
 * Il y a quatre configuration de signe a traiter:
 *  1. a>0 && b>0: a / b
 *  2. a<0 && b>0: (a-b+1) / b
 *  3. a>0 && b<0: cf. 1. apres changement de signe de b, puis changement 
 *     de signe du resultat
 *  4. a<0 && b<0: cf. 2. apres changement de signe de b, puis changement
 *     de signe du resultat
 *  5. a==0: 0
 */





/*LINTLIBRARY*/
/* int ppcm(int i, int j): plus petit entier positif divisible par i et j
 *
 * Ancien nom et ancien type: void lcm(int i, int j, int *pk)
 */





/*LINTLIBRARY*/
/* int exponentiate(x,n):  raise x to the power n
 * 
 * Precondition: 	n => 0
 */





/*LINTLIBRARY*/
/* #include <values.h> */
/* int absval(int i): absolute value of i (SUN version)
 */





/* int absval_ofl(int i): absolute value of i (SUN version)
 * Overflow control is made and returns to the last setjmp(overflow_error). 
 */





