#ifndef TYPES_POLY_MP_H
#define TYPES_POLY_MP_H

/* there are no Polyhedron_mp (yet ?) */
#include <gmp.h>

typedef struct matrix_mp
{
	unsigned NbRows, NbColumns;
	mpz_t **p;
} Matrix_Mp;

/* data structures for a pseudo-polynomial */
typedef enode_type enode_type_mp;

typedef struct _evalue_mp		/* rational number or pointer */
{ 
	mpz_t d;		/* denominator */
	mpz_t n;		/* numerator (if denominator != 0) */
	struct _enode_mp *p;	/* pointer   (if denominator == 0) */
} evalue_mp;

typedef struct _enode_mp
{
	enode_type_mp type;	/* polynomial or periodic */
	int size;             /* number of attached pointers */
	int pos;		/* parameter position */
	evalue_mp arr[1];	/* array of rational/pointer */
} enode_mp;

typedef struct _enumeration_mp
{
	struct _enumeration_mp *next;  /* next in the list                  */
	Polyhedron *ValidityDomain; 	/* contraints on the parameters      */
	evalue_mp EP;                  /* Ehrhart Polynomial, corresponding
	                               to parameter values inside the
	                               domain ValidityDomain below       */
} Enumeration_mp;


#endif /* TYPES_POLY_MP_H */
