/*       Polyhedron disjoint intersections
*/

/*
 union_disjointe computes the disjoint union of the list of domains given.
 input :
		(integer) # of polyhedra
		list of polyhedra in the usual matrix (constraints) format
*/

#include <stdio.h>
#include <stdlib.h>
#include "types.h"
#include "vector.h"
#include "polyhedron.h"

#define WS 200

/* Modified DomainIntersection that discards degenerate results */
/* (i.e. intersections that are of smaller dimension than the operands) */
static Polyhedron *PDomainIntersection(Pol1, Pol2, NbMaxRays)
     Polyhedron *Pol1, *Pol2;
     unsigned   NbMaxRays;
{   Polyhedron *p1, *p2, *p3, *d;
 
    if (!Pol1 || !Pol2) return (Polyhedron*) 0;
    if (Pol1->Dimension != Pol2->Dimension)
    { fprintf(stderr,"? DomainIntersection: operation on different dimensions");
        return (Polyhedron*) 0;
    }
 
    d = (Polyhedron *)0;
    for (p1=Pol1; p1; p1=p1->next)
    {   for (p2=Pol2; p2; p2=p2->next)
        {   p3 = AddConstraints(p2->Constraint[0],
                                p2->NbConstraints, p1, NbMaxRays);
            if (!p3) continue;
	    if (p3->NbEq!=0) Polyhedron_Free(p3);  /* no new equations */
            else d = AddPolyToDomain (p3, d);
        }
    }
    return d;
} /* PDomainIntersection */

/* Modified DomainDifference which does not put a 1 unit space around cut */
static Polyhedron *PDomainDifference(Pol1, Pol2, NbMaxRays)
     Polyhedron *Pol1, *Pol2;
     unsigned NbMaxRays;
{   Polyhedron *p1, *p2, *p3, *d;
    int i;

    if (!Pol1 || !Pol2) return (Polyhedron*) 0;
    if (Pol1->Dimension != Pol2->Dimension)
    {
        fprintf(stderr,"? DomainDifference: operation on different dimensions");
        return (Polyhedron*) 0;
    }
 
    d = (Polyhedron *)0;
    for (p2=Pol2; p2; p2=p2->next)
    {
        for (p1=Pol1; p1; p1=p1->next)
        {
            for (i=0; i<p2->NbConstraints; i++)
            {
                p3 = SubConstraint(p2->Constraint[i], p1, NbMaxRays,2);
		if (!p3) continue;
		if (emptyQ(p3) || p3->NbEq!=0) Polyhedron_Free(p3);
                else d = AddPolyToDomain (p3, d);
            }
        }
        Pol1 = d;
        d = (Polyhedron *)0;
    }
    return Pol1;
} /* PDomainDifference */


typedef struct LP_ { struct LP_ *next; Polyhedron *P; } LP;

int main()
{
	int np, i;

	Matrix *a;
	LP *P, *lP;
	LP *Result, *lR, *tmp;
	Polyhedron *reste;
	Polyhedron *d1,*d2,*dx;

	scanf( "%d", &np );

	P = Result = NULL;
	for( i=0 ; i<np ; ++i )
	{
		a = Matrix_Read();
		lP = (LP *) malloc( sizeof(LP) );
		lP->next = P;
		lP->P = Constraints2Polyhedron(a, WS);
		Matrix_Free(a);
		P = lP;
	}

	for( lP=P ; lP ; lP=lP->next )
	{
		reste = lP->P;
		/* intersection avec chacun des domaines deja trouves (dans Result) */
		for( lR=Result ; lR && reste ; lR=lR->next )
		{
			dx = PDomainIntersection ( reste, lR->P, WS);
			if( !dx ) continue;
			if ( emptyQ(dx) )
			{	Domain_Free( dx );
				continue;
			}

			d1 = PDomainDifference( reste, lR->P, WS);	/* dans reste */
			d2 = PDomainDifference( lR->P, reste, WS);	/* dans lR->P */

			if( !d1 || emptyQ(d1) )
			{
				if( d1 )
					Domain_Free( d1 );

				if( !d2 || emptyQ(d2) )
				{
					/* d2 = d1 = vide. dx = reste */
					/* dx est le courant. */
					/* on ne fait rien. */
				}
				else
				{
					/* ajoute l'intersection en tete : */
					tmp = (LP *)malloc( sizeof(LP) );
					tmp->next = Result;
					tmp->P = dx;
					Result = tmp;
					/* remplace le courant par d2 */
					lR->P = d2;
				}
				reste = NULL;
			}
			else
			{
				if( !d2 || emptyQ(d2) )
				{
					if( d2 )
						Domain_Free( d2 );
					/* remplace le courant par dx. */
					lR->P = dx;
					reste = d1;
				}
				else
				{
					/* ajoute d2 en tete */
					tmp = (LP *)malloc( sizeof(LP) );
					tmp->next = Result;
					tmp->P = d2;
					Result = tmp;

					/* remplace le courant par dx. */
					lR->P = dx;

					reste = d1;
				}
			}
		}
		/* s'il reste qqchosea la fin, on le rajoute au debut de Result */
		if( reste )
			if( !emptyQ(reste) )
			{
				lR = (LP *)malloc( sizeof(LP) );
				lR->next = Result;
				lR->P = reste;
				Result = lR;
			}
	}


	for( lR = Result ; lR ; lR=lR->next )
	{
		Polyhedron_Print( stdout, "%3d ", lR->P );
		printf( "---------------------------------------------\n" );
	}

	/* free.... :-) */

	return 0;
}
