/*********************************************************/
/* test for eval_ehrhart                                 */
/* build with :                                          */
/* gcc -Wall -O4 -o eval_test eval_test.c eval_ehrhart.c */

/* written by Emmanuel Jeannot (c) 1997                  */
/*********************************************************/

#include "eval_ehrhart.h"
#include <stdlib.h>

/* use the method of Polyhedron_Alloc of file polyhedron.c */
/* to assign D->P-Init a 1D array to D->Constraint a 2D array*/
void evalue_poly(Polyhedron *D){
  int i,*p,**q;
  int NbRows,NbColumns;

  NbRows=D->NbConstraints;
  NbColumns=D->Dimension+2;
  
  p=D->p_Init;
  D->Constraint    = q = (int **)malloc(NbRows * sizeof(int *));
   for (i=0;i<NbRows;i++)
  { *q++ = p;
    p += NbColumns;
  }
}




void evalue_domain(Enumeration *en){
  if(en){
    evalue_domain(en->next);
    evalue_poly(en->ValidityDomain);
  }
}

Enumeration *built_poly2(){
  static done=0;
  static Enumeration en0;
  static int init0[6]=
  {1,1,-10,1,0,1};
  static Polyhedron D0={NULL,1,2,2,0,0,NULL,NULL,init0};
  static evalue ev0_;
  static evalue ev0_0_0_={1,{-44}};
  static evalue ev0_0_1_={1,{11}};
  static enode *p0_0_;
  static Enumeration en1;
  static int init1[6]=
  {1,1,0,1,-1,10};
  static Polyhedron D1={NULL,1,2,2,0,0,NULL,NULL,init1};
  static evalue ev1_;
  static evalue ev1_0_0_={1,{1}};
  static evalue ev1_0_1_={2,{3}};
  static evalue ev1_0_2_={2,{1}};
  static enode *p1_0_;
  if(done){
    printf("Poly2: allready built\n");
  } else {
    p1_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p1_0_->type=polynomial;
    p1_0_->size=3;
    p1_0_->pos=1;
    p1_0_->arr[0]=ev1_0_0_;
    p1_0_->arr[1]=ev1_0_1_;
    p1_0_->arr[2]=ev1_0_2_;
    ev1_.x.p=p1_0_;
    ev1_.d=0;
    en1.next=NULL;
    en1.ValidityDomain=&D1;
    en1.EP=ev1_;
    p0_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p0_0_->type=polynomial;
    p0_0_->size=2;
    p0_0_->pos=1;
    p0_0_->arr[0]=ev0_0_0_;
    p0_0_->arr[1]=ev0_0_1_;
    ev0_.x.p=p0_0_;
    ev0_.d=0;
    en0.next=&en1;
    en0.ValidityDomain=&D0;
    en0.EP=ev0_;
    evalue_domain(&en0);

    done=1;
  }
  return(&en0);
}
Enumeration *built_poly1(){
  static done=0;
  static Enumeration en0;
  static int init0[12]=
  {1,1,-1,0,1,0,1,-1,1,0,0,1};
  static Polyhedron D0={NULL,2,3,3,0,0,NULL,NULL,init0};
  static evalue ev0_;
  static evalue ev0_0_0_={1,{0}};
  static evalue ev0_0_1_={2,{1}};
  static evalue ev0_0_2_={2,{1}};
  static enode *p0_0_;
  static Enumeration en1;
  static int init1[12]=
  {1,2,-1,-1,1,-1,1,0,1,0,0,1};
  static Polyhedron D1={NULL,2,3,3,0,0,NULL,NULL,init1};
  static evalue ev1_;
  static evalue ev1_0_0_;
  static evalue ev1_0_0_0_0_={1,{0}};
  static evalue ev1_0_0_0_1_={1,{-1}};
  static evalue ev1_0_0_0_2_={1,{-1}};
  static enode *p1_0_0_0_;
  static evalue ev1_0_1_;
  static evalue ev1_0_1_0_0_={2,{3}};
  static evalue ev1_0_1_0_1_={1,{3}};
  static enode *p1_0_1_0_;
  static evalue ev1_0_2_={2,{-3}};
  static enode *p1_0_;
  static Enumeration en2;
  static int init2[12]=
  {1,-2,1,1,1,3,-1,-2,1,0,0,1};
  static Polyhedron D2={NULL,2,3,3,0,0,NULL,NULL,init2};
  static evalue ev2_;
  static evalue ev2_0_0_;
  static evalue ev2_0_0_0_0_={1,{0}};
  static evalue ev2_0_0_0_1_={2,{1}};
  static evalue ev2_0_0_0_2_={2,{1}};
  static enode *p2_0_0_0_;
  static evalue ev2_0_1_;
  static evalue ev2_0_1_0_0_={2,{-3}};
  static evalue ev2_0_1_0_1_={1,{-3}};
  static enode *p2_0_1_0_;
  static evalue ev2_0_2_={2,{9}};
  static enode *p2_0_;
  if(done){
    printf("Poly1: Allreadybuilt\n");
  } else {
    p2_0_0_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p2_0_0_0_->type=polynomial;
    p2_0_0_0_->size=3;
    p2_0_0_0_->pos=2;
    p2_0_0_0_->arr[0]=ev2_0_0_0_0_;
    p2_0_0_0_->arr[1]=ev2_0_0_0_1_;
    p2_0_0_0_->arr[2]=ev2_0_0_0_2_;
    ev2_0_0_.x.p=p2_0_0_0_;
    ev2_0_0_.d=0;
    p2_0_1_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p2_0_1_0_->type=polynomial;
    p2_0_1_0_->size=2;
    p2_0_1_0_->pos=2;
    p2_0_1_0_->arr[0]=ev2_0_1_0_0_;
    p2_0_1_0_->arr[1]=ev2_0_1_0_1_;
    ev2_0_1_.x.p=p2_0_1_0_;
    ev2_0_1_.d=0;
    p2_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p2_0_->type=polynomial;
    p2_0_->size=3;
    p2_0_->pos=1;
    p2_0_->arr[0]=ev2_0_0_;
    p2_0_->arr[1]=ev2_0_1_;
    p2_0_->arr[2]=ev2_0_2_;
    ev2_.x.p=p2_0_;
    ev2_.d=0;
    en2.next=NULL;
    en2.ValidityDomain=&D2;
    en2.EP=ev2_;
    p1_0_0_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p1_0_0_0_->type=polynomial;
    p1_0_0_0_->size=3;
    p1_0_0_0_->pos=2;
    p1_0_0_0_->arr[0]=ev1_0_0_0_0_;
    p1_0_0_0_->arr[1]=ev1_0_0_0_1_;
    p1_0_0_0_->arr[2]=ev1_0_0_0_2_;
    ev1_0_0_.x.p=p1_0_0_0_;
    ev1_0_0_.d=0;
    p1_0_1_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p1_0_1_0_->type=polynomial;
    p1_0_1_0_->size=2;
    p1_0_1_0_->pos=2;
    p1_0_1_0_->arr[0]=ev1_0_1_0_0_;
    p1_0_1_0_->arr[1]=ev1_0_1_0_1_;
    ev1_0_1_.x.p=p1_0_1_0_;
    ev1_0_1_.d=0;
    p1_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p1_0_->type=polynomial;
    p1_0_->size=3;
    p1_0_->pos=1;
    p1_0_->arr[0]=ev1_0_0_;
    p1_0_->arr[1]=ev1_0_1_;
    p1_0_->arr[2]=ev1_0_2_;
    ev1_.x.p=p1_0_;
    ev1_.d=0;
    en1.next=&en2;
    en1.ValidityDomain=&D1;
    en1.EP=ev1_;
    p0_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p0_0_->type=polynomial;
    p0_0_->size=3;
    p0_0_->pos=2;
    p0_0_->arr[0]=ev0_0_0_;
    p0_0_->arr[1]=ev0_0_1_;
    p0_0_->arr[2]=ev0_0_2_;
    ev0_.x.p=p0_0_;
    ev0_.d=0;
    en0.next=&en1;
    en0.ValidityDomain=&D0;
    en0.EP=ev0_;
    evalue_domain(&en0);

    done=1;
  }
  return(&en0);
}


Enumeration *built_poly3(){
  static done=0;
  static Enumeration en0;
  static int init0[12]=
  {1,1,-1,0,1,0,1,0,1,0,0,1};
  static Polyhedron D0={NULL,2,3,3,0,0,NULL,NULL,init0};
  static evalue ev0_;
  static evalue ev0_0_0_;
  static evalue ev0_0_0_0_0_={1,{1}};
  static evalue ev0_0_0_0_1_={8,{3}};
  static enode *p0_0_0_0_;
  static evalue ev0_0_1_;
  static evalue ev0_0_1_0_0_={4,{3}};
  static evalue ev0_0_1_0_1_={2,{1}};
  static enode *p0_0_1_0_;
  static evalue ev0_0_2_={8,{1}};
  static enode *p0_0_;
  static Enumeration en1;
  static int init1[12]=
  {1,2,-1,0,1,-1,1,0,1,0,0,1};
  static Polyhedron D1={NULL,2,3,3,0,0,NULL,NULL,init1};
  static evalue ev1_;
  static evalue ev1_0_0_;
  static evalue ev1_0_0_0_0_;
  static evalue ev1_0_0_0_0_0_0_={1,{1}};
  static evalue ev1_0_0_0_0_0_1_={8,{3}};
  static enode *p1_0_0_0_0_0_;
  static evalue ev1_0_0_0_1_;
  static evalue ev1_0_0_0_1_0_0_={4,{1}};
  static evalue ev1_0_0_0_1_0_1_={1,{0}};
  static enode *p1_0_0_0_1_0_;
  static evalue ev1_0_0_0_2_={8,{-3}};
  static enode *p1_0_0_0_;
  static evalue ev1_0_1_;
  static evalue ev1_0_1_0_0_={2,{1}};
  static evalue ev1_0_1_0_1_={1,{1}};
  static enode *p1_0_1_0_;
  static evalue ev1_0_2_={2,{-1}};
  static enode *p1_0_;
  if(done){
    printf("Poly3: allready built\n");
  } else {
    p1_0_0_0_0_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p1_0_0_0_0_0_->type=periodic;
    p1_0_0_0_0_0_->size=2;
    p1_0_0_0_0_0_->pos=2;
    p1_0_0_0_0_0_->arr[0]=ev1_0_0_0_0_0_0_;
    p1_0_0_0_0_0_->arr[1]=ev1_0_0_0_0_0_1_;
    ev1_0_0_0_0_.x.p=p1_0_0_0_0_0_;
    ev1_0_0_0_0_.d=0;
    p1_0_0_0_1_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p1_0_0_0_1_0_->type=periodic;
    p1_0_0_0_1_0_->size=2;
    p1_0_0_0_1_0_->pos=2;
    p1_0_0_0_1_0_->arr[0]=ev1_0_0_0_1_0_0_;
    p1_0_0_0_1_0_->arr[1]=ev1_0_0_0_1_0_1_;
    ev1_0_0_0_1_.x.p=p1_0_0_0_1_0_;
    ev1_0_0_0_1_.d=0;
    p1_0_0_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p1_0_0_0_->type=polynomial;
    p1_0_0_0_->size=3;
    p1_0_0_0_->pos=2;
    p1_0_0_0_->arr[0]=ev1_0_0_0_0_;
    p1_0_0_0_->arr[1]=ev1_0_0_0_1_;
    p1_0_0_0_->arr[2]=ev1_0_0_0_2_;
    ev1_0_0_.x.p=p1_0_0_0_;
    ev1_0_0_.d=0;
    p1_0_1_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p1_0_1_0_->type=polynomial;
    p1_0_1_0_->size=2;
    p1_0_1_0_->pos=2;
    p1_0_1_0_->arr[0]=ev1_0_1_0_0_;
    p1_0_1_0_->arr[1]=ev1_0_1_0_1_;
    ev1_0_1_.x.p=p1_0_1_0_;
    ev1_0_1_.d=0;
    p1_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p1_0_->type=polynomial;
    p1_0_->size=3;
    p1_0_->pos=1;
    p1_0_->arr[0]=ev1_0_0_;
    p1_0_->arr[1]=ev1_0_1_;
    p1_0_->arr[2]=ev1_0_2_;
    ev1_.x.p=p1_0_;
    ev1_.d=0;
    en1.next=NULL;
    en1.ValidityDomain=&D1;
    en1.EP=ev1_;
    p0_0_0_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p0_0_0_0_->type=periodic;
    p0_0_0_0_->size=2;
    p0_0_0_0_->pos=2;
    p0_0_0_0_->arr[0]=ev0_0_0_0_0_;
    p0_0_0_0_->arr[1]=ev0_0_0_0_1_;
    ev0_0_0_.x.p=p0_0_0_0_;
    ev0_0_0_.d=0;
    p0_0_1_0_=(enode*)malloc(sizeof(enode)+2*(2-1)*sizeof(int));
    p0_0_1_0_->type=periodic;
    p0_0_1_0_->size=2;
    p0_0_1_0_->pos=2;
    p0_0_1_0_->arr[0]=ev0_0_1_0_0_;
    p0_0_1_0_->arr[1]=ev0_0_1_0_1_;
    ev0_0_1_.x.p=p0_0_1_0_;
    ev0_0_1_.d=0;
    p0_0_=(enode*)malloc(sizeof(enode)+2*(3-1)*sizeof(int));
    p0_0_->type=polynomial;
    p0_0_->size=3;
    p0_0_->pos=2;
    p0_0_->arr[0]=ev0_0_0_;
    p0_0_->arr[1]=ev0_0_1_;
    p0_0_->arr[2]=ev0_0_2_;
    ev0_.x.p=p0_0_;
    ev0_.d=0;
    en0.next=&en1;
    en0.ValidityDomain=&D0;
    en0.EP=ev0_;
    evalue_domain(&en0);

    done=1;
  }
  return(&en0);
}


int  main(){
  int res;
  int p[2];
  Enumeration *en;
  en=built_poly2();
  p[0] = 2;
  res=compute_poly(en,p);
  printf("poly2(2)=%d\n\n",res);
  en=built_poly1();
  p[0] = 2; p[1] = 3;
  res=compute_poly(en,p);
  printf("poly1(2,3)=%d\n\n",res);
  en=built_poly2();
  p[0] = 12;
  res=compute_poly(en,p);
  printf("poly2(12)=%d\n\n",res);
  en=built_poly1();
  p[0] = 3; p[1] = 6;
  res=compute_poly(en,p);
  printf("poly1(3,6)=%d\n\n",res);
  en=built_poly3();
  p[0] = 2; p[1] = 3;
  res=compute_poly(en,p);
  printf("poly3(2,3)=%d\n\n",res);
  en=built_poly3();
  p[0] = 3; p[1] = 4;
  res=compute_poly(en,p);
  printf("poly3(3,4)=%d\n\n",res);
  en=built_poly3();
  p[0] = 2; p[1] = 1;
  res=compute_poly(en,p);
  printf("poly3(2,1)=%d\n\n",res);
  en=built_poly3();
  p[0] = 3; p[1] = 2;
  res=compute_poly(en,p);
  printf("poly3(3,2)=%d\n\n",res);
  return res;
}
