/* gtk_windows.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
/************************************************************************/
/*routines for :														*/
/*	- creation of the gtk windows  										*/
/* 	- gtk event handling code for actions in windows					*/
/************************************************************************/
#include <gtk/gtk.h>
#include <math.h>
#include <stdlib.h>

#include "gtk_domain.h"
#include "gtk_repere.h"
#include "domains.h"
#include "gtk_ddraw.h"
#include "icon.xpm"
#include "repere_icon.xpm"

/*--- global variables ----*/
GtkWidget *domain_frame;
GtkWidget *rep_frame;
GtkWidget *domain_canvas;
GtkWidget *rep_canvas;
GtkWidget *pt_selected_panel;
GtkWidget **B_Tab,**L_Tab;  /* labels and text entries for parameters */
int prevx,prevy;
GdkDrawable *rg = NULL;	/*--- pixmap for domain drawing ---*/
GdkDrawable *dg = NULL; /*--- pixmap for projection drawing ---*/
GdkGC *rgGC;
GdkGC *dgGC;
 
/********************* CALLBACKS FOR DOMAIN *****************************/

/************************************************************************/
/* Create a new backing pixmap of the appropriate size 					*/
/* configure_event is issued for window creation and resizing			*/
/************************************************************************/
static gint 
domain_configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
	 GdkColor *c;

   if (dg)
     gdk_pixmap_unref(dg);
    
   /*--create a new pixmap ------------*/
   dg  = gdk_pixmap_new(widget->window,
                          widget->allocation.width,
                          widget->allocation.height,
                          -1);

    c = (GdkColor *) g_malloc (sizeof (GdkColor));
    c->red = 0;
    c->green = 0;
    c->blue = 0;
    gdk_color_alloc (gdk_colormap_get_system (), c);

   dgGC = gdk_gc_new (widget->window); 		  
	gdk_gc_set_foreground (dgGC, c);

   Width = widget->allocation.width;
   Height = widget->allocation.height;

   /*--creates a new pixmap --------------*/
   gdk_draw_rectangle (dg,
                      widget->style->white_gc,
                      TRUE,
                      0, 0,
                      widget->allocation.width,
                      widget->allocation.height);      
  	      
  domain_redraw(dg); /* draw domain in the backing domain_pixmap */
  return TRUE;
}
/************************************************************************/
/* domain_expose_event()												*/
/* redraw the content of the window from the backing domain_pixmap		*/
/************************************************************************/
static gint 
domain_expose_event(GtkWidget *widget,GdkEventExpose *event)
{  
	/* draw the contents of the domain pixmap */
	gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  dg,
                  event->area.x, event->area.y,
                  event->area.x, event->area.y,
                  event->area.width, event->area.height);
	return(FALSE);	  
}
 
/************************************************************************/
/* domain_button_press_event()						*/
/************************************************************************/
static void 
domain_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	domain_event(event->x,event->y);
}
/****************** CALLBACKS FOR PROJECTION WINDOW *********************/


/************************************************************************/
/* repere_configure_event()						*/
/* Create a new backing pixmap of the appropriate size 			*/
/************************************************************************/
gint repere_configure_event (GtkWidget *widget, GdkEventConfigure *event) 
{
  GdkColor *c;

  if ( rg )
	gdk_pixmap_unref( rg );

  /*--create a new pixmap ------------*/
  rg  = gdk_pixmap_new(widget->window,
                          widget->allocation.width,
                          widget->allocation.height,
                          -1);
  c = (GdkColor *) g_malloc (sizeof (GdkColor));
  c->red = 0;
  c->green = 0;
  c->blue = 0;
  gdk_color_alloc (gdk_colormap_get_system (), c);

  rgGC = gdk_gc_new (widget->window);
  gdk_gc_set_foreground (rgGC, c);
  
  /*--create a new pixmap ------------*/
  gdk_draw_rectangle (rg,
                      widget->style->white_gc,
                      TRUE,
                      0, 0,
                      widget->allocation.width,
                      widget->allocation.height);

  repere_redraw( rg );
  return TRUE;
}
/************************************************************************/
/* repere_motion_notify_event()	: mouse movement                    */
/************************************************************************/
gboolean
repere_motion_notify_event (GtkWidget *widget,GdkEventMotion *event, gpointer user_data)
{
static int selected;
int i;
float dist=0;
GdkModifierType state;
int x,y;
 
  if (event->is_hint) { 
  	/* --- Get new position --- */
        gdk_window_get_pointer (event->window, &x, &y, &state);
  }
  else {
	/* --- Get new position --- */
        x = event->x;
        y = event->y;
        state = event->state;
  }
  /* --- If the mouse button is down --- */
  if (state & GDK_BUTTON1_MASK && rg != NULL) {
  	/*--- choix de l'axe selectionnee -----*/
	selected = -1;
	for( i=0 ; i<DimNP ; ++i ) {
		float xt, yt, disttmp;

		xt = ((float)(x -BORD)/repere.width) *
					(repere.maxx-repere.minx)+repere.minx - repere.matrice[i][0];
		yt = ((float)(repere.height+BORD-y)/repere.height) *
					(repere.maxy-repere.miny)+repere.miny - repere.matrice[i][1];

		disttmp = xt*xt + yt*yt;
		if( disttmp<dist || selected == -1 ) {
			dist = disttmp;
			selected = i;
			}
		}
  		repere.matrice[selected][0] =
			((float)(x-BORD)/repere.width) *
			(repere.maxx-repere.minx)+repere.minx;
		repere.matrice[selected][1] =
			((float)(repere.height+BORD-y)/repere.height) *
			(repere.maxy-repere.miny)+repere.miny;	 
	  repere_redraw( rg );
	  domain_redraw( dg );
  }
  else {
 		/*--- button is released : recompute position -----*/
		calc_rep_extr();
		repere_redraw( rg );
  }	
  return(FALSE); /*-- means other events are also considered --*/
}
/************************************************************************/
/* repere_expose_event() : Redraw the screen from the backing pixmap 	*/
/* when Window is created and resized 									*/
/************************************************************************/
gint repere_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
 
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  rg,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);
  return(FALSE);
}
/******************** WINDOW CREATION ***********************************/

/************************************************************************/
/* create_domain_frame () :   											*/
/************************************************************************/
GtkWidget*
create_domain_frame (char **param_name,char *wname,int NbParam)
{
  GtkWidget *hbox2;
  GtkWidget *vbox1;
  GtkWidget *quit_button;
  GtkWidget *view_button;
  GtkWidget *view_int_points_button;
  GtkWidget *hbox3;
  int i;
  GdkPixmap *iconpixmap;
  GdkBitmap *iconmask;
  
 
  domain_frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (domain_frame), "VisuDomain", "VisuDomain");
  gtk_widget_realize(domain_frame);
  iconpixmap = gdk_pixmap_create_from_xpm_d(domain_frame->window, 
				  &iconmask,&domain_frame->style->bg[GTK_STATE_NORMAL],icon_xpm);
  gdk_window_set_icon(domain_frame->window,NULL,iconpixmap,iconmask);
  gdk_window_set_icon_name(domain_frame->window,"Domain");

  gtk_object_set_data (GTK_OBJECT (domain_frame), "domain_frame", domain_frame);
  gtk_container_border_width (GTK_CONTAINER (domain_frame), 1);
  gtk_signal_connect (GTK_OBJECT (domain_frame), "destroy",
                      (GtkSignalFunc)gtk_exit, NULL);

  /* set the name if one was found in inputs or default name */ 
  gtk_window_set_title(GTK_WINDOW (domain_frame),(wname)?wname:"VisuDomain");
  gtk_widget_set_usize (domain_frame, 300, 300);
  
  /*-----policy is : allow shrink,allow_grow, not auto_shrink -----------*/
  gtk_window_set_policy (GTK_WINDOW (domain_frame), TRUE, TRUE, FALSE);
 
  hbox2 = gtk_hbox_new (FALSE, 0);
  /*gtk_widget_show (hbox2);*/
 

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (domain_frame), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox2), vbox1, FALSE, FALSE, 0);

  /*---- "Quit" button -----*/
  quit_button = gtk_button_new_with_label ("Quit");  
  gtk_object_set_data (GTK_OBJECT (domain_frame), "quit_button", quit_button);
  gtk_signal_connect_object (GTK_OBJECT (quit_button), "clicked",
                            (GtkSignalFunc)gtk_exit,
                             GTK_OBJECT (domain_frame));
  gtk_widget_show (quit_button);
  gtk_box_pack_start (GTK_BOX (vbox1), quit_button, FALSE, FALSE, 0);
  gtk_widget_set_usize (quit_button, 100, -1);
  gtk_container_border_width (GTK_CONTAINER (quit_button), 3);

  /*---- "View projection" button -----*/
  
  view_button = gtk_button_new_with_label ("View projection");
  gtk_object_set_data (GTK_OBJECT (domain_frame), "view_button", view_button);
  gtk_signal_connect_object (GTK_OBJECT (view_button), "clicked",
                             GTK_SIGNAL_FUNC (active_repere),NULL);
  gtk_widget_show (view_button);
  gtk_box_pack_start (GTK_BOX (vbox1), view_button, FALSE, FALSE, 0);

  /*---- "View Int Points" button -----*/
  
  view_int_points_button = gtk_button_new_with_label ("View IntPoints");
  gtk_object_set_data (GTK_OBJECT (domain_frame), "view_int_points_button",
                       view_int_points_button);
  gtk_signal_connect_object (GTK_OBJECT (view_int_points_button), "clicked",
                             GTK_SIGNAL_FUNC (active_intpoints),NULL);
  gtk_widget_show (view_int_points_button);
  gtk_box_pack_start (GTK_BOX (vbox1), view_int_points_button, FALSE, FALSE, 0);

  /*----                          -----*/
  hbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (domain_frame), "hbox3", hbox3);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);
  gtk_widget_set_usize (hbox3, 100, -1);

  /*---- now creates as many labels and text entries as parameters -----*/
  B_Tab = (GtkWidget **)malloc( NbParam*sizeof(GtkWidget *));
  L_Tab = (GtkWidget **)malloc( NbParam*sizeof(GtkWidget *));
  for( i=0 ; i<NbParam ; ++i ) {
	char s[256];
	/****  noms des parametres (M1, M2, ... si pas defini) ********/
	if( param_name )
		sprintf( s, "%s = ", param_name[i] );
	else
		sprintf( s, "M%d = ", i+1 );
			
	/* creates labels and text entries for params */
 	L_Tab[i] = gtk_label_new (s);
  	gtk_widget_show (L_Tab[i]);
	gtk_box_pack_start (GTK_BOX (hbox3), L_Tab[i], FALSE, FALSE, 0);
        gtk_widget_set_usize (L_Tab[i], 30, -1);
	
  	B_Tab[i] = gtk_entry_new_with_max_length (3);
  	gtk_object_set_data (GTK_OBJECT (domain_frame), "B_Tab", B_Tab);
  	gtk_widget_show (B_Tab[i]);
  	gtk_box_pack_start (GTK_BOX (hbox3), B_Tab[i], FALSE, FALSE, 0);
  	gtk_widget_set_usize (B_Tab[i], 50, -1);
 
	gtk_signal_connect(GTK_OBJECT(B_Tab[i]), "activate",
                             GTK_SIGNAL_FUNC(chg_param),
                             B_Tab[i]);
	gtk_signal_connect(GTK_OBJECT(B_Tab[i]), "changed",
                             GTK_SIGNAL_FUNC(chg_param),
                             B_Tab[i]);
	ValidParam[i] = 0;
  }
  /*--- creates a label to display coordinates of a selected point ----*/
  is_pt_selected = 0;
  pt_selected_panel = gtk_label_new ("");
  gtk_object_set_data (GTK_OBJECT (domain_frame), "pt_select", pt_selected_panel);
  gtk_widget_show (pt_selected_panel);
  gtk_box_pack_start (GTK_BOX (vbox1), pt_selected_panel, FALSE,FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (pt_selected_panel), GTK_JUSTIFY_LEFT);
  /*gtk_misc_set_alignment (GTK_MISC (pt_selected_label), 0.0800002, 0.5);*/

  /*--- creates the drawing area where the domain is drawn  ----*/
  domain_canvas = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (domain_frame), "domain_canvas", domain_canvas);
  gtk_box_pack_start (GTK_BOX (hbox2), domain_canvas, TRUE, TRUE, 0);
  gtk_widget_set_usize (domain_canvas, 200, 200);
  gtk_widget_set_events (domain_canvas, GDK_EXPOSURE_MASK|
  					GDK_BUTTON_PRESS_MASK);
   
  /*---- handlers of events in the drawing area ------------------*/
  gtk_signal_connect (GTK_OBJECT (domain_canvas), "expose_event",
                      (GtkSignalFunc)  domain_expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT(domain_canvas),"configure_event",
                      (GtkSignalFunc) domain_configure_event, NULL);
		   
  /*---- handler for trying to select a point ---------------------*/   
  gtk_signal_connect (GTK_OBJECT (domain_canvas), "button_press_event",
                      (GtkSignalFunc)  domain_button_press_event, NULL);
		     

  gtk_widget_show (domain_canvas);
  gtk_container_add (GTK_CONTAINER (domain_frame), hbox2);
  gtk_widget_show (hbox2);
  
  return(domain_frame);
}
/************************************************************************/
/* create_rep_frame ()													*/
/************************************************************************/
GtkWidget*
create_rep_frame ()
{
 GdkPixmap *iconpixmap;
 GdkBitmap *iconmask;
 
  rep_frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_object_set_data (GTK_OBJECT (rep_frame), "rep_frame", rep_frame);
  gtk_window_set_title (GTK_WINDOW (rep_frame), "View projection");
  gtk_window_set_policy (GTK_WINDOW (rep_frame), TRUE, TRUE, FALSE);

/*----@MODIF S.G. cause problems with the move/resize of axis with
gtk-1.2.3
 gdk_window_set_cursor (rep_frame->window, gdk_cursor_new (GDK_HAND2));
 ----------*/

  rep_canvas = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (rep_frame), "rep_canvas", rep_canvas);
  gtk_widget_show (rep_canvas);
  gtk_container_add (GTK_CONTAINER (rep_frame), rep_canvas);
  gtk_widget_set_usize (rep_canvas, 150, 150);
  gtk_widget_set_events (rep_canvas, 	
				    GDK_EXPOSURE_MASK | 
  					GDK_BUTTON_PRESS_MASK |
					GDK_BUTTON_RELEASE_MASK |
					GDK_POINTER_MOTION_MASK |
					GDK_POINTER_MOTION_HINT_MASK );  
					
  /*--- when window is resized or created ---*/
  gtk_signal_connect (GTK_OBJECT (rep_canvas), "configure_event",
                      GTK_SIGNAL_FUNC (repere_configure_event),
                      NULL);
  /*--- when window is exposed ------*/
  gtk_signal_connect (GTK_OBJECT (rep_canvas), "expose_event",
                      GTK_SIGNAL_FUNC (repere_expose_event),
                      NULL);
  /* --- Need to know about mouse movements. --- */
  gtk_signal_connect (GTK_OBJECT (rep_canvas), "motion_notify_event",
                     (GtkSignalFunc) repere_motion_notify_event, NULL);

  /*--- when rep_frame window is killed  ------*/
  gtk_signal_connect (GTK_OBJECT (rep_frame), "delete_event",
                      (GtkSignalFunc) gtk_widget_hide,
                      NULL);
  gtk_signal_connect (GTK_OBJECT (rep_frame), "destroy",
                      (GtkSignalFunc) gtk_widget_hide,
                      NULL);

  return(rep_frame);
}
  
/************************************************************************/
/*   initDomainFrame() :												*/
/************************************************************************/
void initDomainFrame(char **param_name, char *wname,int NbParam )
{
	
    /*---- creates the two windows ------------------*/
    domain_frame = create_domain_frame(param_name,wname,NbParam);
    gtk_widget_show(domain_frame);
    rep_frame = create_rep_frame();
    /* only show rep_frame when view is asked for */; 	  	 

}
