/* gtk_domain.h
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
#ifndef _X_DOMAIN_H
#define _X_DOMAIN_H

#include <polylib/polylib64.h>

#include "visutypes.h"


extern char *CurrentName;
extern Polyhedron *A_Conv, *A_Union, *Contexte, *U_NPDomains, *U_IntPDomains;
extern int DimNP;
extern int NbParam;
extern int *ValidParam;
extern Value *ValeurParam;
extern int is_pt_selected;

extern gboolean ContextOK;

#define SHOW_POL 0
#define SHOW_POINTS 1
#define SHOW_FIRST 2
#define SHOW_LAST 3
#define SHOW_TIMING 4

#define DO(show) (show_mask & (1<<show))

extern int show_timing_n;
extern int show_mask;

extern float MaxX, MaxY, MinX, MinY;
extern int Width, Height;

extern void Warn (char *);
extern void chg_param (GtkWidget * widget, GtkWidget * entry);
extern void domain_redraw (GdkDrawable * pixmap, Domain * domain);
extern void domain_event (int cx, int cy);

#endif
