#ifndef _VISUTYPES_H
#define _VISUTYPES_H

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>

#include <polylib/polylib64.h>


/*********/
/* Macro */
/*********/

/* don't put less than 4 here */
#define MAXDIM 10


/*********/
/* Types */
/*********/

typedef struct SLIST
{
  char *Id;
  int pos;
  struct SLIST *suiv;
}
 *ChainList, t_ChainList;

typedef struct SMATRIX
{
  char *name;
  Matrix *M;
  struct SMATRIX *next;
}
ChainMatrix;

typedef struct INDLIST
{
  int pos;
  Value val;
  struct INDLIST *suiv;
}
 *IndList, t_IndList;

typedef struct _ListValuePoints
{
  Value point[MAXDIM];
  struct _ListValuePoints *next;
}
ListValuePoints;

typedef struct _VisualDomain
{
  Polyhedron *NPdomain;
  int intpoints;
  ListValuePoints *Lpoints;	/* liste des points selectionnes */
}
VisualDomain;

typedef struct _Domain
{
  char *name;
  ChainList v_list;
  Polyhedron *Pdomain;
  GdkColor *color;
  VisualDomain *visual;		/* visual = NULL -> pas affiche */
  struct _Domain *next;
}
Domain;

typedef struct point
{
  float x, y;
} Point;


/**********************/
/* Variables globales */
/**********************/

extern ChainMatrix *MatrixList;	/* */
extern Domain *DomainList;	/* liste exhaustive des domaines */
extern Domain *DomainCurrent;	
extern char *TmpDomainName;
extern char *ContextName;	/* Nom du domaine utilis comme contexte */
extern Matrix *curr_matrix;
extern int curr_constr_num;
extern unsigned int dim;
extern ChainList VarList;
extern int input_error;
extern int reinit;
extern GtkWidget *domain_frame;
G_LOCK_EXTERN(verrou_domains);	/* mutex declaration:
                  'verrou_domains' protects DomainList */
/* extern GCond *cond_fin; */
extern GMutex *fin;


/*************/
/* Fonctions */
/*************/

extern void ListValuePoints_Free (ListValuePoints * list);
extern void VisualDomain_Free (VisualDomain * visual);
extern ListValuePoints * ListValuePoints_Select (Value *pt, 
                                                 ListValuePoints *list);
extern ListValuePoints * ListValuePoints_Insert (Value *pt, 
                                                 ListValuePoints *list);
extern void ListValuePoints_Write (ListValuePoints *list);
extern ListValuePoints * ListValuePoints_Update (Domain *UpDomain);

extern void init_visu ( void );

#endif /*  */
