#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "visutypes.h"
#include "domains.h"
#include "gtk_properties.h"
#include "gtk_windows.h"
#include "gtk_domain.h"
#include "gtk_ddraw.h"
#include "gtk_repere.h"

/* Variables globales */
GtkWidget *ColorDlg = NULL;
GdkColor Color;
GdkPixmap *Dlg_pixmap;
GdkBitmap *Dlg_mask;

GtkWidget *properties_button, *clist, *DlgWindow = NULL;

gint row_selected, col_selected;
int NbRows;

/*----------------------------------------------------------------------------*/

/*
  Insre (en queue) un domaine dans la liste graphique 
*/
void graphic_list_insert (Domain * new)
{
  /* Le domaine n'est pas affich (sinon il a dj t insr) */
  gchar *text[4];
  int i, j;

  /* Cela ne doit jamais arriver! */
  if (new == NULL)
    return;

  /* On n'insere que les domaine vide qui peuvent tre affichs... */
  if ((new->Pdomain->Dimension - NbParam) != DimNP)
    return;

  text[0] = g_strdup (new->name);
  text[1] = g_strdup ("Masked");
  text[2] = g_strdup ("Yes");
  text[3] = g_strdup ("Black");
  j = gtk_clist_append (GTK_CLIST (clist), text);
  gtk_clist_set_foreground (GTK_CLIST (clist), j, new->color);
  gtk_clist_set_row_data (GTK_CLIST (clist), j, (gpointer) new);
  for (i = 0; i < 4; i++)
    {
      gtk_clist_set_text (GTK_CLIST (clist), j, i, text[i]);
      g_free (text[i]);
    }
  NbRows++;
  return;
}

/*
  Insre (en tte) un domaine dans la liste graphique 
*/
void graphic_list_update (Domain * new)
{
  /* Le domaine n'est pas affich (sinon il a dj t insr) */
  gchar *text[4];
  int i, j;

  /* Cela ne doit jamais arriver! */
  if (new == NULL)
    return;

  /* On n'insere que les domaines qui peuvent tre affichs... */
  if ((new->Pdomain->Dimension - NbParam) != DimNP)
    return;

  text[0] = g_strdup (new->name);
  text[1] = g_strdup ("Masked");
  text[2] = g_strdup ("Yes");
  text[3] = g_strdup ("Black");
  j = gtk_clist_prepend (GTK_CLIST (clist), text);
  gtk_clist_set_foreground (GTK_CLIST (clist), j, new->color);
  gtk_clist_set_row_data (GTK_CLIST (clist), j, (gpointer) new);
  for (i = 0; i < 4; i++)
    {
      gtk_clist_set_text (GTK_CLIST (clist), j, i, text[i]);
      g_free (text[i]);
    }
  NbRows++;
  return;
}


/*
  Efface un domaine dans la liste graphique 
*/
void graphic_list_delete (Domain * old)
{
  gint row;
  gboolean test;
  char *Status;

  /* paranoia */
  if (old == NULL)
    return;

  /* Recherche du domaine dans la liste graphique */
  row = gtk_clist_find_row_from_data (GTK_CLIST (clist), (gpointer) old);
  if (row < 0)
    {
      /* paranoia */
      Warn("Can't find domain to be deleted!");
      return;
    }

  test = gtk_clist_get_text (GTK_CLIST (clist), row, 1, &Status);
  if (strcmp ("Visu", Status) == 0)
    {
      /* Le domaine tait affich, il faut le masquer */
      gtk_clist_select_row (GTK_CLIST (clist), row, 1);
    }

  gtk_clist_remove (GTK_CLIST (clist), row);
  NbRows--;
  return;
}

/*
  un-visualize a domain (graphic list)
*/
void graphic_list_unvisu (Domain * old)
{
  gint row;
  gboolean test;
  char *Status;

  /* paranoia */
  if (old == NULL)
    return;

  /* Recherche du domaine dans la liste graphique */
  row = gtk_clist_find_row_from_data (GTK_CLIST (clist), (gpointer) old);
  if (row < 0)
    {
      /* paranoia */
      Warn("Can't find domain to be unvisualized!");
      return;
    }

  test = gtk_clist_get_text (GTK_CLIST (clist), row, 1, &Status);
  if (strcmp ("Visu", Status) == 0)
    {
      /* Le domaine tait affich, il faut le masquer */
      gtk_clist_set_text (GTK_CLIST (clist), row, 1, "(visu)" );
    }

// ????????????????????????????????????????
  gtk_clist_remove (GTK_CLIST (clist), row);
  NbRows--;
  return;
}

/*
  Masque tous les domaines de la liste graphique
*/
void mask_all_domains (GtkCList * list)
{
  gint row;
  Domain *d;

  /* Masquer tous les domaines */
	for( d=DomainList; d; d=d->next )
		if( d->visual )
		{
			row = gtk_clist_find_row_from_data (GTK_CLIST (clist),(gpointer) d);
			gtk_clist_select_row (GTK_CLIST (clist), row, 1);
		}

	return;
}


/*************************************/
/* Callback du selecteur de couleur: */
/*************************************/

gboolean ChangeColor (GtkColorSelection * sel)
{
  gboolean test;
  Domain *domain;

  domain = gtk_clist_get_row_data (GTK_CLIST (clist), row_selected);
  gtk_color_selection_get_current_color (sel, &Color);
  test = gdk_color_alloc (gdk_colormap_get_system (), &Color);
  if (test == TRUE)
    {
      /* M--j de la structure du domaine */
      if (domain->color)
	gdk_color_free (domain->color);
      domain->color = gdk_color_copy (&Color);

      /* M--j de la liste graphique */
      gtk_clist_set_foreground (GTK_CLIST (clist), row_selected, &Color);
      if ((Color.red == 0)
          && (Color.green == 0)
	  && (Color.blue == 0))
	gtk_clist_set_text (GTK_CLIST (clist), row_selected,
	                    col_selected, "Black");
      else
        gtk_clist_set_text (GTK_CLIST (clist), row_selected,
		  	    col_selected, "New Color");
      return TRUE;
    }
  else
    return FALSE;
}


/*************************************************/
/* Cration du dialogue de slection de couleur: */
/*************************************************/

void color_selector (void)
{
  gint response;
  GtkColorSelection *colorsel;
  ColorDlg = gtk_color_selection_dialog_new ("Domain's Color");
  colorsel =
    GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (ColorDlg)->colorsel);

  /* Ajout d'une palette de couleurs  la fentre ColorDlg */
  gtk_color_selection_set_has_palette (colorsel, TRUE);

  /* Comparaison avec la dernire couleur slectionne */
  gtk_color_selection_set_previous_color (colorsel, &Color);
  gtk_color_selection_set_current_color (colorsel, &Color);

  /* La fentre ColorDlg doit tre modale */
  gtk_window_set_modal (GTK_WINDOW (ColorDlg), TRUE);

  /* Gestion des signaux du bouton 'OK' */
  gtk_signal_connect_object (GTK_OBJECT
			     ((GTK_COLOR_SELECTION_DIALOG
			       (ColorDlg))->ok_button), "clicked",
			     GTK_SIGNAL_FUNC (ChangeColor),
			     GTK_OBJECT (GTK_COLOR_SELECTION (colorsel)));

  /* Affichage du dialogue */
  response = gtk_dialog_run (GTK_DIALOG (ColorDlg));
  if (response == GTK_RESPONSE_OK)
    gtk_color_selection_get_current_color (colorsel, &Color);
  gtk_widget_destroy (GTK_WIDGET (ColorDlg));
  return;
}

/************************************************/
/* Callbacks de la fentre "Domains" */
/************************************************/

gboolean
PropertiesActions (GtkCList * list, gint row, gint col,
		   GdkEvent * event, gpointer data)
{
  char *Status;
  gboolean test;
  GdkColor black;
  Domain *domain;
  row_selected = row;
  col_selected = col;
  domain = gtk_clist_get_row_data (GTK_CLIST (list), row);
  gtk_clist_unselect_row (GTK_CLIST (list), row, col);
  test = gtk_clist_get_text (GTK_CLIST (list), row, 1, &Status);
  G_LOCK (verrou_domains);
  switch (col)
    {
    case 3:			/* Colonne 'Color' */
      /* Choix d'une couleur et m--j */
      color_selector ();
      break;

    case 2:			/* Colonne 'Intpoints' */
      /* Modifiable seulement si le domaine est affich */
      if (strcmp ("Visu", Status) == 0)
	{
	  /* Modifier la structure du domaine en consquence */
	  domain->visual->intpoints = !domain->visual->intpoints;
	  gtk_clist_get_text (GTK_CLIST (clist), row, col, &Status);

	  /* M--j de la liste graphique */
	  if (strcmp ("Yes", Status) == 0)
	    gtk_clist_set_text (GTK_CLIST (clist), row, col, "No");
	  else
	    gtk_clist_set_text (GTK_CLIST (clist), row, col, "Yes");
	}
      break;

    case 1:			/* Colonne 'Status' */
      test = gdk_color_black (gdk_colormap_get_system (), &black);
      if (strcmp ("Masked", Status) != 0)
	{
	  /**********************************/
	  /* Masquer le domaine slectionn */
	  /**********************************/

	  /* Modifier la structure du domaine en consquence */
	  VisualDomain_Free (domain->visual);
	  domain->visual = NULL;

	  /* Effacer la fentre de dessin et redessiner les autres domaines */
	  compute_A_domains ();

	  calc_rep_extr ();
	  
	  /* M--j de la liste graphique */
	  gtk_clist_set_foreground (GTK_CLIST (clist), row, domain->color);
	  gtk_clist_set_text (GTK_CLIST (clist), row, col, "Masked");
	  gtk_clist_set_text (GTK_CLIST (clist), row, 2, "Yes");
	}
      else
	{
	  /***********************************/
	  /* Afficher le domaine slectionn */
	  /***********************************/

	  if (NbParam > 0)
	      /*--- Visualisation de domaines paramtrs ---*/
	      Affich_P_domains (domain, row);
	  else
		  Affich_NOT_P_domains (domain, row);
	  /* M--j de la liste des points slectionns */
          if (domain->visual)
	    {
	     if (domain->visual->Lpoints)
	        ListValuePoints_Free (domain->visual->Lpoints);
	     domain->visual->Lpoints = NULL;
	     domain->visual->Lpoints = ListValuePoints_Update (domain);
	     }
	}
      break;
    default:			/* Colonne 'Name' ou erreur interne */
      G_UNLOCK (verrou_domains);
      return FALSE;
    };
  /* Affichage */
  domain_redraw (dg, NULL);
  G_UNLOCK (verrou_domains);
  return TRUE;
}

gboolean MoveDomain (GtkCList *list, gint old, gint new, gpointer data)
{
  Domain *Dcur, *Dprev, *Dmove, *Dtmp;
  
  Dprev = NULL;
  G_LOCK (verrou_domains);
  Dcur = DomainList;
  Dmove = gtk_clist_get_row_data (GTK_CLIST (list), old);
  while (Dcur && (Dcur != Dmove))
    {
     Dprev = Dcur;
     Dcur = Dcur->next;
     }
  if (!Dcur)
    {
     Warn ("Problem to move a domain in the list!");
     return FALSE;
     }
  if (Dprev)
     Dprev->next = Dcur->next;
  else 
     DomainList = Dcur->next;
  Dtmp = gtk_clist_get_row_data (GTK_CLIST (list), new ); 
  if (new <= old)
    {
     Dmove->next = Dtmp->next;
     Dtmp->next = Dmove;
    }
  else
    {
     Dmove->next = Dtmp;
     if (new == NbRows - 1)
	DomainList = Dmove;
     else
       {
        Dprev = gtk_clist_get_row_data (GTK_CLIST (list), new + 1);
	Dprev->next = Dmove;
	}
     }       
  G_UNLOCK (verrou_domains);
  domain_redraw (dg, NULL);
  return TRUE;
}

gboolean ExitDomainsProperties (GtkWidget * widget)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (properties_button), FALSE);
  return TRUE;
}


/********************************/
/* Fentre "Domains" */
/********************************/

void DomainsProperties (void)
{
  gint i;
  GdkColor transparent;
  GtkWidget *Scr, *ExitDProperties, *DlgVBox, *DlgHBox;
  static gchar *Titles[] = {
    "Name", "Status", "Intpoints", "Color"
  };
  Domain *cur;

  /* Cration de la fentre des proprits */
  DlgWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (DlgWindow), "Domains");
  gtk_container_set_border_width (GTK_CONTAINER (DlgWindow), 3);
  gtk_window_set_policy (GTK_WINDOW (DlgWindow), FALSE, TRUE, FALSE);
  gtk_widget_realize (DlgWindow);

  /* Cration de la boite verticale */
  DlgVBox = gtk_vbox_new (FALSE, 3);
  gtk_container_add (GTK_CONTAINER (DlgWindow), DlgVBox);

  /* Cration de la scrolled-window */
  Scr = gtk_scrolled_window_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX (DlgVBox), Scr, TRUE, TRUE, 1);
  gtk_widget_set_usize (Scr, 400, 150);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (Scr),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  /* Ralisation de la fentre scrolled_window */
  gtk_widget_realize (Scr);

  /* Cration du pixmap Gdk de la fentre */
  Dlg_pixmap = gdk_pixmap_create_from_xpm (DlgWindow->window,
					   &Dlg_mask,
					   &transparent,
					   "properties_icon.xpm");

  /* Cration de l'icne de la fentre */
  gdk_window_set_icon (DlgWindow->window, NULL, Dlg_pixmap, Dlg_mask);

  /* Gestion des signaux de la fentre */
  gtk_signal_connect (GTK_OBJECT (DlgWindow), "destroy",
		      GTK_SIGNAL_FUNC (ExitDomainsProperties), NULL);

  gtk_signal_connect (GTK_OBJECT (DlgWindow), "delete_event",
		      GTK_SIGNAL_FUNC (ExitDomainsProperties), NULL);

  /* Cration de la clist */
  clist = gtk_clist_new_with_titles (4, Titles);
  gtk_container_add (GTK_CONTAINER (Scr), clist);

  /* Proprits particulires de la clist */
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 80);
  for (i = 0; i < 4; i++)
    {
      if (i > 0)
	gtk_clist_set_column_resizeable (GTK_CLIST (clist), i, FALSE);
      gtk_clist_set_column_width (GTK_CLIST (clist), i, 70);
      gtk_clist_set_column_justification (GTK_CLIST (clist), i,
					  GTK_JUSTIFY_CENTER);
    }

  gtk_clist_set_reorderable (GTK_CLIST (clist), TRUE);
  gtk_clist_set_column_min_width (GTK_CLIST (clist), 0, 50);
  gtk_clist_column_titles_passive (GTK_CLIST (clist));

  /* Gel de la clist pendant la m--j */
  gtk_clist_freeze (GTK_CLIST (clist));

  /* Verrouillage de la DomainList pendant la m--j */
  G_LOCK (verrou_domains);
  cur = DomainList;
  while (cur != NULL)
    {
      graphic_list_update (cur);
      cur = cur->next;
    }
  /* Dverrouillage de la DomainList aprs la m--j */
  G_UNLOCK (verrou_domains);

  /* Dgel la gtk_clist */
  gtk_clist_thaw (GTK_CLIST (clist));
  gtk_widget_show_now (GTK_WIDGET (clist));

  /* Dtournement du signal 'select_row' */
  gtk_signal_connect_object (GTK_OBJECT (clist), "select_row",
			     GTK_SIGNAL_FUNC (PropertiesActions),
			     (gpointer) clist);

  /* Dtournement du signal 'row_move' */
  gtk_signal_connect_object (GTK_OBJECT (clist), "row_move",
			     GTK_SIGNAL_FUNC (MoveDomain),
			     (gpointer) clist);

  /* Cration de la boite horizontale */
  DlgHBox = gtk_hbox_new (FALSE, 3);
  gtk_box_pack_start (GTK_BOX (DlgVBox), GTK_WIDGET (DlgHBox), FALSE, FALSE,
		      3);

  /* Cration du bouton 'Exit' de la fentre de dialogue */
  ExitDProperties = gtk_button_new_from_stock (GTK_STOCK_QUIT);
  GTK_WIDGET_SET_FLAGS (ExitDProperties, GTK_CAN_DEFAULT);
//  gtk_widget_set_usize (ExitDProperties, 100, 20);
  gtk_button_set_relief (GTK_BUTTON (ExitDProperties), GTK_RELIEF_NORMAL);
  gtk_container_set_border_width (GTK_CONTAINER (DlgHBox), 1);
  gtk_box_pack_end (GTK_BOX (DlgHBox), ExitDProperties, FALSE, FALSE, 1);

  /* Gestion des signaux du bouton 'Exit' */
  gtk_signal_connect_object (GTK_OBJECT (ExitDProperties), "clicked",
			     (GtkSignalFunc) ExitDomainsProperties,
			     GTK_OBJECT (DlgWindow));


  return;
}

/************************************************************************/
/* active_properties()                                                  */
/* Active/inactive la fentre des proprits                            */
/************************************************************************/
void active_properties (GtkWidget * widget, gpointer data)
{
  if (!GTK_WIDGET_VISIBLE (DlgWindow))
    gtk_widget_show_all (GTK_WIDGET (DlgWindow));
  else
    gtk_widget_hide (GTK_WIDGET (DlgWindow));
  return;
}
