#include <stdio.h>
#include <gtk/gtk.h>
#include <pthread.h>

#include "visutypes.h"
#include "gramm_fctn.h"
#include "gtk_domain.h"
#include "gtk_ddraw.h"
#include "gtk_windows.h"
#include "gtk_context.h"

GtkWidget **L_Tab, **B_Tab, *context_button, *ContextWin = NULL;
GdkPixmap *Context_pixmap;
GdkBitmap *Context_mask;


/************************************/
/* Callback de la fentre "Context" */
/************************************/

gboolean context_window_exit (GtkWidget * widget)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (context_button), FALSE);
  return TRUE;
}


/*********************/
/* Fentre "Context" */
/*********************/

void context_window_new (void)
{
  int i;
  char **parameters;
  Domain *context;
  GdkColor transparent;
  GtkWidget *VBox, *ContextScr, *ContextVBox, *ExitContext;
  GtkWidget **ContextHBox, *label, *entry, *HBox;

  /* Cration de la fentre */
  ContextWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width (GTK_CONTAINER (ContextWin), 3);
  gtk_window_set_title (GTK_WINDOW (ContextWin), "Context");
  gtk_window_set_policy (GTK_WINDOW (ContextWin), FALSE, TRUE, FALSE);
  gtk_widget_set_usize (GTK_WIDGET (ContextWin), 150, 180);
  gtk_widget_realize (GTK_WIDGET (ContextWin));

  /* Cration du pixmap Gdk de la fentre */
  Context_pixmap = gdk_pixmap_create_from_xpm (ContextWin->window,
					       &Context_mask,
					       &transparent,
					       "context_icon.xpm");

  /* Cration de l'icne de la fentre */
  gdk_window_set_icon (ContextWin->window, NULL,
		       Context_pixmap, Context_mask);

  /* Connexion des signaux 'delete' et 'destroy' */
  gtk_signal_connect (GTK_OBJECT (ContextWin), "destroy",
		      GTK_SIGNAL_FUNC (context_window_exit), NULL);
  gtk_signal_connect (GTK_OBJECT (ContextWin), "delete_event",
		      GTK_SIGNAL_FUNC (context_window_exit), NULL);

  /* Cration de la boite verticale pour contenir le tout */
  VBox = gtk_vbox_new (FALSE, 2);
  gtk_container_set_border_width (GTK_CONTAINER (VBox), 3);
  gtk_container_add (GTK_CONTAINER (ContextWin), VBox);

  /* Cration du GtkScrolledWindow */
  ContextScr = gtk_scrolled_window_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX (VBox), ContextScr, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ContextScr),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  /* Cration d'une boite verticale pour les paramtres */
  ContextVBox = gtk_vbox_new (TRUE, 2);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ContextScr),
					 ContextVBox);

  context = search_domain_in_list (ContextName, DomainList);
  parameters = chaintochar (context->v_list);
  
  /* Cration des lments */
  if (L_Tab)
    free (L_Tab);
  L_Tab = (GtkWidget * *)malloc (NbParam * sizeof (GtkWidget *));
  if (B_Tab)
    free (B_Tab);
  B_Tab = (GtkWidget * *)malloc (NbParam * sizeof (GtkWidget *));
  ContextHBox = (GtkWidget * *)malloc (NbParam * sizeof (GtkWidget *));
  for (i = 0; i < NbParam; i++)

    {
      /* Cration d'une boite horizontale pour un paramtre */
      ContextHBox[i] = gtk_hbox_new (TRUE, 3);
      gtk_box_pack_start (GTK_BOX (ContextVBox),
			  GTK_WIDGET (ContextHBox[i]), TRUE, TRUE, 2);

      /* Cration d'un nouveau label */
      label = gtk_label_new (parameters [i]);
      L_Tab[i] = label;
      gtk_widget_set_usize (L_Tab[i], 50, -1);
      gtk_box_pack_start (GTK_BOX (ContextHBox[i]), GTK_WIDGET (label),
			  FALSE, FALSE, 2);

      /* Cration d'un nouveau champs de saisie */
      entry = gtk_entry_new_with_max_length (3);
      B_Tab[i] = entry;
      GTK_WIDGET_SET_FLAGS (entry, GTK_CAN_DEFAULT);
      gtk_widget_set_usize (B_Tab[i], 50, -1);
      gtk_box_pack_start (GTK_BOX (ContextHBox[i]), GTK_WIDGET (entry),
			  FALSE, FALSE, 4);

      /* Connexion des signaux "activate" et "changed" */
      gtk_signal_connect (GTK_OBJECT (B_Tab[i]), "activate",
			  GTK_SIGNAL_FUNC (chg_param), B_Tab[i]);
      gtk_signal_connect (GTK_OBJECT (B_Tab[i]), "changed",
			  GTK_SIGNAL_FUNC (chg_param), B_Tab[i]);
    }

  /* Cration d'une boite horizontale pour le bouton 'Exit' */
  HBox = gtk_hbox_new (TRUE, 3);
  gtk_box_pack_start (GTK_BOX (VBox), GTK_WIDGET (HBox), FALSE, FALSE, 3);

  /* Cration du bouton 'Quit' de la fentre de dialogue */
  ExitContext = gtk_button_new_from_stock (GTK_STOCK_QUIT);
  GTK_WIDGET_SET_FLAGS (ExitContext, GTK_CAN_DEFAULT);
//  gtk_widget_set_usize (ExitContext, 100, 20);
  gtk_button_set_relief (GTK_BUTTON (ExitContext), GTK_RELIEF_NORMAL);
  gtk_box_pack_end (GTK_BOX (HBox), ExitContext, FALSE, FALSE, 3);

  /* Gestion des signaux du bouton 'Quit' */
  gtk_signal_connect_object (GTK_OBJECT (ExitContext), "clicked",
			     (GtkSignalFunc) context_window_exit,
			     GTK_OBJECT (ContextWin));

  return;
}

/************************************************************************/
/* active_context()                                                     */
/* Active/inactive la fentre du context                                */
/************************************************************************/
void active_context (GtkWidget * widget, gpointer data)
{
  if (!GTK_WIDGET_VISIBLE (ContextWin))
    gtk_widget_show_all (GTK_WIDGET (ContextWin));
  else
    gtk_widget_hide (GTK_WIDGET (ContextWin));
  return;
}
