%{
#include "visutypes.h"
#include "gramm_fctn.h"
#include "grammy.h"
#include "gtk_windows.h"
#include "gtk_properties.h"
#include "gtk_domain.h"
#include "domains.h"
#include "gtk_context.h"

int reinit = FALSE;
gint row = -1;
Domain * domain_cur = NULL;



  %}


%union {
  char *Chain;
  Value Val;
  int Op;
  struct {
    IndList Mline;
    Value Const;
  } A_Exp;
  IndList Mat_line;
  ChainList List;
}
  
    
%token ID HELP INTER UNION DIFF VALUE IMAGE PREIMAGE INITVISU VISU PRINT PLPRINT PLCONS PLRAYS DD LIST EHRHART VERTICES CONVEX DELETE QUIT LT GT LE LG EQ AFF '(' ')' '{' '}' ',' '.' ';' '+' '-' '*' PIPE

%type <Chain> ID
%type <Val> VALUE VAL
%type <List> L_VAR
%type <A_Exp> ARTHM_EXP INEG EG 
%type <Mat_line> L_VALUE
%type <Op> OPREL

%left LE GE GT LT
%left '+' '-'
%left '*'


%start COMMANDS





%%

COMMANDS   : L_INSTR                           {}
          ; 

/*********************/
/* instructions list */
/*********************/
L_INSTR : L_INSTR  INSTR {}
        | INSTR {}
	;

/*********************/
/*   shortcuts       */
/*********************/
Union: UNION | '+' ;
Inter: INTER | '.' ;
Diff:  DIFF  | '-' ;

/**************************/
/**************************/
/****** INSTRUCTIONS ******/
/**************************/
/**************************/

/**************************/
/* polyhedron declaration */
/**************************/

// empty polyhedron
INSTR:
ID AFF '{' PIPE '}' ';'
	{
		G_LOCK (verrou_domains); 
		DomainList = polyhedron_declaration ($1, NULL, DomainList);
		//graphic_actualize();
		G_UNLOCK (verrou_domains);
	}

| ID AFF '{' L_VAR PIPE
	{ curr_matrix = Matrix_Alloc (WS, dim+1); }  
  L_CONSTRAINTS '}' ';'
	{
		G_LOCK (verrou_domains); 
		DomainList = polyhedron_declaration ($1, VarList, DomainList);
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}

|  ID AFF '{' L_VAR PIPE  error ';'
	{
		yyclearin; //discards lookahead
		yyerrok;
		init_curr_vars();
		printf (">> error in constraints \n");
	}
|  ID AFF '{' L_VAR  error ';'
	{
		yyclearin; //discards lookahead
		yyerrok;					
		init_curr_vars();
		printf (">> '|' missing\n");
	}
|  ID AFF '{' error ';'
	{
		yyclearin; //discards lookahead
		yyerrok;					
		init_curr_vars();
		printf (">> error in variable list\n");
	}

/* matrix declaration */
| ID AFF '(' MATRIX ')' ';'
	{ MatrixList = add_matrix_to_list ($1, MatrixList); }


/*************************************/
/* INSTR : operations on polyhedrons */
/*************************************/

| ID AFF ID Union ID ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_binop_pol ($1, $3, $5, "union", DomainList);  
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}
| ID AFF ID Union error ';'
	{ fprintf (stdout, "> Syntax : 'res' := 'P1' union 'P2' ;\n");}


| ID AFF ID Inter ID ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_binop_pol ($1, $3, $5, "inter", DomainList);   
		graphic_actualize();
		G_UNLOCK (verrou_domains); 
	}
| ID AFF ID Inter error ';'
	{ fprintf (stdout, "> Syntax : 'res' := 'P1' inter 'P2' ;\n");}


| ID AFF ID Diff ID ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_binop_pol ($1, $3, $5, "diff", DomainList);  
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}
| ID AFF ID Diff error ';'
	{ fprintf (stdout, "> Syntax : 'res' := 'P1' diff 'P2' ;\n");}

| ID AFF IMAGE '(' ID ',' ID ')' ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_image ($1, $5, $7, "image", DomainList);  
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}
| ID AFF IMAGE  error ';'
	{ fprintf (stdout, "> Syntax : 'name' := image ('domain', 'matrix') ;\n");}


| ID AFF PREIMAGE '(' ID ',' ID ')' ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_image ($1, $5, $7, "preimage", DomainList);  
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}
| ID AFF PREIMAGE  error ';'
	{ fprintf (stdout, "> Syntax : 'name' := preimage ('domain', 'matrix') ;\n");}


| ID AFF DD ID ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_disjoint ($1, $4, DomainList);  
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}

| ID AFF CONVEX ID ';'
	{
		G_LOCK (verrou_domains);
		DomainList = gen_convex ($1, $4, DomainList);  
		graphic_actualize();
		G_UNLOCK (verrou_domains);
	}
| ID AFF CONVEX error ';'
	{  fprintf (stdout, "> Syntax : 'name' := convex 'domain' ;\n");}


| VERTICES '(' ID ',' ID  ')' ';'
	{
		G_LOCK (verrou_domains);
		gen_vert ($3, $5, DomainList);  
		G_UNLOCK (verrou_domains);
	}     
| VERTICES error ';'
	{ fprintf (stdout, "> Syntax : vertices ('domain', 'context') ;\n");}

| EHRHART '(' ID ',' ID  ')' ';'
	{
		G_LOCK (verrou_domains);
		gen_ehrhart ($3, $5, DomainList);  
		G_UNLOCK (verrou_domains);
	}     
| EHRHART error ';'
	{ fprintf (stdout, "> Syntax : ehrhart ('domain', 'context') ;\n");}

| INITVISU '(' VALUE ',' ID ')' ';'
	{
		
		DimNP = (int)$3;
		if (TmpDomainName)
			free (TmpDomainName);
		TmpDomainName = (char *)malloc ((strlen($5)+1)*sizeof(char));
		strcpy(TmpDomainName, $5);
		gdk_threads_enter ();
		init_visu ();
		gdk_threads_leave ();
	}
| INITVISU error ';'
	{ fprintf (stdout, "> Syntax : initvisu ('dimension', 'context') ;\n");}

| VISU '(' ID ')' ';'
	{
		if (TmpDomainName)
			free (TmpDomainName);
		TmpDomainName = (char*)malloc((strlen($3)+1)*sizeof(char));
		strcpy (TmpDomainName, $3);
		gdk_threads_enter ();
		/* Recherche du domaine dans la liste des domaines visualisables */
		G_LOCK (verrou_domains);
		for( domain_cur = DomainList; domain_cur; domain_cur = domain_cur->next )
		{
			if (strcmp (domain_cur->name, TmpDomainName) == 0)
			{
				row = gtk_clist_find_row_from_data (
				GTK_CLIST (clist), 
				(gpointer) domain_cur);
				break;
			}
		}
		G_UNLOCK (verrou_domains);
		if (domain_cur == NULL)
		{
			char errmsg[100];
			sprintf (errmsg, " '%s' undeclared - visu: command ignored", $3);
			yyerror (errmsg);
		}
		else
		{        /* Afficher/Masquer */
			if (row != -1)
				reinit = PropertiesActions (GTK_CLIST (clist), row, 1, NULL, NULL);
			else 
				Warn ("Can't visualize this domain (probably wrong dimension)!");
		}
		gdk_threads_leave ();

	}
| VISU error ';'
	{ fprintf (stdout, "> Syntax : visu (domain) ;\n"); }

| LIST ';'
	{
		Domain *tmp;
		ChainMatrix *mat;
		char **pname;
		fprintf(stdout, "> Domain List: \n");
		for(tmp=DomainList; tmp ; tmp=tmp->next )
		{
			pname = chaintochar (tmp->v_list);
			fprintf (stdout, ">   %s := ", tmp->name); 
			VP_Print_Domain (stdout, tmp->Pdomain, pname);
		}
		fprintf(stdout, "\n");
		fprintf(stdout, "> Matrix List : \n\t");
		for( mat = MatrixList; mat ; mat=mat->next )
		{	
			if (mat->next)
				fprintf(stdout, "%s, ", mat->name);
			else
				fprintf(stdout, "%s\n", mat->name);
		}
		printf ("\n");
	}
		 
| PRINT  ID ';'    {
		char **pname; // param name
		Domain *dom;
		Matrix *mat;
		char errmsg[100];

		dom = search_domain_in_list ($2, DomainList);
		if (dom)
		{
			// conversion de v_list en char**
			pname = chaintochar (dom->v_list);
			fprintf (stdout, "> %s := ", $2);
			VP_Print_Domain (stdout, dom->Pdomain, pname);
		}
		else
		{
			mat = search_matrix_in_list ($2, MatrixList);
			if (mat == NULL)
			{
				sprintf (errmsg, " '%s' undeclared - print: command ignored", $2);
				yyerror (errmsg);
			}
			else
			{
				fprintf(stdout, "> %s := ", $2);
				VP_Print_Matrix (stdout, mat);
			}
		}
}
| PRINT error ';' { fprintf (stdout, "> Syntax: print 'name' ;\n");}


| PLPRINT  ID ';'    { /* print domain, polylib format */
		Domain *tmp;
		Matrix *mat;
		char errmsg[100];
		tmp = search_domain_in_list ($2, DomainList);
		if (tmp )
		{
			fprintf (stdout, "> Domain '%s':\n", $2);
			Polyhedron_Print (stdout, "%3d", tmp->Pdomain);
			printf("\n");
		}
		else
		{
			mat = search_matrix_in_list ($2, MatrixList);
			if (mat)
			{
				fprintf(stdout, "> Matrix '%s':\n", $2);
				Matrix_Print (stdout, "%4d ", mat);
			}
			else
			{
				sprintf (errmsg, " '%s' undeclared - PLprint: command ignored", $2);
				yyerror (errmsg);
			}
		}
}
| PLPRINT error ';' { fprintf (stdout, "> Syntax: PLprint 'name' ;\n"); }

| PLCONS ID ';'    { /* print constraints matrix(-ces), polylib format */ 
		Domain *tmp;
		char errmsg[100];
		tmp = search_domain_in_list ($2, DomainList);
		if (tmp == NULL)
		{
			sprintf (errmsg, " '%s' undeclared - PLcons: command ignored\n", $2);
			yyerror (errmsg);
		}
		else
		{
			fprintf (stdout, "> Domain '%s' - Constraints matrix:\n", $2);
			Constraints_Print (stdout, "%3d", tmp->Pdomain);
			printf("\n");
		}
}
| PLCONS error ';' { fprintf (stdout, "> Syntax: PLcons 'domain' ;\n"); }

| PLRAYS ID ';'    { /* print rays matrix(-ces), polylib format */ 
		Domain *tmp;
		char errmsg[100];
		tmp = search_domain_in_list ($2, DomainList);
		if (tmp == NULL)
		{
			sprintf (errmsg, " '%s' undeclared - PLrays: command ignored\n", $2);
			yyerror (errmsg);
		}
		else
		{
			fprintf (stdout, "> Domain '%s' - Rays matrix:\n", $2);
			Rays_Print (stdout, "%3d", tmp->Pdomain);
			printf("\n");
		}
}
| PLRAYS error ';' { fprintf (stdout, "> Syntax: PLrays 'domain' ;\n"); }



//erase domain
| DELETE ID ';'    { Domain *tmp;
                     Matrix *mat;
		     char errmsg[100];

		     tmp = search_domain_in_list ($2, DomainList);
		     if (tmp)
		       {
			 DomainList = delete_domain_in_list ($2, DomainList);
			 fprintf(stdout, "> Succeded ! '%s' is deleted from DomainList\n", $2);
		       }
		     else
		       {		     
			 mat = search_matrix_in_list ($2, MatrixList);
			 if (mat)
			   {
			     MatrixList = delete_matrix_in_list ($2, MatrixList);
			     fprintf(stdout, "> Succeded ! '%s' is deleted from MatrixList\n", $2);
			   }
			 else
			   {
			     sprintf (errmsg, "> '%s' undeclared - del : command ignored\n", $2);
			     yyerror (errmsg);
			   }
		       }
}

| DELETE error ';' { fprintf (stdout, "> Syntax : del 'domain' ;\n"); }



| HELP ';'       { help_print (); }


// quit the application
| QUIT            { if (DEBUG == 1)
                      {
			print_domain_list (DomainList);
			print_matrix_list (MatrixList);
		      }
                    printf ("\n bye...\n\n"); 
		    return (-1);
                  }

|  ID AFF error ';' { yyclearin; //discards lookahead
 yyerrok;
 printf (">> bad command - type 'help' for informations about syntax \n");
}


|  ID error ';' { yyclearin; //discards lookahead
                  yyerrok;
		  printf (">> there must be a ':=' after identifier ! \n");
}


| error ';' { printf (">> bad command - type 'help' for informations about syntax\n"); 
              yyclearin; yyerrok;						    
	      init_curr_vars();
}

;


		
/***************/
/* matrix form */
/***************/
MATRIX : MATRIX ',' '(' L_VALUE ')' { 
                                      IndList tmp = $4; 
				      if (curr_matrix)
					{
					  if  (curr_matrix->NbColumns == dim)
					    {
					      while (tmp)
						{ 
						  curr_matrix->p[curr_constr_num][tmp->pos] = tmp->val;
						  tmp = tmp->suiv;
						}
					      curr_constr_num ++;
					      dim = 1;
					    }
					  else 
					    {
					      input_error = true;
					      Matrix_Free (curr_matrix);
					      curr_matrix = NULL;
					      fprintf (stdout, "> Matrix declaration : error in dimension\n");
					    }
					}
}

| '(' L_VALUE ')' { IndList tmp = $2; 
                    curr_matrix = Matrix_Alloc (100, dim);
		    while (tmp)
		      { 
			curr_matrix->p[curr_constr_num][tmp->pos] = tmp->val;
			tmp = tmp->suiv;
		      }
		    curr_constr_num ++;
		    dim = 1;
                  }
		;

/*****************************/
/* variables and value lists */
/*****************************/

// value list for matrix declaration
L_VALUE : L_VALUE ',' VAL   { $$ = (IndList)malloc(sizeof(t_IndList));
			      $$->pos = dim;
			      $$->val = $3;
			      $$->suiv = $1;
			      dim ++;
}
 


        | VAL               { $$ = (IndList)malloc(sizeof(t_IndList));
                              $$->pos = 0;
			      $$->val = $1;
			      $$->suiv = NULL; 
                            }
        ;

VAL : VALUE       { $$ = $1; }
    | '-' VALUE	  { $$ = - $2; }
    | '+' VALUE	  { $$ = $2; }
    ;


//liste variables et parametres
L_VAR : L_VAR ',' ID         { VarList = add_var_to_list ($3, VarList); }  
      | ID                   { VarList = add_var_to_list ($1, VarList); }
      ;

// constraints list 
L_CONSTRAINTS : L_CONSTRAINTS ',' CONSTRAINT {}
              | CONSTRAINT                   {}
              |                              {}
	      ;

/*******************/
/* constraint form */
/*******************/
CONSTRAINT : INEG   {}
           | EG     {}
	   ;


// constraint : inequality
INEG : INEG OPREL INEG { if (curr_matrix)
                           {
			     if (DEBUG == 1) printf("REDUCE INEG : INEG OP INEG\n"); 
			     $$.Mline = $1.Mline;
			     $$.Const = $1.Const;
			     if (DEBUG == 1) 
			       { 
				 printf("Membre gauche : "); 
				 Affiche_listeInd ($$.Mline); 
				 printf("Membre droit : "); 
				 Affiche_listeInd ($3.Mline);
			       }
			     curr_matrix->p[curr_constr_num][0] = 1;
			     switch ($2) {
			     case 1 :       /* <= */
			       while ($1.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($1.Mline)->pos] += - ($1.Mline)->val;
				   $1.Mline = ($1.Mline)->suiv;
				 }
			       while ($3.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($3.Mline)->pos] += ($3.Mline)->val;
				   $3.Mline = ($3.Mline)->suiv;
				 }
			       
			       /* constante */
			       curr_matrix->p[curr_constr_num][dim] = $3.Const - $1.Const;
			       break;
			       
			     case 2 :      /* >= */
			       while ($1.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($1.Mline)->pos] += ($1.Mline)->val;
				   $1.Mline = ($1.Mline)->suiv;
				 }
			       while ($3.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($3.Mline)->pos] += - ($3.Mline)->val;
				   $3.Mline = ($3.Mline)->suiv;
				 }
			       curr_matrix->p[curr_constr_num][dim] = $1.Const - $3.Const;
			       break;
			       
			     case 3 :   /* < */
			       while ($1.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($1.Mline)->pos] += - ($1.Mline)->val;
				   $1.Mline = ($1.Mline)->suiv;
				 }
			       while ($3.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($3.Mline)->pos] += ($3.Mline)->val;
				   $3.Mline = ($3.Mline)->suiv;
				 }
			       
			       /* constante */
			       curr_matrix->p[curr_constr_num][dim] = $3.Const - $1.Const - 1;    
			       break;
			       
			     case 4 :   /* > */
			       while ($1.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($1.Mline)->pos] += ($1.Mline)->val;
				   $1.Mline = ($1.Mline)->suiv;
				 }
			       while ($3.Mline)
				 {
				   curr_matrix->p[curr_constr_num][($3.Mline)->pos] += - ($3.Mline)->val;
				   $3.Mline = ($3.Mline)->suiv;
				 }
			       curr_matrix->p[curr_constr_num][dim] = $1.Const - $3.Const - 1;
			       break;
			       
			     default : fprintf (stderr, "ineg : ineg op ineg : C'EST PAS NORMAL DETRE LA\n"); 
			       break;
			     } //switch
			     
			     curr_constr_num ++;
			   }
}
			 

| ARTHM_EXP         { if (DEBUG == 1) printf("REDUCE INEG : ARTHM_EXP\n"); 
                      $$.Mline = $1.Mline; 
		      $$.Const = $1.Const; 
                    }
;


// constraint : equality
EG : ARTHM_EXP EQ ARTHM_EXP       { if (curr_matrix)
                                      {
					if (DEBUG == 1) printf ("REDUCE EG : E = E\n");
					curr_matrix->p[curr_constr_num][0] = 0;
					while ($1.Mline)
					  {
					    curr_matrix->p[curr_constr_num][($1.Mline)->pos] += ($1.Mline)->val;
					    $1.Mline = ($1.Mline)->suiv;
					  }
					while ($3.Mline)
					  {
					    curr_matrix->p[curr_constr_num][($3.Mline)->pos] += - ($3.Mline)->val;
					    $3.Mline = ($3.Mline)->suiv;
					  }
					
					/* constante */
					curr_matrix->p[curr_constr_num][dim] = $1.Const - $3.Const;
					curr_constr_num ++;		
				      }
}
;


/* operateurs relationnels */
OPREL : LT      { $$ = 3; }    /* <  */
      | GT      { $$ = 4; }    /* >  */
      | LE      { $$ = 1; }    /* <= */ 
      | GE      { $$ = 2; }    /* >= */
      ;



/*****************************/
/* expressions arithmetiques */
/*****************************/

ARTHM_EXP : ARTHM_EXP '+' ARTHM_EXP     { if (DEBUG == 1)
                                            printf ("E1 + E2\n"); 
                                          $$.Mline = concat ($1.Mline, $3.Mline);
					  $$.Const = $1.Const + $3.Const;
					  if (DEBUG == 1) 
					    Affiche_listeInd ($$.Mline); }

          | ARTHM_EXP '-' ARTHM_EXP     { $$.Mline = concat ($1.Mline, neg($3.Mline)); 
	                                  $$.Const = $1.Const - $3.Const; }

          | VALUE '*' ARTHM_EXP         { $$.Mline = mult ($3.Mline, $1);
                                          $$.Const = $1 * $3.Const; }

          | '(' ARTHM_EXP ')'           { $$.Mline = $2.Mline;
                                          $$.Const = $2.Const; }

          | '-' ARTHM_EXP               { $$.Mline = neg($2.Mline);
                                          $$.Const = - $2.Const; }

          | VALUE ID                    { $$.Mline = (IndList)malloc (sizeof(t_IndList));
                                          $$.Mline = mult (search_var_in_list ($2, VarList), $1);
					  $$.Const = 0; }

          | ID                          { $$.Mline = (IndList)malloc (sizeof(t_IndList));
                                          $$.Mline = search_var_in_list ($1, VarList);
					  $$.Const = 0;
					  if (DEBUG == 1)
					    Affiche_listeInd ($$.Mline); } 

          | VALUE                       { if (DEBUG == 1) printf ("ValueConst = " P_VALUE_FMT "\n", $1);
                                          $$.Mline = NULL;
					  $$.Const = $1; }

          ;


%%



ChainMatrix *MatrixList = NULL; /* Matrix List */
Domain *DomainList = NULL;      /* Domain List */
Matrix *curr_matrix;            /* current matrix of constraints */
int compteur = 1;               /* line counter */
ChainList VarList = NULL;       /* current variables list */
unsigned dim = 1;               /* dimension of current polyhedron */
int curr_constr_num = 0;        /* current constraint number */
int input_error = false;        /* memorize if an error occurs during declaration */

 
//old
void yyerror2(char *s)
{
  printf("> Error - line %d : %s \n", compteur, s);
}


