#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#include <polylib/polylib64.h>
#include <gtk/gtk.h>
#include "gtk_ddraw.h"
#include "visutypes.h"
#include "gtk_properties.h"


#define true 1
#define false 0
#define DEBUG 0

extern Domain *insert_domain_in_list (char *name, ChainList lv, Polyhedron *pol, Domain *LD);
extern Domain *delete_domain_in_list (char *name, Domain *l);
extern void print_domain_list (Domain *l);
extern Domain *search_domain_in_list (char *name, Domain *l);
extern int name_already_exists (char *name, Domain *l);
extern void Domain_Cell_Free (Domain * cell);
extern void init_curr_vars ();

extern ChainList add_var_to_list (char *id, ChainList l);
extern ChainList free_l (ChainList l);
extern void Affiche_liste(ChainList l);
extern char ** chaintochar (ChainList l);
extern IndList search_var_in_list (char *Id, ChainList l);

extern IndList concat (IndList l, IndList m);
extern IndList neg (IndList l);
extern IndList mult (IndList l, Value v);

extern void Affiche_listeInd(IndList l);

extern ChainMatrix *add_matrix_to_list (char *name, ChainMatrix *l);
extern Matrix *search_matrix_in_list (char *name, ChainMatrix *l);
extern ChainMatrix *delete_matrix_in_list (char *name, ChainMatrix *l);
extern int mat_name_already_exists (char *name, ChainMatrix *l);

extern Domain * polyhedron_declaration (char *name, ChainList lv, Domain *LD);
extern Domain *gen_binop_pol (char *id1, char *id2, char *id3, char *polyhedron_operator, Domain *l);
extern Domain *gen_image (char *name, char *id_pol, char *id_mat, char *operation, Domain *LD);
extern void gen_ehrhart (char *id_pol, char *id_context, Domain *LD);
extern Domain *gen_disjoint (char *name, char *id_pol, Domain *LD);
extern Domain *gen_convex (char *name, char *id_pol, Domain *LD);
extern void gen_vert (char *id_pol, char *id_context, Domain *LD);
extern void VP_Print_Matrix (FILE *f, Matrix *M );
extern void VP_Print_Domain (FILE *f, Polyhedron *D, char **param );
extern void print_matrix_list (ChainMatrix *l);
extern void Rays_Print ( FILE *f, char *format, Polyhedron *D );
extern void Constraints_Print ( FILE *f, char *format, Polyhedron *D );

extern void help_print (void);
extern void graphic_actualize();
extern void yyerror(char *s);

