#include "gramm_fctn.h"
#include "gtk_domain.h"
#include "visutypes.h"

G_LOCK_DEFINE(verrou_domains);	/* mutex: 'verrou_domains' protects DomainList */

/************************/
/* DomainList fonctions */
/************************/

Domain *insert_domain_in_list (char *name, ChainList lv, Polyhedron *pol, Domain *LD)
{
  gboolean test_black;
  GdkColor Black;
  Domain *tmp;
  char c;
  char new_name[50];
  char **pname;
  
  
  if (DEBUG == 1)
    {
      printf ("DOMAIN LIST AVANT : \n");
      print_domain_list(LD);
    }
  
  /* if name already exists : overwrite or rename new domain */
  if (name_already_exists (name, LD))
    {
      printf ("> Overwrite (o) , Choose another name (n) ?");
      c = fgetc (stdin);
      
      while ((c != 'o') && (c != 'n'))
	{
	  printf ("> Please answer 'o' (overwrite) or 'n' (choose another name) !\n");
	  c = fgetc(stdin);
	}
      
      if (c == 'o')    // overwrite
	{
	  printf("> OK : overwrite '%s'\n", name);
	  LD = delete_domain_in_list (name, LD);
	}
      else   
	if (c == 'n')   // rename
	{
	  printf("> OK : rename : Please enter new name : ");
	  fscanf(stdin, "%s", new_name);
	  name = (char *) malloc ((strlen(new_name)+1)*sizeof(char));
	  strcpy (name, new_name);
	}
    } /* name already exists */

  
  /* insertion en tete du nouveau domain */
  tmp = (Domain *)malloc(sizeof(Domain));
  
  tmp->name = (char *) malloc ((strlen(name)+1)*sizeof(char));
  strcpy (tmp->name, name);     
  tmp->v_list = lv;
  tmp->Pdomain = pol;
  
  pname = chaintochar (lv);
  fprintf (stdout, "> %s := ", name);
  VP_Print_Domain (stdout, pol, pname);

  test_black = gdk_color_black (gdk_colormap_get_system (), &Black);
  if (!test_black)
    {
      tmp->color = NULL;
      Warn ("Problem with allocation of colors!");
    }
  else
    {
      tmp->color = gdk_color_copy (&Black);
    }
  
  tmp->visual = NULL;
  tmp->next = LD; /* insertion en tete */
		       
		       
  if (DEBUG == 1)
    {
      printf ("DOMAIN LIST APRES : \n");
      print_domain_list(tmp);
    }
  
  /* returns new DomainList */
  return tmp;  
  
} /* insert_domain_in_list */				


// retire un Domain de la liste
Domain *delete_domain_in_list (char *name, Domain *l)
{
  char errmsg[100];
  Domain *tmp;
  Domain *cell; // pointeur sur l'element a supprimer
  
  if (l == NULL)
    {
      sprintf (errmsg, "delete_domain_in_list: Domain %s undeclared!", name);
      yyerror (errmsg);
      return l;
    }

  tmp = l; // pointe sur le debut de la liste

  //si c'est le premier elt qu'on doit supprimer
  if (strcmp(name, tmp->name) == 0)
    {
      l = l->next;
      Domain_Cell_Free (tmp);

      if (GTK_IS_WIDGET (clist))
	graphic_list_delete (tmp);

      return l;
    }


  //cas general
  while ((tmp->next) && (strcmp(name, (tmp->next)->name) != 0))
    tmp = tmp->next; 

  if (tmp->next == NULL)
    {
      sprintf (errmsg, "delete_domain_in_list: Domain %s undeclared!", name);
      yyerror (errmsg);
      return l;
    }

  // maintenant, tmp pointe sur le bon domain (a supprimer) 
  cell = tmp->next; // on memorise le pointeur sur l'elt a supprimer

	// efface le domain de la liste graphique
	if (GTK_IS_WIDGET (clist))
		graphic_list_delete (cell);

	tmp->next = tmp->next->next; // raccord de la liste

	Domain_Cell_Free (cell);

  return l;

} // delete_domain_in_list


void Domain_Cell_Free (Domain * cell)
{
  free (cell->name);
  Domain_Free (cell->Pdomain);
  free_l (cell->v_list);
  //il doit manquer la liberation des champs geres par Gilles : color, visual.
}


Domain *search_domain_in_list (char *name, Domain *l)
{
  Domain *tmp;

  if (l == NULL)
    return NULL;
     
  tmp = l;
  while (tmp)
    {
      if (strcmp(name, tmp->name) == 0)
	return tmp;
      tmp = tmp->next;
    }
   
  return NULL;

} // search_domain_in_list


// check if the name is already used for another domain
int name_already_exists (char *name, Domain *l)
{

  while (l)
    {
      if (strcmp(name, l->name) == 0)
	{
	  fprintf (stdout, "Warning : identifier '%s' is already used for another domain !\n", name);
	  return true;
	}
      l = l->next;
    }
 
  return false;
} /* name_already_exists */
	


void print_domain_list (Domain *l)
{

  if (l == NULL)
    printf ("Domain List Empty !\n");

  while (l)
    {
      printf ("\n %s : \t", l->name);
      Affiche_liste (l->v_list);
      Polyhedron_Print(stdout,"%d ",l->Pdomain);
      printf ("\n");
      l = l->next;
    }
  return;
}



/***********************/
/* ChainLlist fonctions */
/***********************/

/* ajoute en tete */
ChainList add_var_to_list (char *id, ChainList l)
{
  
  ChainList p, tmp;
 
  //check if there is no doublons
  tmp = l;
  while (tmp)
    {
      if (strcmp (id, tmp->Id) == 0)
	{
	  fprintf(stdout, "> more than one variable '%s' in polyhedron declaration - Action cancelled !\n", id);
	  input_error = true;
	  return l;
	}
      tmp = tmp->suiv;
    }

  if (DEBUG == 1)
    printf ("l_add : ajoute %s dans VarList\n", id);
  
  p = (ChainList) malloc (sizeof(t_ChainList));
  p->Id = (char*) malloc ((strlen(id)+1)*sizeof(char));
  strcpy (p->Id, id);
  p->suiv = l;
  p->pos = dim;
  dim ++;

  if (DEBUG == 1)
    Affiche_liste(p);
  
  return (p);
  
} /* add_var_to_list */


IndList search_var_in_list (char *Id, ChainList l)
{
  IndList res;
  ChainList tmp = l;

  if (DEBUG == 1)
    printf(" entree dans cherche\n : cherche %s dans varlist\n", Id);

  if (l == NULL)
    {
      yyerror ("id pas dans la liste\n");
      return NULL;
    }

  while (tmp)
    {
      if (strcmp (tmp->Id, Id) == 0)
	{
	  res = (IndList)malloc(sizeof(t_IndList));
	  res->pos = tmp->pos;
	  res->val = 1;
	  res->suiv = NULL;
	  return (res);
	}
      tmp = tmp->suiv;
    }

  yyerror ("there is an undeclared variable used in constraints !!\n");
  return NULL;
} /* search_var_in_list */


ChainList free_l (ChainList l)
{

  ChainList tmp;

  while (l)
    {
      free (l->Id);
      tmp = l->suiv;
      free (l);
      l = tmp;
    }

  return NULL;

} /* free_l */


void Affiche_liste(ChainList l)
{
  ChainList tmp = l;
  
  printf("Liste : ");
  if (l == NULL)
    {
      printf("liste vide \n");
      return;
    }
  while (tmp != NULL)
    {
      printf(" %s : %d \t", tmp->Id, tmp->pos);
      tmp = tmp->suiv;
    }
  printf("\n");
} /* Affiche_liste */


/* transforme un chainlist en char ** (pour les besoins de Print_Domain) */
char ** chaintochar (ChainList l)
{

  int i=0;
  char **res;
  ChainList tmp = l;

if (DEBUG == 1)
  printf ("entree dans chaintochar\n");

  if (l == NULL)
    return NULL;

  // recherche de la taille du tableau
  while (tmp)
    {
      i++;
      tmp = tmp->suiv;
    }

  res = (char **)malloc ((i+1)*sizeof(char*));

  // fin du tableau
  res[i] = NULL;

  // copie des elements
  tmp = l;
  i--;
  for ( ; i>=0; i--)
    {
      if (DEBUG == 1)
	printf ("copie de l'elet %d\n", i);
      
      res[i] = (char *)malloc ((strlen (tmp->Id)+1)*sizeof(char));
      strcpy (res[i], tmp->Id);
      tmp = tmp->suiv;
    }

  if (DEBUG == 1)
    printf(" sortie de chaintochar\n");

  return res;
} // chaintochar




/*********************/
/* IndList fonctions */
/*********************/

IndList concat (IndList l, IndList m)
{

  IndList tmp;

  if (l == NULL)
    return m;

  if (m == NULL)
    return l;

  for(tmp=l; tmp->suiv!=NULL; tmp=tmp->suiv); /* Recherche queue l */
  
  tmp->suiv = m; /* Concatenation */
  return(l);

} /* concat */


IndList mult (IndList l, Value v)
{
  IndList tmp = l;
  
  if (l == NULL)
    return NULL;

  while (l)
    {
      l->val = v * l->val;
      l = l->suiv;
    }
  return tmp;
}// mult


IndList neg (IndList l)
{
  IndList tmp = l;

  while (l)
    {
      l->val = - l->val;
      l = l->suiv;
    }
  return tmp;
}// neg


void Affiche_listeInd (IndList l)
{
  IndList tmp = l;
  
  printf("IndListe : ");
  if (l == NULL)
    {
      printf("liste vide \n");
      return;
    }
  while (tmp != NULL)
    {
      printf(" %d : " P_VALUE_FMT " \t", tmp->pos, tmp->val);
      tmp = tmp->suiv;
    }
  printf("\n");
} /* Affiche_listeInd */




/********************/
/* Matrix fonctions */
/********************/

ChainMatrix *add_matrix_to_list (char *name, ChainMatrix *l)
{
  ChainMatrix *res;
  char c;
  char new_name[50];

if (input_error == false)
  {
    /* chercher si nom existe deja*/
    if (mat_name_already_exists (name, l) == true)
      {
	printf ("Warning : identifier %s is already used for another matrix\n",name);
	printf ("Overwrite (o) , Choose another name (n) ?");
	c = fgetc (stdin);
	
	while ((c != 'o') && (c != 'n'))
	  {
	    printf ("Please answer 'o' (overwrite)  or 'n' (choose another name) !\n");
	    c = fgetc(stdin);
	  }
	
	if (c == 'o')    // overwrite
	  {
	    printf("OK : overwrite '%s'\n", name);
	    l = delete_matrix_in_list (name, l);
	    // signaler a gilles que cette matrice est detruite
		 }
	
	else
	  if (c == 'n')   // rename
	  {
	    printf("Please enter new name :\n");
	    fscanf(stdin, "%s", new_name);
	    name = (char *) malloc ((strlen(new_name)+1)*sizeof(char));
	    strcpy (name, new_name);
	  }
      } // name already exists
	     
	     // ajout de la nouvelle matrice
	     res = (ChainMatrix *)malloc(sizeof(ChainMatrix));
      res->name = (char *)malloc((strlen(name)+1)*sizeof(char));
      strcpy(res->name, name);
      res->M = curr_matrix;
      res->M->NbRows = curr_constr_num;
      curr_constr_num = 0;
      dim = 1;
      res->next = l;
      curr_matrix = NULL; /* est ce bien propre ?... */
      
//      fprintf (stdout, "> Succeded ! Matrix '%s' is now in Matrix List !\n", name); 
      
      return res;
  }

  fprintf (stdout, "> error in matrix declaration\n");
  input_error = false;
  curr_constr_num = 0;
  dim = 1;

  return l;

} // add_matrix_to_list

	   
int mat_name_already_exists (char *name, ChainMatrix *l)
{

  while (l)
    {
      if (strcmp(name, l->name) == 0)
	return true;
       
      l = l->next;
    }
  return false;
} /* name_already_exists */


Matrix *search_matrix_in_list (char *name, ChainMatrix *l)
{
  ChainMatrix *tmp;

  if (l == NULL)
    return NULL;
      
  tmp = l;
  while (tmp)
    {
      if (strcmp(name, tmp->name) == 0)
	return tmp->M;
      tmp = tmp->next;
    }
   
  return NULL;

} // search_matrix_in_list


// retire une matrice de la liste
ChainMatrix *delete_matrix_in_list (char *name, ChainMatrix *l)
{
  char errmsg[100];
  ChainMatrix *tmp;
  ChainMatrix *cell; // pointeur sur l'element a supprimer
  
  // cas liste vide
  if (l == NULL)
    {
      sprintf (errmsg, "delete matrix : Domain %s undeclared : DomainList empty !", name);
      yyerror (errmsg);
      return l;
    }

  tmp = l; // pointe sur le debut de la liste

  //cas ou c'est le premier elt qu'il faut supprimer
  if (strcmp(name, tmp->name) == 0)
    {
      l = l->next;
      if (tmp->M)
	{
	  Matrix_Free (tmp->M);
	  free (tmp->name);
	}
      return l;
    }


  //cas general
  while ((tmp->next) && (strcmp(name, (tmp->next)->name) != 0))
    tmp = tmp->next; 

  // maintenant, tmp pointe sur le bon nmo

  cell = tmp->next; // on memorise le pointeur sur l'elt a supprimer
  tmp->next = tmp->next->next; // raccord de la liste
  
  if (cell->M)
    {
      Matrix_Free (cell->M);
      free (cell->name);
    }

  return l;

} // delete_matrix_in_list


void print_matrix_list (ChainMatrix *l)
{
  if (l == NULL)
    {
      printf ("\nMatrix List Empty !!\n");
      return;
    }

  printf ("\n MATRIX LIST :\n\n");
  while (l)
    {
      printf("\t %s\n", l->name);
      Matrix_Print (stdout, "%d ", l->M);
      l = l->next;
    }

  return;
}


/***************************/
/***************************/

Domain * polyhedron_declaration (char *name, ChainList lv, Domain *LD)
{
  Polyhedron *pol;
  
  if (input_error == false)
    {
      if (lv != NULL)
	{
	  curr_matrix->NbRows = curr_constr_num ;
	  if (DEBUG == 1)
	    Matrix_Print(stdout, "%d ",curr_matrix);
	  pol = Constraints2Polyhedron (curr_matrix,100);
	}
      else  /* empty polyhedron */
	pol = Empty_Polyhedron (0); 
      
      LD = insert_domain_in_list (name, lv, pol, LD);
    }
  else
    VarList = free_l (VarList);

  init_curr_vars();
  
  return LD;
  
}// declaration_pol


/* reinit current vars */
void init_curr_vars ()
{
  if (curr_matrix)
    {
      Matrix_Free (curr_matrix);
      curr_matrix = NULL;
    }
  VarList = NULL;       /* pointer init */
  dim = 1;              /* dim init */
  curr_constr_num = 0;  /* current constraint number init */
  input_error = false;
  
}


// generate operations on polyhedrons
Domain *gen_binop_pol (char *id1, char *id2, char *id3, char *polyhedron_operator, Domain *LD)
{
  Polyhedron *tmp;
  Domain *P2;
  Domain *P3;
  char errmsg[100];  
    
 
  /* check if P3 and P3 exist */
  P2 = (Domain *)malloc (sizeof(Domain));
  P3 = (Domain *)malloc (sizeof(Domain));
  P2 = search_domain_in_list (id2, LD);
  P3 = search_domain_in_list (id3, LD);
  if (P2 && P3)
    {
      if (strcmp(polyhedron_operator, "union") == 0) 
	tmp = DomainUnion(P2->Pdomain, P3->Pdomain, 100);
      else if (strcmp(polyhedron_operator, "inter") == 0)
	tmp = DomainIntersection(P2->Pdomain, P3->Pdomain, 100);
      else if (strcmp(polyhedron_operator, "diff") == 0)
	tmp = DomainDifference(P2->Pdomain, P3->Pdomain, 100);
      else
	{ 
	  yyerror ("gen_pol_binop : pas possible d'etre ici!!!\n");
	  return LD;
	}


      // ici : insert_domain
      LD = insert_domain_in_list (id1, P2->v_list, tmp, LD);
      
      return LD;
    }
  
  /* polyhedron does not exist */
  sprintf (errmsg, "%s : command ignored\n", polyhedron_operator);
  yyerror (errmsg);
  return LD;
  
}


Domain *gen_image (char *name, char *id_pol, char *id_mat, char *operation, Domain *LD)
{

  Domain *pol;
  Polyhedron *tmp; 
  Matrix *mat;
 
  //check if polyhedron and matrix exist
  pol = search_domain_in_list (id_pol, LD);
  mat = search_matrix_in_list (id_mat, MatrixList);
  if ((pol == NULL) || (mat == NULL))
    {
      fprintf (stdout, "%s : command ignored - polyhedron '%s' or matrix '%s' does not exist !\n", operation, id_pol, id_mat);
		return( LD );
    }
  else // ok : image et insertion dans DomainList
    {
      if (strcmp (operation, "image") == 0)
	tmp = DomainImage (pol->Pdomain, mat, 20);
      else if (strcmp (operation, "preimage") == 0)
	{
		tmp = DomainPreimage (pol->Pdomain, mat, 20);
	}
      else
	{
	  yyerror ("pas possible d'etre la !!\n");
	  return LD;
	}

      //insertion
      if (tmp)
      {
	      if( tmp->Dimension == pol->Pdomain->Dimension )
			LD = insert_domain_in_list (name, pol->v_list, tmp, LD);
	      else
	      {
		      ChainList cl;
		      int i;
		      char s[10];
		      cl = NULL;
  			dim = 1;              /* dim init, pouah!!!! */
		      for( i=0 ; i<tmp->Dimension ; i++ )
		      {
			      sprintf(s, "%c", 'i'+i );
			      cl = add_var_to_list( s, cl );
		      }
		      LD = insert_domain_in_list (name, cl, tmp, LD);
  			dim = 1;              /* dim init, pouah!!!! */
	      }
      }

      return LD;
    }

}//gen_image


Domain *gen_disjoint (char *name, char *id_pol, Domain *LD)
{
  Domain *P;
  Polyhedron *tmp;

  P = (Domain *)malloc (sizeof(Domain));  
  P = search_domain_in_list (id_pol, LD);
  if (P)
    {
      tmp = Disjoint_Domain(P->Pdomain, 0, 100);
      LD = insert_domain_in_list (name, P->v_list, tmp, LD);
      return LD;
    }

  fprintf (stdout, "> DD : domain '%s' does not exist ! Command ignored\n", id_pol);
  return LD;
}

Domain *gen_convex (char *name, char *id_pol, Domain *LD)
{
  Domain *P;
  Polyhedron *tmp;

  P = (Domain *)malloc (sizeof(Domain));  
  P = search_domain_in_list (id_pol, LD);
  if (P)
    {
      tmp = DomainConvex (P->Pdomain, 100);
      LD = insert_domain_in_list (name, P->v_list, tmp, LD);
      return LD;
    }

  fprintf (stdout, "> Convex : domain '%s' does not exist ! Command ignored\n", id_pol);
  return LD;

}//gen_convex

 
void gen_ehrhart (char *id_pol, char *id_context, Domain *LD)
{
  Domain *P, *Context;
  Enumeration *en, *ehrhart;
  char **pname;

  P = search_domain_in_list (id_pol, LD);
  Context = search_domain_in_list (id_context, LD);
  if (P && Context)
    {
      ehrhart = Polyhedron_Enumerate(Polyhedron_Copy(P->Pdomain), Context->Pdomain, 100, NULL);
      for( en=ehrhart ; en ; en=en->next )
	{
	  pname = chaintochar (Context->v_list);
	  Print_Domain(stdout,en->ValidityDomain, pname);
	  print_evalue(stdout,&en->EP, pname);
	  printf( "\n-----------------------------------\n" );
	}
      return;
    }
 
  fprintf (stdout, "> Ehrhart : '%s' or '%s' undeclared - command ignored\n", id_pol,id_context);
  return;

}//gen_ehrhart


void gen_vert (char *id_pol, char *id_context, Domain *LD)
{
	Domain *P, *Context;
	Param_Polyhedron *PA;
	Param_Domain *L;
	Param_Vertices *V;
	char **pname;

	P = search_domain_in_list (id_pol, LD);
	Context = search_domain_in_list (id_context, LD);
	if (P && Context)
	{
		PA = Polyhedron2Param_Domain(Polyhedron_Copy(P->Pdomain), Context->Pdomain, 100);
		pname = chaintochar (Context->v_list);
		  /*****************************/
		  /* Scan the validity domains */
		for(L=PA->D;L;L=L->next)
		{
			 
			/* prints current val. dom. */
			printf( "---------------------------------------\n" );
			printf( "Domain :\n");
			Print_Domain( stdout, L->Domain, pname );
			
			/* scan the vertices */
			printf( "Vertices :\n");
			FORALL_PVertex_in_ParamPolyhedron(V,L,PA) {
			
				/* prints each vertex */
				Print_Vertex( stdout, V->Vertex, pname );
				printf( "\n" );
			}
			END_FORALL_PVertex_in_ParamPolyhedron;
		}
		    /*****************************/
	}
	else
		fprintf (stdout, "> Vertices : '%s' or '%s' undeclared - command ignored\n", id_pol,id_context);
	return;
}//gen_vert




void help_print (void)
{
  char c[100];

  fprintf(stdout, " \t ---------- COMMANDS - SYNTAX ----------\n\n");

  while (strcmp (c, "q") != 0)
    { 
      fprintf(stdout, "\n> Type 'l' for command list, <command_name> for synopsis, 'q' to quit help menu\n");
      fprintf(stdout, " ? ");
      scanf ("%s", c);
      
      if (strcmp (c, "l") == 0)
	{
	  fprintf (stdout, "Command list :\n");
	  fprintf (stdout, "\t union (+), inter (.), diff (-), image, preimage, convex, ehrhart, list,\n ");
	  fprintf (stdout, "\t del, initvisu, visu, print, PLprint, PLcons, PLrays, help, quit\n");
	  fprintf(stdout, "\t declarations (polyhedra and matrices)\n");
	}
      
      else if (strcmp (c, "union") == 0)
	{
	  fprintf(stdout, "> union - Description: union between two domains\n");
	  fprintf (stdout, " \t <name_union> := <dom_P1> [union|+] <dom_P2> ;\n");
	}
      
      else if (strcmp (c, "inter") == 0)	
	{
	  fprintf(stdout, "> inter - Description: intersection between two domains\n");
	  fprintf (stdout, " \t <name_inter> := <dom_P1> [inter|.]   <dom_P2> ;\n");
	}
      
      else if (strcmp (c, "diff") == 0)	
	{
	  fprintf(stdout, "> diff - Description: difference between two domains\n");
	  fprintf (stdout, " \t <name_diff> := <dom_P1> [diff|-]  <dom_P2> ;\n");
	}
      
      else if (strcmp (c, "image") == 0)
	{
	  fprintf(stdout, "> image - Description: transformation of a domain by a matrix\n");
	  fprintf (stdout, " \t <name> := image ( <dom_domain> , <mat_trans> ) ;\n");
	}

      else if (strcmp (c, "preimage") == 0)
	{
	  fprintf(stdout, "> preimage - Description: inverse transformation of a domain by a matrix\n");
	  fprintf (stdout, " \t <name> := preimage ( <dom_domain> , <mat_trans> ) ;\n");
	}

      else if (strcmp (c, "print") == 0)
	{
	  fprintf(stdout, "> print - Description: print a domain\n");
	  fprintf (stdout, " \t print <dom_domain> ;\n");
	}

      else if (strcmp (c, "PLprint") == 0)
	{ 
	  fprintf(stdout, "> PLprint - Description: print a domain or matrix (PolyLib format)\n");
	  fprintf (stdout, " \t PLprint <name> ;\n");
	}
      else if (strcmp (c, "PLcons") == 0)
	{ 
	  fprintf(stdout, "> PLcons - Description: print the constraints matrices\n");
	  fprintf (stdout, " \t PLcons <dom_domain> ;\n");
	}
      else if (strcmp (c, "PLrays") == 0)
	{ 
	  fprintf(stdout, "> PLrays - Description: print the rays matrices (rays, lines, vertices)\n");
	  fprintf (stdout, " \t PLrays <dom_domain> ;\n");
	}

      else if (strcmp (c, "initvisu") == 0)
	{
	  fprintf(stdout, "> initvisu - Description: initialize the visualisation window\n");
	  fprintf (stdout, " \t initvisu ( <int_dimension> , <pol_context> ) ;\n");
	}

      else if (strcmp (c, "visu") == 0)
	{
	  fprintf(stdout, "> visu - Description: visualize a domain\n");
	  fprintf (stdout, " \t visu ( <dom_domain> ) ;\n");
	}

      else if (strcmp (c, "quit") == 0)
	{
	  fprintf(stdout, "> quit - Description: quit the application\n");
	  fprintf (stdout, " \t quit\n");
	}
      
      else if (strcmp (c, "ehrhart") == 0)
	{
	  fprintf(stdout, "> ehrhart - Description: compute the number of integer points of a domain in a given context\n");
	  fprintf (stdout, " \t Syntax : ehrhart ( <dom_domain>, <pol_context> ) ;\n");
	}

      else if (strcmp (c, "convex") == 0)
	{
	  fprintf(stdout, "> convex - Description: compute the convex hull of a domain\n");
	  fprintf (stdout, " \t Syntax : <pol_CHull> := convex <dom_domain> ;\n");
	}

      else if (strcmp (c, "list") == 0)
	{
	  fprintf(stdout, "> list - Description: display the full list of domains and matrix in memory\n");
	  fprintf (stdout, " \t list ;");
	}

      else if (strcmp (c, "del") == 0)
	{
	  fprintf(stdout, "> del - Description: removes a domain (matrix) from Domain List (Matrix List)\n");
	  fprintf (stdout, " \t del <name> ;");
	}

      else if (strncmp (c, "decl", 4) == 0)
	{
	  fprintf (stdout, " \t <pol_P> := { <var_list> | <constraints_list> } ;\n");
	  fprintf (stdout, " \t    with <var_list>     : i, j, k, M, N...\n");
	  fprintf (stdout, " \t         <constraints>  : i<2j+2N , 0>k>=3*(i-j)+M , ...\n");
	  fprintf (stdout, " \t <mat_M> := ( (a1,b1,c1,...) , (a2,b2,c2,...) , ... , (an,bn,cn,...) ) ;\n");

    }
	  else if( strcmp (c, "q") != 0 )
		  fprintf (stdout, " \t Unknown command\n");
	}

} // help_print




static int writeOneSideDomain(Polyhedron *D, int i, FILE *f, int s, char **param)
{
	int premier, j;

	premier = 1;
	for( j=0 ; j<D->Dimension ; ++j )
	{	if( D->Constraint[i][1+j] != 0 && s*D->Constraint[i][1+j] > 0 )
		{
			if( !premier )
				fprintf( f, "+" );
			else
				premier = 0;
			if( s*D->Constraint[i][1+j] != 1 )
				fprintf( f, "%lld", s*D->Constraint[i][1+j] );
			fprintf( f, "%s", param[j] );
		}
	}
	return( premier );
}

/* affiche une matrice */
void VP_Print_Matrix (FILE *f, Matrix *M )
{
	int i,j;
	fprintf( f, "(\n" );
	for( i=0 ; i<M->NbRows ; i++ )
	{
		fprintf( f, "             ( " );
		for( j=0 ; j<M->NbColumns-1 ; j++ )
			fprintf( f, P_VALUE_FMT ",", M->p[i][j] );
		fprintf( f, P_VALUE_FMT " )", M->p[i][j] );
		if( i!=M->NbRows-1 )
			fprintf( f, ",\n" );
	}
	fprintf( f, "   )\n" );

}

/* affiche un domaine (parametre) */
void VP_Print_Domain (FILE *f, Polyhedron *D, char **param )
{
	int i, p;

	if( D->Dimension == 0 )
	{
		fprintf( f, "{ | }\n");
		return;
	}
	fprintf( f, "  { %s", param[0] );
	for( i=1 ; i<D->Dimension ; i++ )
		fprintf( f, ", %s", param[i] );
	fprintf( f, " | " );
	for( i=0 ; i<D->NbConstraints ; ++i )
	{
		int j, s;

		/* s = sens de l'inegalite >= ou <= */
		s = 1;
		for( j=0 ; j<D->Dimension ; ++j )
		{	if( D->Constraint[i][1+j] )
			{	if( D->Constraint[i][1+j]<0 )
					s = -1;
				break;		/* on s'arrete au premier !=0 rencontre */
			}
		}
		if( j==D->Dimension && D->Constraint[i][1+j]==1 && D->Constraint[i][0]==1)
			continue;
			/* c'est la positivity constraint... on ne l'affiche pas */

		if( i>0 )
			fprintf( f, ", " );

		/* affichage */
		/* terme gauche */
		if( writeOneSideDomain(D, i, f, s, param) )
			fprintf( f, "0" );

		/* operateur */
		if( D->Constraint[i][0] )
		{	/* inegalite dans le sens de s */
			if( s>0 )
				fprintf( f, " >= " );
			else
				fprintf( f, " <= " );
		}
		else
			/* egalite */
			fprintf( f, " = " );


		/* terme droit + constante */
		if( (p=writeOneSideDomain(D, i, f, -s, param)) ||
				D->Constraint[i][1+D->Dimension]!=0 )
		{
			if( s*D->Constraint[i][1+D->Dimension]>0 )
				fprintf( f, "-" );
			else if( !p )
				fprintf( f, "+" );
			fprintf( f, "%d", abs(D->Constraint[i][1+D->Dimension]) );
		}
	}
	fprintf( f, " }\n" );

	if( D->next )
	{
		printf( "UNION " );
		VP_Print_Domain( f, D->next, param );
	}
}



void Constraints_Print ( FILE *f, char *format, Polyhedron *D )
{
	for( ; D ; D=D->next )
	{
		Matrix *m;
		m = Polyhedron2Constraints( D );
		Matrix_Print (stdout, "%4d ", m);
		Matrix_Free( m );
	}
}
void Rays_Print ( FILE *f, char *format, Polyhedron *D )
{
	for( ; D ; D=D->next )
	{
		Matrix *m;
		m = Polyhedron2Rays( D );
		Matrix_Print (stdout, "%4d ", m);
		Matrix_Free( m );
	}
}


void graphic_actualize()
{
  gdk_threads_enter ();
  if (domain_frame)
    {
      graphic_list_insert ( DomainList);
      if (strcmp (DomainList->name, ContextName) == 0)
	reinit = TRUE;
    }
  
  /* Reinitialisation si le contexte a ete modifie */
  if (reinit == TRUE)
  {
    G_UNLOCK (verrou_domains);
    init_visu ();
	 G_LOCK (verrou_domains);
  }
  gdk_threads_leave ();
}
