%{
#include "gramm_fctn.h"
#include "grammy.h"
#include <string.h>

extern int compteur;
%}

chiffre [0-9]
lettre [A-Za-z]

%%

help        { return HELP; }
inter       { return INTER; }
union       { return UNION; }
diff        { return DIFF; }
image       { return IMAGE; }
preimage    { return PREIMAGE; }
dd      { return DD; }
convex      { return CONVEX; }
ehrhart     { return EHRHART; }
vertices    { return VERTICES; }
list        { return LIST; }
print       { return PRINT; }
PLprint        { return PLPRINT; }
PLcons        { return PLCONS; }
PLrays        { return PLRAYS; }
visu        { return VISU; }
initvisu    { return INITVISU; }
del         { return DELETE; }
quit        { return QUIT; }

"("         { return '('; }
")"         { return ')'; }
"{"         { return '{'; }
"}"         { return '}'; }

"|"         { return PIPE; }
","         { return ','; }
";"         { return ';'; }
"."         { return '.'; }

"<="        { return LE; }
">="        { return GE; }
"<"         { return LT; }
">"         { return GT; }
":="        {  return AFF; }
"="         { return EQ; }

"+"         { return '+'; }
"-"         { return '-'; }
"*"         { return '*'; }


{chiffre}+    { yylval.Val = atoi(yytext);
                return VALUE; 
              }

{lettre}({lettre}|{chiffre})*   { if (DEBUG == 1) printf(" IDlex : %s\n", yytext); 
                                  yylval.Chain = malloc ((yyleng+1)*sizeof(char));
                                  strcpy (yylval.Chain, yytext);
                                  return ID; 
                                 }

" "+     {}
[\n]     {  compteur ++; fprintf (stdout, "<%d> ", compteur); }




%%

void yyerror(char *s)
{
  if (feof (stdin))
     printf ("\nEnd of file parsing.\n\n");
  else
     printf("> Error - line %d : %s \n", compteur, s);
}

