/* Bibliotheque pour la gestion des fenetres et des touches utilisant la SDL
 * http://www.libsdl.org/
 * Lode Vandevenne et Cedric Bastoul
 */
 
#include <SDL/SDL.h>
#include <stdlib.h>

SDL_Surface* ecran;
Uint8* touches_lues;

/* Fonction d'initialisation de la SDL et de la fenetre d'affichage */
void sdl_ecran_init(int largeur, int hauteur) {
  if(SDL_Init(SDL_INIT_EVERYTHING) < 0) {
    printf("Probleme initialisation SDL: %s\n",SDL_GetError());
    SDL_Quit();
    exit(1);
  }

  /* Mode video : fenetre couleurs 32 bits de taille hauteur * largeur */
  ecran = SDL_SetVideoMode(largeur,hauteur,32,SDL_HWSURFACE | SDL_HWPALETTE);
  if(ecran == NULL) {
    printf("Probleme configuration mode video: %s\n",SDL_GetError());
    SDL_Quit();
    exit(1);
  }
}

/* Dessin d'une ligne verticale depuis (x,y1) jusqu'a (x,y2), en couleur */
void sdl_ligne_verticale(int x, int y1, int y2, int r, int v, int b) {
  int y;
  Uint32 colorSDL = SDL_MapRGB(ecran->format,r,v,b);
  Uint32* bufp;
  
  bufp = (Uint32*)ecran->pixels + y1 * ecran->pitch / 4 + x;
  for(y = y1; y <= y2; y++) {
     *bufp = colorSDL;
     bufp += ecran->pitch / 4;
  }
}

/* Fonction pour mettre a jour l'affichage */
void sdl_ecran_mise_a_jour() {
  SDL_UpdateRect(ecran,0,0,0,0);
  SDL_FillRect(ecran,NULL,0);
  /* SDL_FillRect(ecran, NULL, 65536 * 200 + 256 * 200 + 200); */
}

/* Lit les touches appuyees et place l'information dans touches_lues */
void sdl_touches_lire() {
  touches_lues = SDL_GetKeyState(NULL);
}

/* Verifie si la touche en paramettre a ete appuyee, renvoie 1 (oui), 0 (non) */
int sdl_touches_appuyee(int touche) {
  return (touches_lues[touche] != 0);
}

/* Retourne le nombre de millisecondes depuis le debut du programme */
unsigned long sdl_date() {
  return SDL_GetTicks();
}

/* Retourne 1 si la fenetre a ete fermee */
int sdl_fin() {
  int done = 0;
  SDL_Event event;
  
  if(!SDL_PollEvent(&event))
    return 0;
  if(event.type == SDL_QUIT)
    done = 1;
  return done;
}

/* Liberer les ressources de la SDL */
void sdl_quitter() {
  SDL_Quit();
}

