/* Programme pour se deplacer dans un environnement 3D simple.
 * Lode Vandevenne et Cedric Bastoul
 */

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include "moteur.h"
#include "sdl.h"

#define LARGEUR_ECRAN 512
#define HAUTEUR_ECRAN 364
#define NB_FRAMES_ENTRE_AFFICHAGES_FPS 2000

/* Variable a augmenter pour ralentir l'application (vers 5000) */
int ralentissement = 0;

/* "carte" de la scene 3D, 0 : vide, sinon un bloc avec un code de couleur */
int carte[LARGEUR_CARTE][HAUTEUR_CARTE]=
{
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,2,2,2,2,2,0,0,0,0,3,0,3,0,3,0,0,0,1},
  {1,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,2,0,0,0,2,0,0,0,0,3,0,0,0,3,0,0,0,1},
  {1,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,2,2,0,2,2,0,0,0,0,3,0,3,0,3,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,0,4,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,0,0,0,0,5,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,0,4,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,0,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}
};

/* Programme de visite d'une scene 3D */
int main() {
  int x;
  double date_actuelle = 0,      /* Date de debut de la frame actuelle */
         date_precedente = 0,    /* Date de debut de la frame precedente */
         temps_frame,            /* Temps de calcul pour une frame (s) */
         temps_total,            /* Temps total de calcul */
         nb_frames;              /* Nombre de frames total */
  
  sdl_ecran_init(LARGEUR_ECRAN,HAUTEUR_ECRAN);

  while(!sdl_fin()) {
   

    /* Boucle de calcul et d'affichage des colonnes de pixels */
    for (x = 0; x < LARGEUR_ECRAN; x++)
      moteur_dessiner_colonne(x,LARGEUR_ECRAN,HAUTEUR_ECRAN);


    /* Calcul et affichage du nombre de frames par seconde */
    date_precedente = date_actuelle;
    date_actuelle = sdl_date();
    temps_frame = (date_actuelle - date_precedente) / 1000.0;
    temps_total += temps_frame;
    nb_frames++;
    
    /* Printf c'est tres lent ! On affiche pas tout le temps. */
    if (((int)nb_frames % NB_FRAMES_ENTRE_AFFICHAGES_FPS) == 0)
      printf("%.3f FPS moyen\n",nb_frames/temps_total);
    
    sdl_ecran_mise_a_jour();
    moteur_gestion_actions(temps_total/nb_frames);
  }
  
  return 0;
}
