#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MALLOC(t) ((t*)malloc(sizeof(t)))
#define MALLOCN(n,t) ((t*)malloc(n*sizeof(t)))
#define n 4

typedef struct sFrac
   {     
     int num;
     int denom;
               
   }SFrac,*Frac;
   
typedef Frac *Lignes;
typedef Lignes *Matrice;

Matrice m1=NULL,m2=NULL;
Matrice id=NULL;


Matrice inverser(Matrice m,int p,int q,int deg)
  {int i,j;
   Frac temp;
   
      for(j=0;j<=deg;j++) 
        { 
	  temp->num= m[p][j]->num;
	  temp->denom= m[p][j]->denom;
          m[p][j]->num= m[q][j]->num;
	  m[p][j]->denom= m[q][j]->denom;
	  m[q][j]->num= temp->num;
	  m[q][j]->denom= temp->denom;
        }
    
      
	
    return m;	
  }

float absf(float a)
{  
if (a>=0) return a ;
 else return -a; 
}

int absint(int a)
{  
if (a>=0) return a ;
 else return -a; 
}

int pgcd(int numerateur,int diviseur)
  {
    int reste,nn,a,b;
    
    a= numerateur;
    b= diviseur;
    
    reste= 1;    
    while(reste!=0)
      {
        nn= (int)(a/b);
        reste= a-b*nn;
	
	if(reste==0)
	   return b;
	else
	  {
	    a=b;
	    b=reste;
	  }
      }
  } 
  
int puissance(int nb,int deg)
  {
    int i,res;
    
    res=1;
    for(i=0; i<deg; i++)
      { 
         res= res*nb;
      }
      
    return res;
  }  
    
Matrice combiner(Matrice m,int p,int q,Frac a1,Frac a2,int deg)
  {int i,j,pgcd1;
      
      for(j=0;j<=deg;j++) 
        {
		 	
         m[p][j]->num= a1->num * m[p][j]->num * a2->denom * m[q][j]->denom
	               + a1->denom * m[p][j]->denom * a2->num * m[q][j]->num;
		       
	 m[p][j]->denom= a1->denom * m[p][j]->denom 
	                           * a2->denom * m[q][j]->denom;	
        			
	pgcd1= pgcd(abs(m[p][j]->num), abs(m[p][j]->denom));
			
	m[p][j]->num= (m[p][j]->num/pgcd1);
	m[p][j]->denom= (m[p][j]->denom/pgcd1);
				
	}
	
   return m;	  
  }
  
void simplifierFrac(Frac f)
  {
          if(f->num<0 && f->denom<0)
	      {
	        f->num = -f->num;
                f->denom = -f->denom;
	      }
	    else
	      {
	        if(f->num>0 &&  f->denom<0)
	          {
		    f->num= -f->num;
		    f->denom= -f->denom;
		  }
	      }
  }	      	    
	        
Matrice simplifierMat(Matrice m,int deg)
  {
    int i,j;
    
    for(i=0;i<=deg;i++)
      {
        for(j=0;j<=deg;j++)
	  {
	    if(m[i][j]->num<0 && m[i][j]->denom<0)
	      {
	        m[i][j]->num = -m[i][j]->num;
                m[i][j]->denom = -m[i][j]->denom;
	      }
	    else
	      {
	        if(m[i][j]->num>0 &&  m[i][j]->denom<0)
	          {
		    m[i][j]->num= -m[i][j]->num;
		    m[i][j]->denom= -m[i][j]->denom;
		  }
	      }	    
	      
	      
	  }
	  
      }
    return m;  
 }     	       	
  
Matrice invers(Matrice a,int deg)
  {int i,k,invers;
   Frac a1,a2;
   
  
   
               
   
  for(k=0;k<=deg;k++)
    {invers=0;
     
      
     if(a[k][k]->num==0)
       {
         for(i=0;i<k && invers==0;i++)
	   {
	    if(a[i][i]->num==0 && a[i][k]->num!=0)            //pour le cas d'une matrice non reguliere
	      {
	       inverser(a,k,i,deg);	       
	       inverser(id,k,i,deg);
	      
	       invers=1; 
	      }
	   }
	   
	 if(invers==0)
	   {
	    for(i=k+1;i<=deg && invers==0;i++)     
	      {
	       if(a[i][k]->num!=0)                   
	        {
		 inverser(a,k,i,deg);		 
		 inverser(id,k,i,deg);
		 
		 invers=1;
		}
	      }
           }
       }     	   
	 
    if(a[k][k]->num!=0)
      { 
        a1=MALLOC(SFrac);
	a2=MALLOC(SFrac);
	
        a1->num= a[k][k]->denom;
	a1->denom= a[k][k]->num; 
        
        a2->num= 0;
	a2->denom= 1;
			
        combiner(id,k,k,a1,a2,deg);	 	  
        combiner(a,k,k,a1,a2,deg);
      	
	for(i=0;i<=deg;i++)
	  {
	   if(i!=k && a[i][k]->num!=0)
	     {
	      
	      a1->num= 1;
	      a1->denom= 1; 
	      
	      a2->num= -a[i][k]->num;
	      a2->denom= a[i][k]->denom;
	       
	      combiner(id,i,k,a1,a2,deg);	     
	      combiner(a,i,k,a1,a2,deg); 
	    	      
	      
     	     }
	  }
      }
      	          	  
    }
       
    id=simplifierMat(id,deg);
    return id;   
 }     
 
 
Matrice initMatrice(Matrice m,int deg,int num_fonction,int periode)
  {
    int i,j;
       
    for(i=0;i<=deg;i++)
      {
        for(j=0;j<=deg;j++)
	  {
	      
	     m[i][j]->num= puissance(num_fonction + i*periode,j);	     
	     m[i][j]->denom=1;
	      	     
	  }
	 
      }      
      
      return m;
  }     
      
      	     
 
 
 
 
 
 
 
 
 
 
void afficheMatrice(Matrice m)
  {int i,j;
  float a;
  
  for(i=0;i<n;i++)  
    {for(j=0;j<n;j++)  
       { 
              
       a=(float)m[i][j]->num/m[i][j]->denom;
       
       
        if(a - (float)((int)a) == 0.0)
	  printf("%d     ",(int)a);
	else  
	 {
          if((m[i][j]->num<0 && m[i][j]->denom>0) 
	           || (m[i][j]->num>0 && m[i][j]->denom<0))
	   {
	     printf("%d/%d   ",m[i][j]->num,m[i][j]->denom);
	   }
           else
	     {
	       printf("%d/%d    ",abs(m[i][j]->num),abs(m[i][j]->denom));
	     }
	  }
	  	     	     
	   if(j==n-1)
           printf("\n");
	   
       }
    }        
    printf("\n\n"); 
  }
   

  
   
 
 
 
 
 
 
