package p2pmpi.visu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.GLNavigateUI;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.ZoomScroll;



public class NetMap extends GLPanel {

	  private final static boolean splitDupes = true;

	  // Edge colors (keep up and down color different from other edge colors)
	  private final Color edgeColor = Color.darkGray;
	  private final Color upColor = Color.blue;
	  private final Color downColor = Color.green;

	  // Node colors
	  private final Color goodColor = Color.green.darker();
	  private final Color badColor = Color.red;
	  private final Color dupeColor = Color.gray;

	  // Interface color
	  private Color defaultColor = Color.lightGray;

	  // Artificial anchor point and edges color
	  private final Color dimColor = Color.lightGray;

	  Node anchor;
	  JComboBox taskCombo =null;
	  Visu_Param parent;

	  /**
	   *  Default constructor.
	   */
	  public NetMap( Visu_Param parent ) {
		    defaultColor = Color.WHITE;
		    this.setBackground(Color.WHITE);
		    scrollBarHash = new Hashtable();
		    tgLensSet = new TGLensSet();
		    tgPanel = new TGPanel(); 
		    tgPanel.setBackground(Color.WHITE);
		    hvScroll = new HVScroll(tgPanel, tgLensSet);
		    zoomScroll = new ZoomScroll(tgPanel);
		    // hyperScroll = new HyperScroll(tgPanel);
		    rotateScroll = new RotateScroll(tgPanel);
		    localityScroll = new LocalityScroll(tgPanel);

		    this.parent=parent;
		    initialize();
	  }



	  /**
	   *  Constructor with a Color to be used for UI background.
	   *
	   *@param  color  default background color
	   */
	  public NetMap(Color color) {
		    defaultColor = color;
		    this.setBackground(color);
		    scrollBarHash = new Hashtable();
		    tgLensSet = new TGLensSet();
		    tgPanel = new TGPanel();
		    tgPanel.setBackground(color);
		    hvScroll = new HVScroll(tgPanel, tgLensSet);
		    zoomScroll = new ZoomScroll(tgPanel);
		    rotateScroll = new RotateScroll(tgPanel);
		    localityScroll = new LocalityScroll(tgPanel);
		    initialize();
	  }


	  public void addComboTask(String task){
		    boolean dedans=false;
		    for(int i=0;i<taskCombo.getItemCount();i++)
				if( (String)taskCombo.getItemAt(i)==task)
					  dedans=true;

		    if(!dedans)	
				taskCombo.addItem(task);
	  }	

	  public void clearAllComboTask(){
		    taskCombo.removeAllItems();
	  }

	  private void setCurrentTask(String task){
		    parent.currentTask=task;
	  }

	  public void buildPanel() {
		    final JScrollBar horizontalSB = hvScroll.getHorizontalSB();
		    final JScrollBar verticalSB = hvScroll.getVerticalSB();
		    final JScrollBar zoomSB = zoomScroll.getZoomSB();
		    final JScrollBar rotateSB = rotateScroll.getRotateSB();
		    final JScrollBar localitySB = localityScroll.getLocalitySB();

		    setLayout(new BorderLayout());

		    JPanel scrollPanel = new JPanel();
		    scrollPanel.setBackground(defaultColor);
		    scrollPanel.setLayout(new GridBagLayout());
		    GridBagConstraints c = new GridBagConstraints();


		    JPanel modeSelectPanel = new JPanel();
		    modeSelectPanel.setBackground(defaultColor);
		    modeSelectPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 0,0));

		    AbstractAction navigateAction = new AbstractAction("Navigate") {
				public void actionPerformed(ActionEvent e) {
					  tgUIManager.activate("Navigate");
				}
		    };

		    AbstractAction editAction = new AbstractAction("Edit") {
				public void actionPerformed(ActionEvent e) {
					  tgUIManager.activate("Edit");
				}
		    };

		    JRadioButton rbNavigate = new JRadioButton(navigateAction);
		    rbNavigate.setBackground(defaultColor);
		    rbNavigate.setSelected(true);
		    JRadioButton rbEdit = new JRadioButton(editAction);
		    //  rbEdit.setBackground(defaultColor);
		    ButtonGroup bg = new ButtonGroup();
		    bg.add(rbNavigate);
		    // bg.add(rbEdit);

		    modeSelectPanel.add(rbNavigate);
		    //modeSelectPanel.add(rbEdit);

		    Vector<String> tasks=new Vector();
		    tasks.addElement("Disponibility");
		    taskCombo = new JComboBox(tasks);
		    taskCombo.setBackground(defaultColor);
		    taskCombo.setPreferredSize(new Dimension(140,20));
		    taskCombo.setSelectedIndex(0);
		    taskCombo.addActionListener(new java.awt.event.ActionListener() { 
					  public void actionPerformed(java.awt.event.ActionEvent e) {    
					  JComboBox cb = (JComboBox)e.getSource();
					  setCurrentTask((String)cb.getSelectedItem());
					  repaint();
					  }
					  });


		    final JPanel topPanel = new JPanel();
		    topPanel.setBackground(defaultColor);
		    topPanel.setLayout(new GridBagLayout());
		    c.gridy=0; c.fill=GridBagConstraints.HORIZONTAL;
		    /*
			 c.gridx=0;c.weightx=0;
			 topPanel.add(new Label("Zoom",Label.RIGHT), c);
			 c.gridx=1;c.weightx=0.5;
			 topPanel.add(zoomSB,c);
			 c.gridx=2;c.weightx=0;
			 topPanel.add(new Label("Locality",Label.RIGHT), c);
			 c.gridx=3;c.weightx=0.5;
			 topPanel.add(localitySB,c);
		     */
		    c.gridx=0;c.weightx=0;c.insets = new Insets(0,10,0,10);
		    // topPanel.add(modeSelectPanel,c);
		    c.insets=new Insets(0,0,0,0);
		    c.gridx=1;c.weightx=1;

		    scrollBarHash.put(zoomLabel, zoomSB);
		    scrollBarHash.put(rotateLabel, rotateSB);
		    scrollBarHash.put(localityLabel, localitySB);

		    JPanel scrollselect = scrollSelectPanel(new String[] {zoomLabel, rotateLabel, localityLabel});
		    scrollselect.setBackground(defaultColor);
		    topPanel.add(scrollselect,c);


		    c.gridx=0;c.weightx=0;c.insets = new Insets(0,10,0,10);
		    topPanel.add(taskCombo,c);


		    add(topPanel, BorderLayout.NORTH);

		    c.fill = GridBagConstraints.BOTH;
		    c.gridwidth = 1;
		    c.gridx = 0; c.gridy = 1; c.weightx = 1; c.weighty = 1;
		    scrollPanel.add(tgPanel,c);

		    c.gridx = 1; c.gridy = 1; c.weightx = 0; c.weighty = 0;
		    scrollPanel.add(verticalSB,c);

		    c.gridx = 0; c.gridy = 2;
		    scrollPanel.add(horizontalSB,c);

		    add(scrollPanel,BorderLayout.CENTER);

		    glPopup = new JPopupMenu();
		    glPopup.setBackground(defaultColor);

		    JMenuItem menuItem = new JMenuItem("Toggle Controls");
		    ActionListener toggleControlsAction = new ActionListener() {
				boolean controlsVisible = true;

				public void actionPerformed(ActionEvent e) {
					  controlsVisible = !controlsVisible;
					  horizontalSB.setVisible(controlsVisible);
					  verticalSB.setVisible(controlsVisible);
					  topPanel.setVisible(controlsVisible);
				}
		    };
		    menuItem.addActionListener(toggleControlsAction);
		    glPopup.add(menuItem);
	  }

	  public void addUIs() {
		    tgUIManager = new TGUIManager();
		    PeerNavigateUI navigateUI = new PeerNavigateUI(this);
		    tgUIManager.addUI(navigateUI,"Navigate");
		    tgUIManager.activate("Navigate");
	  }

	  public void initialize() {
		    buildPanel();
		    buildLens();
		    tgPanel.setLensSet(tgLensSet);
		    addUIs();
	  }
	  public void addNode(PeerNode n) throws com.touchgraph.graphlayout.TGException {
		    tgPanel.addNode(n);
	  }

	  public Edge addEdge(Node dest, Node org, int length){
		    return tgPanel.addEdge(dest, org, length);
	  }

	  public PeerNode findNode(String id){
		    return ((PeerNode) tgPanel.findNode(id));
	  }

}
