package p2pmpi.tools;

import p2pmpi.common.*;
import java.net.*;
import java.io.*;

public class P2PMPI_Boot {
	static public void main(String[] args) {
            // will search in 1-$P2PMPI_CONF_HOME and 2-$P2PMPI_HOME or a P2PMPI.conf file
		P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( );
		int mpdPort 	= ppConf.getMPDPort();
		int fdPort	= ppConf.getFDPort();
		int ftPort	= ppConf.getFTPort();
		int rsPort      = ppConf.getRSPort();

		ServerSocket servSock = null;
		// Test FD Port
		try {
			servSock = new ServerSocket(fdPort);
			servSock.close();
		} catch (Exception e) {
			System.err.println("ERROR: failed to run FD (port "+fdPort+" busy).");
		      System.err.println("	   Make sure no other instance of FD is already running.");
			System.exit(1);
		}

		// Test FT Port
		try {
			servSock = new ServerSocket(ftPort);
			servSock.close();
		} catch (Exception e) {
			System.err.println("ERROR: failed to run FT (port "+ftPort+" busy)."); 
		      System.err.println("	   Make sure no other instance of FT is already running.");
			System.exit(1);
		}

		// Test RS Port
		try {
			servSock = new ServerSocket(rsPort);
			servSock.close();
		} catch (Exception e) {
			System.err.println("ERROR: failed to run RS (port "+rsPort+" busy)."); 
		      System.err.println("	   Make sure no other instance of RS is already running.");
			System.exit(1);
		}
	
	
		// Test MPD Port
		try {
			servSock = new ServerSocket(mpdPort);
			servSock.close();
		} catch (Exception e) {
			System.err.println("ERROR: failed to run MPD (port "+mpdPort+" busy)."); 
		      System.err.println("	   Make sure no other instance of MPD is already running.");
			System.exit(1);
		}
	}
}
