package p2pmpi.tools;

import p2pmpi.common.*;
import java.net.*;
import java.io.*;

public class MPDStatus {
	static public void main(String[] args) {
		int NUMTRY = 10;
		int sleepTime = 1000;
		boolean success = false;
		String envPath = System.getProperty("P2PMPI_HOME");
		File logPath = new File(envPath, "tmp");
		File logFile = new File(logPath, "mpd-"+System.getProperty("HOSTNAME")+".log");
		P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( );
		int mpdPort 	= ppConf.getMPDPort();
		
		Socket sock = null;
		Version v= new Version();
		System.out.print("[Booting mpd "+v.MAINVERSION+"."+v.SUBVERSION+"]\n");
		while(NUMTRY-- > 0) {
			try {
				sock = new Socket("127.0.0.1", mpdPort);
				success = true;
				break;
			} catch (Exception e) {
				try {
					Thread.sleep(sleepTime); //Sleep 1s
				} catch (Exception ie) {}
			}
			System.out.print(".");
		}
		if( success ) {
			try {
				sock.close();
			} catch(Exception e) {
				e.printStackTrace();
			}
			System.out.println("\nMPD started. Log is in " + logFile.toString());
		} else {
			System.out.println("\nMPD boot failed, see " + logFile.toString());
			System.exit(1);
		}
	}
}
