package p2pmpi.tools;

import p2pmpi.common.*;
import java.net.*;
import java.io.*;
import java.util.*;
import p2pmpi.common.*;




public class LocalIPCheck {

        /**
         * return a hint to simplifiy user's life.
         * @author genaud
         */
        private static String getOsHint( ) {
                  String s = OsInfo.getName();
                  String hint = new String();
                  if (OsInfo.isWindows( s ) || OsInfo.isWindowsVista( s )) {
                        hint="("+ s +") use 'ipconfig /all' in cmd to display interfaces.";
                  } else {
                        hint="("+ s +") use 'ifconfig' in a shell to display interfaces.";
                  }
                  return( hint );
        }

	  public static void main(String[] args) {

		    P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile();

                // try to help the constructor by giving him hints 
		    NetIface extIf = new NetIface( ppConf.getIface(), ppConf.getExternalIP());

		    String ip = extIf.getExternalIfIpv4( );
		    String name = extIf.getIfName( ); // will return the name of the selected usable iface, or null

                if ( ip != null) {
                        String req = ppConf.getIface();
                        if ( null == req || 0 == req.length())
                              req = "none";
                        System.out.println("* detected ifaces: "+extIf.getAllIface( false ) 
                                        + " Requested:" + req +". Using "+name+":"+ip);
                }
                else { 
                        // ip is null: we could not find a usable iface, or the IP set in config is wrong
                        System.out.println("*******************************************************");
                        System.out.println(" Error: could not get a a working network interface.");
                        if (name == null) {
                              System.out.println(" Setting IFACE='"+ppConf.getIface()+"', error was: ");
                              System.out.println("    "+extIf.getErrorIfaceMsg());
                        }
                        System.out.println(" Setting the IP address, error was: ");
                        System.out.println("    "+extIf.getErrorAddrMsg());
                        System.out.println(" Hint "+ getOsHint() ); 
                        System.out.println("*******************************************************");
                        System.exit(1);

                }
                System.exit(0);
        }
}
