
/*
 * JarReader.java : part of P2P-MPI (http://www.p2pmpi.org).
 *
 * Copyright (C) 2007, Choopan Rattanapoka and Stephane Genaud
 *
 * This tool is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * JarReader.java : outputs the classpath strings
 *
 * Reads a text file containing the list of files to transfer, 
 * extracts names ending with a .jar extension, and output
 * a classpath that concatenates the jar files, separated by
 * the OS-specific separator.
 *
 * @author Jagdish Achara,aug 2009 
 * 
 **/


package p2pmpi.tools;

import java.io.*;
import java.util.StringTokenizer;

public class JarReader {
	private static String CACHE_REQ_KEYWORD="cache";
	public static void main(String[] args){
		String jarFileList = "";
		if(args.length>0)
		{
			if(!args[0].equals("") & args[0]!=null){
				String tmpFile = args[0];
				try {
					InputStream in = new FileInputStream(tmpFile);// If file is not found, how will user know about it??????
					InputStreamReader reader = new InputStreamReader(in);
					BufferedReader buf = new BufferedReader(reader);

					String fileName = "";
					while((fileName = buf.readLine()) != null) {

						if (!fileName.startsWith("http://")) { // it can't be a jar file
							// check syntax of the line, searching for 'CACHE_REQ_KEYWORD' keyword
							StringTokenizer tok = new StringTokenizer(fileName);
							if(fileName.endsWith( CACHE_REQ_KEYWORD ) && tok.countTokens()>1) {
								int last = fileName.lastIndexOf(" "+ CACHE_REQ_KEYWORD );
								fileName = fileName.substring(0,last);
								fileName = fileName.trim();
							}
							if(fileName.endsWith(".jar")) {
								jarFileList += (File.pathSeparator+fileName);
							}
						}
					}
				} catch(Exception e) { }
			}
		}
		System.out.println(jarFileList);
	}
}
