package p2pmpi.p2p.message;

import java.io.*;
import java.net.*;
import p2pmpi.common.*;


/**
  * Message used to indicate a host want to register.
  * Most frequent use case is a Peer starting, registering to SuperNode. 
  * In that case, all MPD, FT, FD, RS ports should be set.
  * Visu client may also use this message to register to a VisuProxy. 
  * In this latter case, answerPort should be set.
  **/
public class RegisterMessage implements Serializable {
	HostEntry host;
	int answerPort;
	String version;

	/**
	 * Constructor 1. This is ok to register at Supernode.
       **/
	public RegisterMessage(HostEntry host) {
		this.host = host;
		this.answerPort = 0;
	}
	/**
	 * Constructor 2. This is ok to register to a VisuProxy.
       **/
	public RegisterMessage(HostEntry host, int answerPort) {
		this.host = host;
		this.answerPort = answerPort;
	}

	public HostEntry getHostEntry() {
		return host;
	}
	public int getAnswerPort() {
		return( answerPort );
	}

}
