/* $Id: PeerKeepAlive.java 134 2009-08-05 23:04:27Z genaud $Date $Author */

/**
 * Implements a callback installed by a timer in MPD.
 * Its role is to say 'Hey, i'm alive to SuperNode.
 * From 0.29.0, it might send also a list of the md5sums contained in its cache.
 **/

package p2pmpi.p2p;

import java.util.*;
import java.net.*;
import java.io.*;
import p2pmpi.common.*;
import p2pmpi.p2p.message.*;
import org.apache.log4j.*;


public class PeerKeepAlive extends TimerTask {
        URI superNode;
        HostEntry myHost;
        private DiskCache diskCache; 
        Logger log = null;


        /**
         * constructor
         **/
        public PeerKeepAlive(URI superNode, HostEntry myHost, DiskCache diskCache) {
                this.superNode = superNode;
                this.myHost = myHost;
                this.diskCache = diskCache;
                log = Logger.getLogger("MPD");

        }

        /**
         * Send the update message through socket.
         * @param msg the message to send to supernode.
         **/
        private void sendUpdate( UpdateMessage msg ) {
                try {
                        Socket sock = new Socket(superNode.getHost(), superNode.getPort());
                        OutputStream out = sock.getOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(out);
                        oos.writeObject(msg);
                        oos.flush();
                        oos.close();
                        out.close();
                        sock.close();
                } catch(Exception e) {
                  log.error("[PeerKeepAlive] could not send an update to supernode "
                             +superNode.getHost()+":"+superNode.getPort());
                }
        }
      /**
       * 'Alive' notification to supernode with cache information
       **/
	public void sendCacheUpdate() {
                  Vector<String> m = diskCache.getMd5s();
                  log.info("[PeerKeepAlive] MPD requested to recompute md5sums of cache. Found "+m.size()+" files.");
                  myHost.updateCacheMd5sums( m );
			UpdateMessage msg = new UpdateMessage(myHost);
                  sendUpdate( msg );
      }

      /**
       * 'Alive' notification to supernode
       **/
	public void sendAliveUpdate() {
			UpdateMessage msg = new UpdateMessage(myHost);
                  sendUpdate( msg );
      }

      /**
       * The code to callback when timer expires.
       **/
	public void run() {
            // send simple alive notification every few minutes
            sendAliveUpdate();

	}
}
