package p2pmpi.mpi.dev;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;
import java.util.concurrent.*;
import p2pmpi.common.*;
import p2pmpi.message.*;
import java.nio.channels.spi.SelectorProvider;

public class NIODevice extends Device implements Runnable {
	int numReadTotal;
	SocketChannel[][] outputChannels;
	SocketChannel[][] inputChannels;
	Selector selector;
	Selector selectorTmp;
	final static int INIT_BUFSIZE = 2097152; //Init buff size 2 MB
	//final static int INIT_BUFSIZE = 1024; //Init buff size 2 MB
	ByteBuffer recvBuffer;
	ByteBuffer sendBuffer;

	ByteBuffer finalizeBuffer;
	ByteBuffer commitBuffer;
	ByteBuffer readyToSendBuffer;
	ByteBuffer readyToRecvBuffer;

	int totalConnect;
	volatile boolean doneSend;
	byte[] bMID;

	protected Map semaphoreSet;
	protected Map<String, LargeMessageSender> largeMessagePending;
	protected Map<String, RDVHeaderInformation>  waitForRecvReady;

	public boolean isDone() {
		if(totalConnect == ((rankTable.size()-1)*2)) {
			return true;
		} else
			return false;
	}

	public NIODevice() {
		super();
		sendBuffer = ByteBuffer.allocateDirect(INIT_BUFSIZE);
		recvBuffer = ByteBuffer.allocateDirect(INIT_BUFSIZE);
		numReadTotal = 0;
		bMID = new byte[64];
		semaphoreSet= new HashMap();
		largeMessagePending = new HashMap<String, LargeMessageSender>();
		waitForRecvReady    = new HashMap<String, RDVHeaderInformation>();
		finalizeBuffer = ByteBuffer.allocateDirect(6);	//magic number (1) + messageType (1) + rankInList (4)
		commitBuffer   = ByteBuffer.allocateDirect(20);	//mn(1) + mt(1) + mid(18) [commID(2)+src(4)+dst(4)+tag(4)+numsend(4)]
		readyToSendBuffer = ByteBuffer.allocateDirect(32);	//mn(1) + mt(1) + mid(18) + rankInList(4) + mpiRank(4) + rankInRep(4)
		readyToRecvBuffer = ByteBuffer.allocateDirect(24);    //mn(1) + mt(1) + mid(18) + rank(4)
		//tpes = Executors.newFixedThreadPool(10);
		tpes = Executors.newCachedThreadPool();
	}


	// Open channel-socket for data transfer
	// return : data port
	// Only for Rank 0  : no need to start messageHandler thread yet
	public boolean init() {
		//Data channel
		try {
			selector = Selector.open();
			selectorTmp = Selector.open();
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	//use after init
	public int initPort(int minPort, int maxPort, String bindIP) {
		Random r = new Random();
		int randomStart = r.nextInt(maxPort - minPort) + minPort;

		int count = 2;
		while(count-- > 0) {
			for(int i = randomStart ; i <= maxPort; i++) {
				try {
					ServerSocketChannel serv = ServerSocketChannel.open();
					serv.configureBlocking(false);
					InetSocketAddress isa = new InetSocketAddress(bindIP, i);
					serv.socket().bind(isa);
					serv.register(selector, SelectionKey.OP_ACCEPT);
					return i;
				} catch(Exception e) {
                              //System.err.println("(warn) new InetSocketAddress("+bindIP+","+i+") failed.");
                              //e.printStackTrace();
				}
			}
			randomStart = minPort;
		}
		return -1;
	}



	public void sendReadyToRecv(short commID, int src, int dst, int tag , int numsend, int senderRIL, int senderRank, int senderRIR) {
		DatMessage readyToRecv = new DatMessage(readyToRecvBuffer, DatMessage.READY_TO_RECV);
		readyToRecv.pack(commID);
		readyToRecv.pack(src);
		readyToRecv.pack(dst);
		readyToRecv.pack(tag);
		readyToRecv.pack(numsend);
		readyToRecv.pack(myRankInList);
		readyToRecv.done();

		if(commWorld.isAlive(senderRIL)) {
			SocketChannel socket = outputChannels[senderRIR][senderRank];
			Semaphore sem = (Semaphore)semaphoreSet.get(socket);
			try {
				sem.acquire();
				toleranceWrite(readyToRecvBuffer, socket, senderRIL);
				sem.release();
			} catch (Exception e) { e. printStackTrace();}

		}
	}

	public int readUntilSize(SocketChannel socket) {
		int numRead;
		int totalRead = 0;
		try {
		do{
			numRead = socket.read(recvBuffer);
			totalRead += numRead;
		} while(numRead > 0);
		} catch (Exception e) {e.printStackTrace(); return totalRead; }
		return totalRead;
	}

	public void readWithTmpSelector(SocketChannel socket, int haveSize, int wantSize) {
		int totalRead = haveSize;

		try {
			int currentPosition = recvBuffer.position();
			int currentLimit    = recvBuffer.limit();
			recvBuffer.limit(recvBuffer.capacity());
			recvBuffer.position(currentLimit);

			SelectionKey kregister = socket.register(selectorTmp, SelectionKey.OP_READ);
			while(selectorTmp.select(20000) > 0) {
				Set readyKeys = selectorTmp.selectedKeys();
				Iterator it = readyKeys.iterator();
				while(it.hasNext()) {
					SelectionKey key = (SelectionKey)it.next();
					it.remove();
					if(key.isReadable()) {
						totalRead += readUntilSize(socket);
						if(totalRead >= wantSize) {
							recvBuffer.limit(recvBuffer.position());
							recvBuffer.position(currentPosition);
							kregister.cancel();
							selectorTmp.selectNow();
							return;
						}
					}
				}
			}

			recvBuffer.limit(recvBuffer.position());
			recvBuffer.position(currentPosition);
			kregister.cancel();
			selectorTmp.selectNow();
		} catch(Exception e) { e.printStackTrace();}
	}

	

	//For mpiclient : need to have msgHandle immediate to receive information
	public boolean init(ServerSocket cmdSocket, String myHash, int mpdPort, int fdPort) {

		this.myHash = myHash;
		this.fdPort = fdPort;
		this.mpdPort = mpdPort;
		//Command channel
		msgHandle = new MessageHandler(this, cmdSocket, myHash, mpdPort, fdPort);
		Thread msgHandleThread = new Thread(msgHandle);
		msgHandleThread.setDaemon(true);
		msgHandleThread.start();

		//Data channel
		try {
			//selector = SelectorProvider.provider().openSelector();
			selector = Selector.open();
			selectorTmp = Selector.open();
		} catch(Exception e) {
			return false;
		}
		return true;
	}

	//For rank 0
	public void spawnMessageHandler(ServerSocket cmdSocket, int numPeers, RankTable rankTable,
		                         String hash, int mpdPort, int fdPort,
				         int tGossip, int tMargin, int tHang,
				         String protocol) 
	{
		this.myHash = hash;
		this.fdPort = fdPort;
		this.mpdPort = mpdPort;
		msgHandle = new MessageHandler(this, cmdSocket, numPeers, rankTable, hash, mpdPort, fdPort);
		msgHandle.setTGossip(tGossip);
		msgHandle.setTMargin(tMargin);
		msgHandle.setTHang(tHang);
		msgHandle.setGossipProtocol(protocol);
		Thread msgHandleThread = new Thread(msgHandle);
		msgHandleThread.setDaemon(true);
		msgHandleThread.start();
	}		


	public void connect(int rank, int rankInRep, int rankInList, RankTable rankTable, int numProc, int numRep) {
		myRank = rank;
		myRankInRep = rankInRep;
		myRankInList = rankInList;
		this.rankTable = rankTable;
		this.numReplica = numRep;
		this.numProc    = numProc;
	
		int i = 2;
		while(i <= numProc) {
			if(i == numProc)
				N_POWER2 = true;
			i*=2;
		}

		inputChannels = new SocketChannel[numRep][numProc];
		outputChannels = new SocketChannel[numRep][numProc];
	}

	// open connection to a node in order to form all-to-all communication
	public boolean connectToNode(URI uri, int itsRank, int itsRankInRep, SocketChannel[][] socketChannels, byte isInput) {
		sendBuffer.clear();
		InetSocketAddress isa = null;
		try {
			isa = new InetSocketAddress(InetAddress.getByName(uri.getHost()), uri.getPort());
                  //System.out.println("connectToNode("+uri.getHost()+","+ uri.getPort()+")");
		} catch(Exception e) { //e.printStackTrace();  
			return false;
		}

		try {
			SocketChannel sock = SocketChannel.open();
			sock.configureBlocking(false);
			sock.socket().setSendBufferSize(524288);
			sock.socket().setReceiveBufferSize(524288);
			sock.socket().setTcpNoDelay(true);
			boolean connected = sock.connect(isa);

			SelectionKey key = sock.register(selector, SelectionKey.OP_CONNECT);
			key.attach(new Byte(isInput));
			socketChannels[itsRankInRep][itsRank] = sock;
			/*
			while(!sock.finishConnect()) {
				try {
					Thread.sleep(500);
				} catch(Exception e) {
				}
			}

			boolean donePrepareMsg = false;
			while(!donePrepareMsg) {
				try {
					DatMessage m = new DatMessage(sendBuffer, DatMessage.CONNECT);
					m.pack(myRank);
					m.pack(myRankInRep);
					m.pack(isInput);
					m.done();
					donePrepareMsg = true;
				} catch(BufferOverflowException e) {
					sendBuffer = ByteBuffer.allocateDirect(sendBuffer.capacity() * 2);
				}
			}
		
			if(sock.write(sendBuffer) > 0) {	
				sock.register(selector, SelectionKey.OP_READ);
				socketChannels[itsRankInRep][itsRank] = sock;
				totalConnect++;
				//add semaphore to lock output channel
				if(isInput == 0) {
					sock.keyFor(selector).cancel();
					sock.configureBlocking(true);
					sock.socket().setTcpNoDelay(true);
					semaphoreSet.put(sock, new Semaphore(1, true));
				} else {
				}
			}
			*/


		} catch(ConnectException ce) {
			System.out.println("[Error] : connect to address : " + ce.getMessage());
			return false;
		} catch(Exception e) {
			System.out.println("[Error] : connect to address : " + e.getMessage());
			return false;
		}
		return true;
	}


	public void run() {
		int totalNode = rankTable.size();
		int numNodetoWait = totalNode - myRankInList - 1;
		int numNodetoConnect = totalNode - numNodetoWait - 1;

		URI toConnect;
		//FileOutputStream fout;
		//PrintStream ps = null;
		try {
			//try to connect first
			//fout = new FileOutputStream("/home/nancy/sgenaud/p2pmpi-xp/log/"+myRank+"-"+totalNode+"-node");
			//ps = new PrintStream(fout);
			for(int i = 0; i < numNodetoConnect; i++) {
				toConnect = rankTable.getDataURI(i);
				int itsRank = rankTable.getRank(i);
				int itsRankInRep = rankTable.getRankInReplica(toConnect, i);
				//0 = input
				//ps.println("connect input to node:" + toConnect.toString());
				if(!connectToNode(toConnect, itsRank, itsRankInRep, outputChannels, (byte)0)) {
					//ps.println("connect input to node:" + toConnect.toString() + "failed");
					System.out.println("[Error] : Failed to create MPI communicator");
					System.exit(1);
				}
				//ps.println("connect output to node:" + toConnect.toString());
				//1 = output
				toConnect = rankTable.getCtrlURI(i);
				if(!connectToNode(toConnect, itsRank, itsRankInRep, inputChannels, (byte)1)) {
					System.out.println("[Error] : Failed to create MPI communicator");
				//	ps.println("connect output to node:" + toConnect.toString() + "failed");
					System.exit(1);
				}
			}
			//ps.println("-->> all done <<--");
			//fout.close();
			
			//and now wait for others to connect
			while(true) {
				selector.select();
				Iterator it = selector.selectedKeys().iterator();
				while(it.hasNext()) {
					SelectionKey selKey = (SelectionKey)it.next();
					it.remove();
					processSelectionKey(selKey);
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
			//ps.println(e.toString());
			//fout.close();
		}
	}

	//Operation based on RecvBuffer
	//return true : if no more pending data
	//return false : if received data is not full
	public boolean encodeMessage(SocketChannel sc, SelectionKey selKey) {
		int fromRank;
		int messageType;
		short commID;
		int src;
		int dst;
		int tag;
		int numsend;
		IStatus status;
		int senderRIL;
	

		String mid;
		try {	
			while(true) {

				if(recvBuffer.remaining() < 2) {	//magic number(1) + messagetype(1)
					return false;
				}

				//check header
				byte magicnumber = recvBuffer.get();
				if(magicnumber != DatMessage.MAGIC_NUMBER) {
					try {
						selKey.cancel();
						sc.close();
					} catch(Exception e) {
					}
					return false;
				}
				messageType = recvBuffer.get();	//get message type from protocol


				switch(messageType) {
					case DatMessage.CONNECT:
						//fromRank, fromRankInRap, isInput
						if(recvBuffer.remaining() < 9) {
							recvBuffer.position(recvBuffer.position() - 2);
							return false;
						}
						fromRank = recvBuffer.getInt();
						int fromRankInRep = recvBuffer.getInt();
						byte isInput = recvBuffer.get();
						if(isInput != 0) {
							outputChannels[fromRankInRep][fromRank] = sc;
							selKey.cancel();
							sc.configureBlocking(true);
							semaphoreSet.put(sc, new Semaphore(1, true));
						} else {
							inputChannels[fromRankInRep][fromRank] = sc;
						}
						totalConnect++;
						break;

					case DatMessage.UPDATE_STATUS :
						if(recvBuffer.remaining() < 18) {
							recvBuffer.position(recvBuffer.position() - 2);
							return false;
						}
						commID 	= recvBuffer.getShort();
						src 	= recvBuffer.getInt();
						dst	= recvBuffer.getInt();
						tag	= recvBuffer.getInt();
						numsend	= recvBuffer.getInt();

						mid = getMessageID(commID, src, dst, tag, numsend);


						// Compare with sendLog and backupMessage
						while(sendLog == null) {
							try {
								Thread.sleep(100);
							} catch (Exception e) {}
						}
						//Check if message is existed
						boolean logExist;
						synchronized (sendLog) {
							logExist = sendLog.isExist(mid);
						}

						if(logExist) {
							// If log is existed, it means that
							// this process is faster than master
							// then just remove log and backupBuffer
							synchronized (sendLog) {
								sendLog.remove(mid);
							}
							synchronized (backupBuffer) {
								int backupBufferSize = backupBuffer.size();
								for(int i = 0; i < backupBufferSize; i++) {
									if(mid.equals(backupBuffer.elementAt(i).toString())) {
										backupBuffer.removeElementAt(i);
										break;
									}
								}
							}

						} else {
							// log does not exist. it means that
							// this process is slower than master
							// then just add log 
							synchronized(sendLog) {
								sendLog.add(mid);
							}
						}
						break;

					case DatMessage.FINALIZE :
						if(recvBuffer.remaining() < 4) {
							recvBuffer.position(recvBuffer.position() - 2);
							return false;
						}
						int doneNodeRank = recvBuffer.getInt();
						synchronized(rankTable) {
							rankTable.setTerminated(doneNodeRank, true);
						}
						break;

					case DatMessage.FINALIZE_CONFIRM :
						terminated = true;
						break;

					case DatMessage.READY_TO_RECV : 
						if(recvBuffer.remaining() < 22) {
							recvBuffer.position(recvBuffer.position() - 2);
							return false;
						}
						commID = recvBuffer.getShort();
						src 	= recvBuffer.getInt();
						dst	= recvBuffer.getInt();
						tag	= recvBuffer.getInt();
						numsend	= recvBuffer.getInt();
						senderRIL  = recvBuffer.getInt();
						LargeMessageSender largeMessageSender = largeMessagePending.get(getHashKey(commID, src, dst, tag, numsend));
						if(numReplica == 1) {
							tpes.execute(largeMessageSender);
							largeMessagePending.remove(getHashKey(commID, src, dst, tag, numsend));
						} else {
							largeMessageSender.setReady(senderRIL);
							if(largeMessageSender.isReady()) {
								tpes.execute(largeMessageSender);
								largeMessagePending.remove(getHashKey(commID, src, dst, tag, numsend));
							} 
						}
						break;


					case DatMessage.READY_TO_SEND : 
						if(recvBuffer.remaining() < 30) {
							recvBuffer.position(recvBuffer.position() - 2);
							return false;
						}
						commID = recvBuffer.getShort();
						src 	= recvBuffer.getInt();
						dst	= recvBuffer.getInt();
						tag	= recvBuffer.getInt();
						numsend	= recvBuffer.getInt();
						senderRIL  = recvBuffer.getInt();
						int senderRank = recvBuffer.getInt();
						int senderRIR  = recvBuffer.getInt();


						//Check if recv is already posted in expected queue
						status = new IStatus();
						synchronized(unexpectedQueue) {
							synchronized(expectedQueue) {
								synchronized(waitForRecvReady) {
									if(isRequestInExpectedQueue(commID, src, dst, tag, numsend)) {


										sendReadyToRecv(commID, src, dst, tag , numsend, senderRIL, senderRank, senderRIR);
									} else {
										RDVHeaderInformation rdvInfo = 
											new RDVHeaderInformation(
													commID,
													src, 
													dst,
													tag,
													numsend,
													senderRIL,
													senderRank,
													senderRIR
													);
										waitForRecvReady.put(rdvInfo.toString(), rdvInfo);
									}
								}
							}
						}
						break;

					case DatMessage.DATA_MESSAGE :
						//long t1 = System.currentTimeMillis();
						if(recvBuffer.remaining() < 22) {
							recvBuffer.position(recvBuffer.position() - 2);
							return false;
						}
						commID 	= recvBuffer.getShort();
						src 	= recvBuffer.getInt();
						dst	= recvBuffer.getInt();
						tag	= recvBuffer.getInt();
						numsend	= recvBuffer.getInt();
						int size 	= recvBuffer.getInt();

						//MagicNumber(2) + messageType(1) +
						//MID (18) + size (4)
						//=== [ 1 : ignore this message ] ===
						if(recvBuffer.remaining() < size) {
							recvBuffer.position(recvBuffer.position() - 24);
							return false;
						}

						/*=== [2 : use busy loop to read all data] ====*/
						 //* Perf : worst than first one
						/*int dataReceived = recvBuffer.remaining();
						 if(dataReceived < size) {
							int lastPosition = recvBuffer.position();
							recvBuffer.position(recvBuffer.limit());
							recvBuffer.limit(recvBuffer.capacity());
							do{
								dataReceived += sc.read(recvBuffer);
							}
							while(dataReceived < size);

							recvBuffer.flip();
							recvBuffer.position(lastPosition);
						}
						*/
						//============================================*/

						/*=== [3 : use temporary select ] ==*/
						/*if(recvBuffer.remaining() < size) {
							readWithTmpSelector(sc, recvBuffer.remaining(), size);
						}*/


						//long t2 = System.currentTimeMillis();
						//System.out.println(myRank + ": recv Data size = " + size + " of tag = " + tag + "from " + src);


						//Check if recv is already posted in expected queue
						status = new IStatus();
						synchronized(unexpectedQueue) {
							synchronized(expectedQueue) {
							//CHOOPAN: if try semaphore here
							//lock unexpectedQueue
							//lock expectedQueue

								NIORequest recvReq = getRequestFromExpectedQueue(commID, src, dst, tag, numsend, status);
								
								mid = getMessageID(commID, src, dst, tag, numsend);

								if(recvReq != null) {
									//unlock expectedQueue
									//unlock unexpectedQueue
									int length = recvReq.addData(recvBuffer, size);
									recvReq.fillStatus(status, length);
									recvReq.complete();

								} else {
									//save data to unexpected queue
									//Add MPI data message to RecvBufferInformation vector
									byte[] bData = new byte[size];
									recvBuffer.get(bData, 0, size);
									ByteBuffer unexpectedBuffer = ByteBuffer.allocateDirect(size);
									unexpectedBuffer.put(bData, 0, size);
									unexpectedBuffer.flip();	
									if(!recvLog.isExist(mid)) {
										RecvBufferInformation buff = 
											new RecvBufferInformation(
													commID,
													src, 
													dst,
													unexpectedBuffer, 
													tag,
													numsend,
													null
													/*
													,0,
													0,0*/
													);
										unexpectedQueue.addElement(buff);
									} 
									//System.out.println(dst + ": add to expectedQueue");
								}
								synchronized(recvLog) {
									recvLog.add(mid);
									//unlock expectedQueue
									//unlock unexpectedQueue
								}

							}
						}
						System.gc();
						break;

					default :
						try {
							selKey.cancel();
							sc.close();
						} catch(Exception ee) {
						}
						break;
				}

				if(!recvBuffer.hasRemaining()) {
					return true;
				}
			}
		} catch(Exception e) {
			System.exit(1);
			return false;
		}
	}

	public void processSelectionKey(SelectionKey selKey) {
		String mid;
		List queue;
		Semaphore sem;
		String debugMessage = null;
            SocketChannel sChannel=null;
            
		try {
			if(selKey.isValid() && selKey.isConnectable()) {
				sChannel = (SocketChannel)selKey.channel();
				boolean success = sChannel.finishConnect();
				if(!success) {
					selKey.cancel();
				}
				//get attachment
				Byte isInputByte =  (Byte)selKey.attachment();
				byte isInput = isInputByte.byteValue();

				//prepare message
				boolean donePrepareMsg = false;
				while(!donePrepareMsg) {
					try {
						DatMessage m = new DatMessage(sendBuffer, DatMessage.CONNECT);
						m.pack(myRank);
						m.pack(myRankInRep);
						m.pack(isInput);
						m.done();
						donePrepareMsg = true;
					} catch(BufferOverflowException e) {
						sendBuffer = ByteBuffer.allocateDirect(sendBuffer.capacity() * 2);
					}
				}

				if(sChannel.write(sendBuffer) > 0) {	
					sChannel.register(selector, SelectionKey.OP_READ);
					totalConnect++;

					//add semaphore to lock output channel
					if(isInput == 0) {
						sChannel.keyFor(selector).cancel();
						sChannel.configureBlocking(true);
						sChannel.socket().setTcpNoDelay(true);
						semaphoreSet.put(sChannel, new Semaphore(1, true));
					} 
				}
			}

			if(selKey.isValid() && selKey.isReadable()) {
				//System.out.println(myRank + ": [select READABLE] -> " + System.currentTimeMillis());
				//long tt1 = System.currentTimeMillis();
				int numRead;
				boolean increaseBufferSize  = false;
				SocketAttachment attachment = null;
				int lastRecvBufferPosition = 0;

				ByteBuffer tmpBuffer = null;

				recvBuffer.clear();
				SocketChannel sc = (SocketChannel)selKey.channel();
				debugMessage = "[isReadable]: from "+ sc.toString();

				//get attachment
				attachment =  (SocketAttachment)selKey.attachment();
				if(attachment != null) {
					tmpBuffer   = recvBuffer;
					recvBuffer   = attachment.getBuffer();
					lastRecvBufferPosition = attachment.getPosition();
				}

				int totalRead = 0;
				do {
					numRead = sc.read(recvBuffer);
					//System.out.println(myRank + ":::[read] data = +" + numRead);
					totalRead += numRead;
					if(!recvBuffer.hasRemaining()) {
						ByteBuffer tmp   = ByteBuffer.allocateDirect(recvBuffer.capacity() * 2);
						if(attachment != null) {
							tmpBuffer  = ByteBuffer.allocateDirect(recvBuffer.capacity() * 2);
						}

						int oldPosition = recvBuffer.position();
						recvBuffer.position(0);
						recvBuffer.limit(recvBuffer.capacity());
						tmp.put(recvBuffer);
						tmp.position(oldPosition);
						recvBuffer = tmp;
					}
				} while(numRead > 0);

				//System.out.println(myRank + " :::[select readable] data => " + totalRead);

				if(totalRead < 0)  {
					try {
						selKey.cancel();
						sc.close();
					} catch (Exception e) {
						return;
					}
				} else if (totalRead == 0) {
					return;
				}


				recvBuffer.flip();
				//System.out.println(myRank + "Encode message pos = " + recvBuffer.position() + ",limit = "+ recvBuffer.limit() + ", cap = " + recvBuffer.capacity() + ",lastposition = " + lastRecvBufferPosition);
				//System.out.println(myRank + "Set lastRecvBufferPosition = " + lastRecvBufferPosition);
				recvBuffer.position(lastRecvBufferPosition);
				if(!encodeMessage(sc, selKey)) {
					if(recvBuffer.hasRemaining()) {
						//System.out.println(myRank + ":some message left in buffer pos = " + recvBuffer.position() + ", limit = " + recvBuffer.limit());
						//if there is attachBuffer
						if(attachment != null) {
							//return swap
							//System.out.println(myRank + ">> [not done encode] before swap buffer recvBuffer.pos=" + recvBuffer.position()  + ", limit = " + recvBuffer.limit());
							attachment.setPosition(recvBuffer.position());
							recvBuffer.position(recvBuffer.limit());
							recvBuffer.limit(recvBuffer.capacity());
							attachment.setBuffer(recvBuffer);
							recvBuffer = tmpBuffer;
							//System.out.println(myRank + ">> [not done encode] after swap buffer recvBuffer.pos=" + tmpBuffer.position()  + ", limit = " + tmpBuffer.limit());
						} else {
							//first time
							ByteBuffer attachBuffer = ByteBuffer.allocateDirect(recvBuffer.capacity());
							//System.out.println(myRank + ": allocate Buffer");
							attachBuffer.put(recvBuffer);
							attachBuffer.limit(recvBuffer.capacity());
							attachment = new SocketAttachment(attachBuffer, 0);
							selKey.attach(attachment);
							//System.out.println(myRank + ">>create attachBuffer pos = " + attachBuffer.position() + ", limit = " + attachBuffer.limit());

						}
					} 
				} else {
					//System.out.println(myRank + "Success encode ??? pos = " + recvBuffer.position()  + ", cap = " + recvBuffer.capacity());
					//reswap but never free ?
					//- : later can cause problem "out of memory" when too many  has its own buffer
					//+ : reduce time to allocate memeory each time they has message left on buffer
					if(attachment != null) {
						//return swap
						//System.out.println(myRank + ">> [done encode] swap buffer recvBuffer.pos=" + recvBuffer.position()  + ", limit = " + recvBuffer.limit());
						recvBuffer.clear();
						attachment.setBuffer(recvBuffer);
						attachment.setPosition(0);
						recvBuffer = tmpBuffer;
						//System.out.println("Swap and Clear tmpBuffer");
					}

				}

				//System.out.println("Time usage per readable = " + (System.currentTimeMillis() - tt1));
			}

			//register new connection to selector
			if(selKey.isValid() && selKey.isAcceptable()) {
				ServerSocketChannel serv = (ServerSocketChannel)selKey.channel();
				SocketChannel sock = serv.accept();
				sock.configureBlocking(false);
				sock.socket().setSendBufferSize(524288);
				sock.socket().setReceiveBufferSize(524288);
				sock.socket().setTcpNoDelay(true);
				sock.register(selector, SelectionKey.OP_READ);
			}

		} catch(Exception e) { 
			System.out.println("[Error] Socket Channel: "+sChannel.toString());
                  if (debugMessage != null)
                        System.out.println("[Error] extra info:" + debugMessage);
			e.printStackTrace();
		}
	}


	public void doFailureRepair(int deadNodeRankInList) {
		//System.out.println(myRank + ":[doFailureRepair] i'm doing failure repair");
		synchronized(rankTable) {
			rankTable.setAlive(deadNodeRankInList, false);
			rankTable.setTerminated(deadNodeRankInList, true);
		}
		int numPeers = rankTable.size();

		//Rank 0 is not there to take the result
		//Useless to compute for it
		//Let's quit and let FD detect its dead
		if(deadNodeRankInList == 0) {
			cleanupProcess();
			System.exit(1);
		}

		//Check if at least 1 process of each rank's still alive
		int commSize = msgHandle.getCommSize();
		boolean[] rankAliveNode = new boolean[commSize];
		//init with false
		for(int i = 0; i < commSize; i++) {
			rankAliveNode[i] = false;
		}
		synchronized(rankTable) {
			for(int i = 0; i < numPeers; i++) {
				if(rankTable.isAlive(i)) {
					rankAliveNode[rankTable.getRank(i)] = true;
				}
			}
		}
		for(int i = 0; i < commSize; i++) {
			if(!rankAliveNode[i]) {
				System.err.println("** [Error] rank " + i + " process failed (i.e. all replicas for that rank failed). Application did not completed. <<detected by rank in list: "+ myRankInList + ">>");

				cleanupProcess();
				System.exit(1);
			}
		}

		//Send notify to MPD
		NotifyMessage noMPDMsg = new NotifyMessage(myHash+"--"+myRank ,deadNodeRankInList);
		Socket so;
		OutputStream oout;
		ObjectOutputStream ooos;
		try {
			so = new Socket("127.0.0.1", mpdPort);
			oout = so.getOutputStream();
			ooos = new ObjectOutputStream(oout);
			ooos.writeObject(noMPDMsg);
			ooos.flush();
			ooos.close();
			oout.close();
			so.close();
		} catch (Exception e) {
			//System.out.println("NEW MASTER SEND :Can't reach dest");
		}
		//if dead node is master, check if it's new master
		//if it's a new master then resend message from backupBuffer
		if(deadNodeRankInList == myMaster) {
			//System.out.println(myRank + "[repair failure] aha the dead node is my master !!");
			//Check for new master
			int myNewMaster = myRankInList;
			int myCommSize = rankTable.size();
			for(int i = 0; i < myCommSize; i++) {
				if(myRank == rankTable.getRank(i)) {
					if(rankTable.isAlive(i)) {
						if(myNewMaster <= i) {
							// myself is a new master
							myMaster = i;
							master = true;
							break;
						} else {
							// found new master
							master = false;
							myMaster = i;
							break;
						}
					}
				}
			}


			//////////////////////////////////////////////////////////////////////////////
			// New Master Work
			//////////////////////////////////////////////////////////////////////////////
			if(master) {
				synchronized(backupBuffer) {
					while(backupBuffer.size() != 0) {
						SendBufferInformation binfo = backupBuffer.elementAt(0);

						String backupDataMID = getMessageID(binfo.getCommID(), binfo.getSrc(), 
								               binfo.getDst(), binfo.getTag(), binfo.getNumSend());
						//TODO : problem with ssend ?
						send(binfo.getRankTable(), binfo.getData(), binfo.getDestinations(), binfo.getCommID(), 
			 			     binfo.getSrc(), binfo.getDst(), binfo.getTag(), binfo.getNumSend(), binfo.getReplicaRankInList());
						//remove backup buffer
						backupBuffer.removeElementAt(0);
						sendLog.remove(backupDataMID);
					}
				}

			}
		}
		//check largeMessagePending Map to mark no-wait
		Iterator iter = largeMessagePending.keySet().iterator();
		while(iter.hasNext()) {
			String map = (String)iter.next();
			LargeMessageSender largeMessageSender = largeMessagePending.get(map);
			largeMessageSender.setReady(deadNodeRankInList);
			if(largeMessageSender.isReady()) {
				Thread largeMessageThread = new Thread(largeMessageSender);
				largeMessageThread.setDaemon(true);
				largeMessageThread.start();
				largeMessagePending.remove(map);
			} 
		}
	}

	public int send(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, 
			int src, int dst, int tag, int numsend, int[] repRankInList) {
		NIORequest req = isend(commTable, data, dest , commID, src, dst, tag, numsend, repRankInList);
		IStatus istatus = req.Wait();
		return 0;
		//return istatus.length;
	}

	public int ssend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, 
			int src, int dst, int tag, int numsend, int[] repRankInList) {
		NIORequest req = issend(commTable, data, dest , commID, src, dst, tag, numsend, repRankInList);
		IStatus istatus = req.Wait();
		return 0;
	}

	/*
	public int ssend(RankTable commTable, ByteBuffer data, short commID, 
			int src, int dst, int tag, int numsend, int[] repRankInList) {
		NIORequest req = issend(commTable, data, commID, src, dst, tag, numsend, repRankInList);
		IStatus istatus = req.Wait();
		return 0;
	}



	public NIORequest issend(RankTable commTable, ByteBuffer data, short commID,
			int src, int dst, int tag, int numsend, int[] repRankInList) {

		DatMessage readyToSend;
		LargeMessageSender largeMessageSender = null;
		NIORequest nioRequest = new NIORequest();

		readyToSend = new DatMessage(readyToSendBuffer, DatMessage.READY_TO_SEND);
		readyToSend.pack(commID);
		readyToSend.pack(src);
		readyToSend.pack(dst);
		readyToSend.pack(tag);
		readyToSend.pack(numsend);
		readyToSend.pack(myRankInList);
		readyToSend.pack(myRank);
		readyToSend.pack(myRankInRep);
		readyToSend.done();
		largeMessageSender = new LargeMessageSender(commTable, repRankInList, commID, src, dst, tag, numsend, readyToSendBuffer, data);

		SocketChannel socket = outputChannels[0][dst];
		SmallRequest smallRequest = new SmallRequest(0);
		nioRequest.add(smallRequest);

		Semaphore sem = (Semaphore)semaphoreSet.get(socket);
		try {
			sem.acquire();
			largeMessageSender.addDestination(socket, smallRequest, 0);
			sem.release();
		} catch (Exception e) { e. printStackTrace();}

		//Put NIORequest to hashMap
		largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
		largeMessageSender.sendReadyToSend();

		nioRequest.fillStatus(src, tag, 0); //TODO : length
		return nioRequest;
	}
	*/




	public NIORequest issend(RankTable commTable, ByteBuffer data, Vector<Integer>dest, short commID,
			int src, int dst, int tag, int numsend, int[] repRankInList) {

		//send to all replica
		int numDest = dest.size();
		DatMessage readyToSend;
		LargeMessageSender largeMessageSender = null;

		NIORequest nioRequest = new NIORequest();

		/*
		readyToSendBuffer.clear();
		readyToSendBuffer.put((byte)13);
		readyToSendBuffer.put((byte)6);
		readyToSendBuffer.putShort(commID);
		readyToSendBuffer.putInt(src);
		readyToSendBuffer.putInt(dst);
		readyToSendBuffer.putInt(tag);
		readyToSendBuffer.putInt(numsend);
		readyToSendBuffer.putInt(myRankInList);
		readyToSendBuffer.putInt(myRank);
		readyToSendBuffer.putInt(myRankInRep);
		readyToSendBuffer.flip();
		*/
		readyToSend = new DatMessage(readyToSendBuffer, DatMessage.READY_TO_SEND);
		readyToSend.pack(commID);
		readyToSend.pack(src);
		readyToSend.pack(dst);
		readyToSend.pack(tag);
		readyToSend.pack(numsend);
		readyToSend.pack(myRankInList);
		readyToSend.pack(myRank);
		readyToSend.pack(myRankInRep);
		readyToSend.done();
		largeMessageSender = new LargeMessageSender(commTable, repRankInList, commID, src, dst, tag, numsend, readyToSendBuffer, data);

		for(int i = 0; i < numDest; i++) {
			int ril = dest.elementAt(i).intValue();
			if(commWorld.isAlive(ril)) {
				SocketChannel socket = outputChannels[i][(getMapRankTable(commID)).getWorldRank(ril)];
				SmallRequest smallRequest = new SmallRequest(ril);
				nioRequest.add(smallRequest);


				Semaphore sem = (Semaphore)semaphoreSet.get(socket);
				try {
					sem.acquire();

					largeMessageSender.addDestination(socket, smallRequest, ril);
					sem.release();
				} catch (Exception e) { e. printStackTrace();}

			}
		}


		//Put NIORequest to hashMap
		largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
		largeMessageSender.sendReadyToSend();

		nioRequest.fillStatus(src, tag, 0); //TODO : length
		return nioRequest;
	}


	public NIORequest isend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID,
			int src, int dst, int tag, int numsend, int[] repRankInList) {

            // -- uncomment to log: long start=System.currentTimeMillis();
		//long t1 = System.currentTimeMillis();
		//send to all replica
		boolean eagerMode;
		int numDest = dest.size();
		int messageSize = data.limit();
            // -- uncomment to log: long timers[] = new long[ numDest ];
		DatMessage readyToSend;
		LargeMessageSender largeMessageSender = null;

		NIORequest nioRequest = new NIORequest();
		if(messageSize < EAGER_SIZE) {
			eagerMode = true;
		} else {
			eagerMode = false;
			readyToSend = new DatMessage(readyToSendBuffer, DatMessage.READY_TO_SEND);
			readyToSend.pack(commID);
			readyToSend.pack(src);
			readyToSend.pack(dst);
			readyToSend.pack(tag);
			readyToSend.pack(numsend);
			readyToSend.pack(myRankInList);
			readyToSend.pack(myRank);
			readyToSend.pack(myRankInRep);
			readyToSend.done();

			largeMessageSender = new LargeMessageSender(commTable, repRankInList, commID, src, dst, tag, numsend, readyToSendBuffer, data);
		}

		for(int i = 0; i < numDest; i++) {
                  // -- uncomment to log: long t0;
                  // -- uncomment to log: t0 = System.currentTimeMillis();
			int ril = dest.elementAt(i).intValue();
			if(commWorld.isAlive(ril)) {
				SocketChannel socket = outputChannels[i][(getMapRankTable(commID)).getWorldRank(ril)];
				SmallRequest smallRequest = new SmallRequest(ril);
				nioRequest.add(smallRequest);
				Semaphore sem = (Semaphore)semaphoreSet.get(socket);
				try {
					sem.acquire();
						
					if(eagerMode) {
						toleranceWrite(data, socket, ril);
						smallRequest.complete();
						data.rewind();
					} else {
						//prepare and send READY_TO_SEND Message
						largeMessageSender.addDestination(socket, smallRequest, ril);
					}
					sem.release();
				} catch (Exception e) { e. printStackTrace();}

			}
                  // -- uncomment to log: timers[i] = System.currentTimeMillis() - t0;
		}


		//Wait for sending message to be done and then send commit message
		if(eagerMode) {
			commit(commTable, repRankInList, commID, src, dst, tag, numsend);
		} else {
			//Put NIORequest to hashMap
			largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
			largeMessageSender.sendReadyToSend();
		}

		nioRequest.fillStatus(src, tag, 0); //TODO : length

            // log
            // -- uncomment to log: System.out.print("<log>");
            // -- uncomment to log: for (int i = 0; i < numDest; i++) {
            // -- uncomment to log:      System.out.print("["+timers[i]+"]");
            // -- uncomment to log:}
            // -- uncomment to log: System.out.println("--total:"+(System.currentTimeMillis()-start));
		return nioRequest;
	}

	public synchronized void commit(RankTable commTable, int[] repRankInList, 
			short commID, int src, int dst, int tag, int numsend) {

		SocketChannel socket;
		Semaphore sem;


		DatMessage m = new DatMessage(commitBuffer, DatMessage.UPDATE_STATUS);
		m.pack(commID);
		m.pack(src);
		m.pack(dst);
		m.pack(tag);
		m.pack(numsend);
		m.done();

		for(int i = 0; i < numReplica; i++) {
			if(repRankInList[i] != myRankInList) {
				if(commWorld.isAlive(repRankInList[i])) {

					socket = outputChannels[i][(getMapRankTable(commID)).getWorldRank(myRankInList)];
					sem = (Semaphore)semaphoreSet.get(socket);
					try {
						sem.acquire();
						toleranceWrite(commitBuffer, socket, repRankInList[i]);
						sem.release();
						commitBuffer.rewind();
					} catch (Exception e) {e.printStackTrace();}
				}
			}
		}
	}


	public void finalize(int rankInList) {
		DatMessage m = new DatMessage(finalizeBuffer, DatMessage.FINALIZE);
		m.pack(rankInList);
		m.done();

		SocketChannel socket = outputChannels[0][0];
		Semaphore sem = (Semaphore)semaphoreSet.get(socket);
		try {
			sem.acquire();
			//System.out.println(myRankInList + " : sending finalize to rank 0");
			toleranceWrite(finalizeBuffer, socket, 0);
			sem.release();
			//System.out.println(myRankInList + " : done sending finalize to rank 0");
		} catch (Exception e) {e.printStackTrace();}

		//Wait until no more message left in BackupBuffer
		/*
		int messageRemainWithoutCommit;
		synchronized (backupBuffer) {
			messageRemainWithoutCommit = backupBuffer.size();
		}
		while(messageRemainWithoutCommit != 0) {
			try {
				Thread.sleep(1000);	//sleep 1 second
			} catch(Exception e) {}
			synchronized (backupBuffer) {
				messageRemainWithoutCommit = backupBuffer.size();
			}
		}
		*/
	}


	public void finalizeConfirm() {
		ByteBuffer finalizeConfirmBuffer = ByteBuffer.allocate(3);
		finalizeConfirmBuffer.putShort(DatMessage.MAGIC_NUMBER);
		finalizeConfirmBuffer.put(DatMessage.FINALIZE_CONFIRM);
		finalizeConfirmBuffer.flip();

		int numNode = rankTable.size();
		URI dst;
		int dstRank, dstRankInRep;
		SocketChannel socket;
		Semaphore sem;

		for(int i = 1; i < numNode; i++) {
			dst     = rankTable.getDataURI(i);
			dstRank = rankTable.getRank(i);
			dstRankInRep = rankTable.getRankInReplica(dst, i);
			socket = outputChannels[dstRankInRep][dstRank];
			sem = (Semaphore)semaphoreSet.get(socket);
			try {
			//System.out.println(myRankInList + " : sending finalizeconfirm to rankInList  " + i + ",[dstRankInRep]="+dstRankInRep+",[dstRank]="+dstRank+", socket=" + socket);
				sem.acquire();
				toleranceWrite(finalizeConfirmBuffer, socket, i);
				sem.release();
			//System.out.println(myRankInList + " : done sending finalizeconfirm to rankInList  " + i + ",[dstRankInRep]="+dstRankInRep+",[dstRank]="+dstRank+", socket=" + socket);
			} catch(Exception e) {e.printStackTrace();}
			finalizeConfirmBuffer.position(0);
		}
	}

	private boolean reconnect(int ril) {
		URI toConnect    = rankTable.getDataURI(ril);
		int itsRank      = rankTable.getRank(ril);
		int itsRankInRep = rankTable.getRankInReplica(toConnect, ril);
		while(rankTable.isAlive(ril)) {
			if(!connectToNode(toConnect, itsRank, itsRankInRep, outputChannels, (byte)0)) {
				//not success to reconnect
				try {
					Thread.sleep(1000); //sleep 1 sec to reconnect
				} catch(Exception e) { }
			} else {
				//success to reconnect break and continue to write
				//TODO: maybe socket change
				return true;
			}
		}
		return false;
	}

	public void toleranceWrite(ByteBuffer data, SocketChannel socket, int ril) {
		int numWrite;
		//System.out.println(myRank + ": [toleranceWrite] enter tolerance with data remain = " + data.remaining());
		//long t1 = System.currentTimeMillis();
		//int x = data.remaining();
		while(data.hasRemaining()) {
			try {
				numWrite = socket.write(data);
				//System.out.println(myRank + ": [toleranceWrite] remain->" + data.remaining() + ", numWrite = "+ numWrite);
				if(numWrite < 0) {
					if(!reconnect(ril)) {
						return;
					}
				}
			} catch(Exception e) { 
				if(!reconnect(ril)) {
					return;
				}
			}
		}
		//System.out.println(myRank + ": [toleranceWrite] done write");
		//System.out.println(myRank + " toleranceWrite done use " + (System.currentTimeMillis() - t1));
	}

	public IStatus recv(Object recvBuffer, int offset, int count, short commID, int src, int dst, int tag, int numsend, P2PMPI_Buffer buffer) {

		NIORequest req = irecv(recvBuffer, offset, count, commID, src, dst, tag, numsend, buffer);
		IStatus istatus = req.Wait();
		return istatus;
	}

	public NIORequest irecv(Object recvBuffer, int offset, int count, short commID, int src, int dst, int tag, int numsend, P2PMPI_Buffer buffer) {
		NIORequest req = new NIORequest(recvBuffer, offset, count, src, dst, tag, buffer);
		synchronized(unexpectedQueue) {
			synchronized(expectedQueue) {
				synchronized(waitForRecvReady) {
					IStatus status = new IStatus();
					ByteBuffer data = getDataFromUnexpectedQueue(commID, src, dst, tag, numsend, status);

					//System.out.println(myRank + " call irecv for src = " + src + ",dst = " + dst + ", tag= "+ tag);
					//data is in unexpectedQueue
					if(data != null) {
						//System.out.println(myRank + "Data here before call RECV count = " + count + ",tag = " + tag);
						int length = req.addData(data, data.remaining());
						req.fillStatus(status, length);
						req.complete();
						return req;

					} else {
						//System.out.println(myRank + "Data post AFTER call RECV count = " + count + ",tag = " + tag);
						//get and remove from hashmap
						RDVHeaderInformation rdvInfo = waitForRecvReady.remove(getHashKey(commID, src, dst, tag, numsend));

						if(rdvInfo != null) {
							//READY_TO_SEND is received
							//just send READY_TO_RECV
							sendReadyToRecv(rdvInfo.getCommID(), 
									rdvInfo.getSrc(), 
									rdvInfo.getDst(), 
									rdvInfo.getTag(),
									rdvInfo.getNumSend(), 
									rdvInfo.getSenderRIL(), 
									rdvInfo.getSenderRank(), 
									rdvInfo.getSenderRIR());
						} 
						RecvBufferInformation buff = 
							new RecvBufferInformation(
									commID,
									src, 
									dst,
									null, 
									tag,
									numsend,
									req
									);

						expectedQueue.addElement(buff);
						//System.out.println(myRank + "========= add expected queue =======");
					}
				}
			}
		}
		return req;
	}



	public class LargeMessageSender implements Runnable {
		Vector<MessageSender> senderList;
		RankTable commTable;
		int[] repRankInList;
		short commID;
		int src;
		int dst;
		int tag;
		int numsend;
		ByteBuffer dataBuffer;
		int numSender;

		ByteBuffer readyToSendBuffer;
		long t1, t2, t3, t4;

		// for -R = 1
		SocketChannel destinationSocket;
		SmallRequest  destinationSmallRequest;
		int destinationRankInList;
		boolean readyToSend = false;

		public LargeMessageSender(RankTable commTable, int[] repRankInList, 
				short commID, int src, int dst, int tag, int numsend,
				ByteBuffer readyToSendBuffer, ByteBuffer data) {

			senderList 		= new Vector<MessageSender>();
			this.commTable 		= commTable;
			this.repRankInList 	= repRankInList;
			this.commID		= commID;
			this.src		= src;
			this.dst		= dst;
			this.tag		= tag;
			this.numsend		= numsend;
			numSender		= 0;
			this.readyToSendBuffer  = readyToSendBuffer;
			this.dataBuffer = data;
		}

		public String getKey() {
			return commID + "_" + src + "_" + dst + "_" + tag + "_" + numsend;
		}

		public void sendReadyToSend() {
			MessageSender sender;
			SocketChannel socket;
			int ril;
			Semaphore sem;

			if(numReplica == 1) {
					sem = (Semaphore)semaphoreSet.get(destinationSocket);
					try {
						sem.acquire();
						toleranceWrite(readyToSendBuffer, destinationSocket, destinationRankInList);
						sem.release();
					} catch (Exception e) { e. printStackTrace();}

			} else {
				for(int i = 0; i < numSender; i++) {
					sender = senderList.elementAt(i);
					socket = sender.getSocket();
					ril    = sender.getDestination();

					sem = (Semaphore)semaphoreSet.get(socket);
					try {
						sem.acquire();
						toleranceWrite(readyToSendBuffer, socket, ril);
						readyToSendBuffer.rewind();
						sem.release();
					} catch (Exception e) { e. printStackTrace();}
				}
			}
		}

		public void addDestination(SocketChannel socket, SmallRequest smallRequest, int rankInList) {
			if(numReplica == 1) {
				destinationSocket 		= socket;
				destinationSmallRequest 	= smallRequest;
				destinationRankInList		= rankInList;	
			} else {
				MessageSender sender =  new MessageSender(socket, smallRequest, rankInList);
				senderList.add(sender); //add to vector
				numSender++;
			}
		}

		public void setReady(int dstRIL) {
			if(numReplica == 1) {
				if(destinationRankInList == dstRIL) {
					readyToSend = true;
				}
			} else {
				MessageSender sender;
				for(int i = 0; i < numSender; i++) {
					sender = senderList.elementAt(i);
					if(sender.getDestination() == dstRIL) {
						sender.setReady();
						break;
					}
				}
			}
		}

		public boolean isReady() {
			if(numReplica == 1) {
				return readyToSend;
			} else {
				MessageSender sender;
				for(int i = 0; i < numSender; i++) {
					sender = senderList.elementAt(i);
					if(!sender.isReady())
						return false;
				}
				return true;
			}
		}

		public void run() {
			MessageSender sender;
			SocketChannel socket;
			int ril;
			SmallRequest smallRequest;
			Semaphore sem;

			if(numReplica == 1) {
				sem = (Semaphore)semaphoreSet.get(destinationSocket);
				try {
					sem.acquire();
					toleranceWrite(dataBuffer, destinationSocket, destinationRankInList);
					if(destinationSmallRequest != null) {
						destinationSmallRequest.complete();
					}
					sem.release();
				} catch(Exception e) {}

				//commit message
				commit(commTable, repRankInList, commID, src, dst, tag, numsend);
			} else {
				for(int i = 0; i < numSender; i++) {
					sender = senderList.elementAt(i);
					socket = sender.getSocket();
					ril    = sender.getDestination();
					smallRequest = sender.getSmallRequest();

					sem = (Semaphore)semaphoreSet.get(socket);

					try {
						sem.acquire();
						toleranceWrite(dataBuffer, socket, ril);	//true or false just complete it
						if(smallRequest != null) {
							smallRequest.complete();
						}
						dataBuffer.rewind();
						sem.release();
					} catch(Exception e) {}

				}
				//commit message
				commit(commTable, repRankInList, commID, src, dst, tag, numsend);
			}
		}
	}


	public class MessageSender  {
		SocketChannel socket;
		SmallRequest smallRequest;
		int rankInList;
		boolean readyToSend;

		public MessageSender(SocketChannel socket, SmallRequest smallRequest, int rankInList) {
			this.socket 		= socket;
			this.smallRequest 	= smallRequest;
			this.rankInList 	= rankInList;
			this.readyToSend 	= false;
		}

		public void setReady() {
			readyToSend = true;
		}

		public boolean isReady() {
			return readyToSend;
		}

		public SocketChannel getSocket() {
			return socket;
		}

		public int getDestination() {
			return rankInList;
		}

		public SmallRequest getSmallRequest() {
			return smallRequest;
		}
	}


	public class SocketAttachment {
		ByteBuffer buffer;
		int position;

		public  SocketAttachment(ByteBuffer buffer, int position) {
			this.buffer    = buffer;
			this.position  = position;
		}

		public ByteBuffer getBuffer() {
			return buffer;
		}

		public int getPosition() {
			return position;
		}

		public void setBuffer(ByteBuffer buffer) {
			this.buffer = buffer;
		}

		public void setPosition(int position) {
			this.position = position;
		}
	}
}
