package p2pmpi.mpi.dev;

import java.util.*;
import java.io.*;

public class MessageIDLog {
	int MAXLOG = 256;
	int numLog = 0;
	HashMap<String, String> log;
	Vector<String> backupLog;
	
	public MessageIDLog() {
		numLog = 0;
		backupLog = new Vector<String>();
		log = new HashMap<String, String>();
	}

	public void add(String mid) {
		if(numLog > MAXLOG) {
			String removeMID = backupLog.elementAt(0);
			remove(removeMID);
			backupLog.removeElementAt(0);
			numLog--;
		}
		log.put(mid, null);
		backupLog.addElement(mid);
		numLog++;
	}

	// return -1 is not exist
	// if not return index to mid
	public boolean isExist(String mid) {
		return log.containsKey(mid);
	}

	public void remove(String mid) {
		log.remove(mid);
		backupLog.remove(mid);
		numLog--;
	}

	/*
	Vector<String> log;
	public MessageIDLog() {
		log = new Vector<String>();
	}

	public void add(String mid) {
		log.addElement(mid);
	}

	// return -1 is not exist
	// if not return index to mid
	public int isExist(String mid) {
		int numLog = log.size();
		String tmpID;

		for(int i = 0; i < numLog; i++) {
			tmpID = log.elementAt(i);
			if(tmpID.equals(mid)) {
				return i;
			}
		}
		return -1;
	}

	public void remove(String mid) {
		int numLog = log.size();
		String tmpID;

		for(int i = 0; i < numLog; i++) {
			tmpID = log.elementAt(i);
			if(tmpID.equals(mid)) {
				log.removeElementAt(i);
				break;
			}
		}
	}

	public void printInfo() {
		int numLog = log.size();
		for(int i = 0; i < numLog; i++)
			System.out.println("MID = " + log.elementAt(i));
	}
	*/
}
