package p2pmpi.mpi.dev;

import java.util.*;
import java.nio.*;
import java.nio.channels.*;

/**
 * Primitive datatypes
 */
public class DevDatatype {
	/**
	 * Primitive datatype (NULL)
	 */
	public final static int NULL    = 0;
	/**
	 * Primitive datatype (Byte)
	 */
	public final static int BYTE    = 1;

	/**
	 * Primitive datatype (Char)
	 */
	public final static int CHAR    = 2;

	/**
	 * Primitive datatype (Short)
	 */
	public final static int SHORT   = 3;

	/**
	 * Primitive datatype (Boolean)
	 */
	public final static int BOOLEAN = 4;

	/**
	 * Primitive datatype (Integer)
	 */
	public final static int INT     = 5;

	/**
	 * Primitive datatype (Long)
	 */
	public final static int LONG    = 6;

	/**
	 * Primitive datatype (Float)
	 */
	public final static int FLOAT   = 7;

	/**
	 * Primitive datatype (Double)
	 */
	public final static int DOUBLE  = 8;

	/**
	 * Primitive datatype (not available yet)
	 */
	public final static int PACKED  = 9;	// Not available

	/**
	 * Primitive datatype (String)
	 */
	public final static int STRING  = 10;

	public final static int OBJECT	= 11;
	//public final static int OBJECT	= 12;

	/**
	 * Size (in byte) of each datatype
	 */
	public final static int[] typeSize = {0, 1, 2, 2, 1, 4, 8, 4, 8, 0, 1, 1};
}
