package p2pmpi.mpi.dev;

import java.nio.*;
import java.io.*;

public class BufferObject extends P2PMPI_Buffer {

	protected byte[] ObjectSerialize(Object buff, int offset, int count) {
		ByteArrayOutputStream 	o;
		ObjectOutputStream	out;

		Object[] buffArray = (Object[])buff;
		try {
			o = new ByteArrayOutputStream();
			out = new ObjectOutputStream(o);
			for(int i = offset; i < offset+count; i++) {
				out.writeObject(buffArray[i]);
			}
			out.flush();
			out.close();
		} catch(Exception e) {
			e.printStackTrace();
			return null;
		}

		return o.toByteArray();
	}

	protected void ObjectDeserialize(Object buff, byte[] data, int offset, int count) {
		Object[] buffArray = (Object [])buff;
		try {
			ByteArrayInputStream in = new ByteArrayInputStream(data);
			ObjectInputStream s = new ObjectInputStream(in);
			for(int i = offset; i < offset+count; i++) {
				buffArray[i] = s.readObject();
			}
			s.close();
		} catch(Exception e) {/* e.printStackTrace();*/ }
	}


	public BufferObject(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		byte[] byteDat = ObjectSerialize(buffer, offset, count);
		int size = byteDat.length;

		//create new myBuffer
		ByteBuffer newBuffer = ByteBuffer.allocateDirect(HEADER_SIZE + size);
		fillHeader(newBuffer);
		newBuffer.putInt(size);
		newBuffer.put(byteDat);

		return newBuffer;

		//replace old myBuffer with the new one
		//myBuffer = newBuffer;
		//myBuffer.put(byteDat);
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		byte[] byteDat = new byte[dataSize];
		data.get(byteDat);
		ObjectDeserialize(buffer, byteDat, offset, count);

		return (count-offset)*baseSize;
	}

	public Object createArrayBuffer(int count) {
		//can't create array buffer of Object type
		return null;
	}
}
