package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferDouble extends P2PMPI_Buffer {
	public BufferDouble(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		//double[] doubleDat  = (double[])buffer;
		DoubleBuffer dBuffer = myBuffer.asDoubleBuffer();
		dBuffer.put((double[])buffer, offset, count);
		myBuffer.position(myBuffer.position() + (count*baseSize));
	
		/*
		double[] doubleDat  = (double[])buffer;
		int end = offset + count;
		for(int i = offset; i < end; i++) {
			myBuffer.putDouble(doubleDat[i]);
		}
		*/
		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {

		int recvData;
		if((dataSize/baseSize) < count)
			recvData = dataSize/baseSize;
		else
			recvData = count;
		//double[] doubleDat = (double[])buffer;
		//long t1 = System.currentTimeMillis();
		DoubleBuffer dBuffer = data.asDoubleBuffer();
		dBuffer.get((double[])buffer, offset, recvData);
		data.position(data.position() + (recvData*baseSize));
		//System.out.println("fillBuffer -> " + (System.currentTimeMillis() - t1));

		/*
		double[] doubleDat = (double[])buffer;
		int end = offset + count;

		for(int i = offset; i < end; i++) {
			doubleDat[i] = data.getDouble();
		}
		*/
		return (recvData - offset) * baseSize;
	}

	public Object createArrayBuffer(int count) {
		return new double[count];
	}

}
