/**
 * DevicePort : simple helper class to allocate a port + URI using the device in use 
 * Note: was an inner class of MPI.java first, but useful also to MPIClient.java
 * @author: genaud
 *
 **/


package p2pmpi.mpi; 

import p2pmpi.mpi.dev.*;
import java.net.*;
import java.io.*;
import java.util.*;


      /**
        * allocate a port and set URI
        **/
      public class DevicePort extends MPI {
            int port;
            int minPort;
            int maxPort;
            URI intUri;
            URI extUri;
            String status;

            public DevicePort( int minPort, int maxPort, String portInfo) {

                    String status=null;
                    String intIp = getLocalhostIntIp();
                    
                    // in case of private network, do not use the external ip to create
                    // the device since it will fail with nio.
                    if((port = myDevice.initPort(minPort, maxPort, intIp)) == -1) {
                            System.err.println("No available ports for "+
                                            portInfo + " in the range allowed "+
                                            intIp + ":[" + minPort + "--" + maxPort + "] to run this application");
                            System.exit(1);
                    }
                    try {
                            intUri = new URI("tcp://" + intIp + ":"+port);
                            extUri = new URI("tcp://" + getLocalhostExtIp() + ":"+port);

                    } catch (Exception e) {
                            //e.printStackTrace();
                            status = e.getMessage();
                    }
            }

            int getPort() {
                  return ( port) ;
            }

            // the URI to contact me from inside the private networkd 
            URI getIntURI() {
                  return ( intUri );
            }
            // the URI to contact me from the outside (my public URI)
            URI getExtURI() {
                  return ( extUri );
            }

            String getMessage() {
                  return( status );
            }

 } // end of class 

