package p2pmpi.message;

import java.net.*;
import p2pmpi.common.*;
import java.io.*;
import java.util.*;

public class RSMessage implements Serializable {
	private static final long serialVersionUID = 2000032L;
	int cmd;
	boolean reserved;
	int status;
	String hashID;
	int reply;
	long reservePeriod;
	String ip;
      String mpdVer;     // version of running MPD
	Vector<HostEntry> list;
	//Vector<HostEntry> reservedList;
	Vector<HostEntry> deadList;

	//Command
	public static final int MPD_REQUEST_RESERVATION_TO_RS = 0;
	public static final int RS_REQUEST_RESERVATION_TO_RS  = 1;
	public static final int RS_REPLY_RESERVATION_TO_RS    = 2;
	public static final int RS_REPLY_RESERVATION_TO_MPD   = 3;
	public static final int MPD_UPDATE_STATUS_TO_RS       = 4;
	public static final int MPD_CANCEL_RESERVATION_TO_RS  = 5;
	public static final int RS_CANCEL_RESERVATION_TO_RS   = 6;
	public static final int MPI_UPDATE_STATUS_TO_RS       = 7;
	public static final int NOOP = 100;

	// Status
	public static int RESERVED = 0;
	public static int RUNNING  = 1;

	// Common operations
	public RSMessage(int cmd, String hashID, String ip, String mpdVer) {
		this.cmd = cmd;
		this.hashID = hashID;
		this.ip     = ip;
            this.mpdVer = mpdVer;
	}

	public RSMessage(int cmd, String hashID) {
		this.cmd = cmd;
		this.hashID = hashID;
	}

	public RSMessage() {
		this.cmd = NOOP;
		this.hashID = null;
	}

	public String getIp() {
		return ip;
	}

	public String getMpdVer() {
		return mpdVer;
	}

	public int getCommand() {
		return cmd;
	}

	public String getHashID() {
		return hashID;
	}

	// MPD_REQUEST_RESERVATION_TO_RS  operations
	public void setList(Vector<HostEntry> list) {
		this.list = list;
	}

	public Vector<HostEntry> getList() {
		return list;
	}

	// RS_REQUEST_RESERVATION_TO_RS no operations
	
	
	// RS_REPLY_RESERVATION_TO_RS  operations
	public void setReservationReply(int reply) {
		this.reply = reply;
	}	
	public int getReservationReply() {
		return reply;
	}

	// RS_REPLY_RESERVATION_TO_MPD operations
	/*
	public void setReservedList(Vector<HostEntry> reservedList) {
		this.reservedList = reservedList;
	}*/

	public void setDeadList(Vector<HostEntry> deadList) {
		this.deadList = deadList;
	}

	/*
	public Vector<HostEntry> getReservedList() {
		return reservedList;
	}
	*/

	public Vector<HostEntry> getDeadList() {
		return deadList;
	}

	// MPD_UPDATE_STATUS_TO_RS operations
	public void setStatus(int status) {
		this.status = status;
	}

	public void setReservePeriod(long reservePeriod) {
		this.reservePeriod = reservePeriod;
	}
	public long getReservePeriod() {
		return reservePeriod;
	}

	public int getStatus() {
		return status;
	}

	public void setReserved(boolean reserved) {
		this.reserved = reserved;
	}
	public boolean isReserved() {
		return reserved;
	}

	//MPD_CANCEL_RESERVATION_TO_RS operations
	// use setReservedList and getReservedList
}
