package p2pmpi.message;

import p2pmpi.common.*;

import java.net.*;
import java.io.*;
import java.util.Vector;

public class MPDMessage implements Serializable {
	private static final long serialVersionUID = 2000019L;
	//Common
	int cmd;
	String hashID = null;

	//REQ
	int minPeers;
	int maxPeers;

	int optionN;
	int optionR;

	int waitTime;
	URI myURI = null;
	String runCmd = null;
	File runDir = null;
	int rank;

	//ACCEPT
	int ftPort;
	int fdPort;
	String myHost;

	//Transfer Done
	int key;
	String jarDep = "_";
	String allocationMode;

	// Transfer failed
	String errMessage=null;
	
	// For 'data-*' allocation strategy
	Vector<FileCharacteristics> fileCharacteristicsVector;
	boolean cacheIsChanged = false;

	public MPDMessage(int cmd, String hashID) {
		this.cmd = cmd;
		this.hashID = hashID;
	}

	public void setAllocationMode(String allocationMode) {
		this.allocationMode = new String(allocationMode);
	}

	public String getAllocationMode() {
		return allocationMode;
	}


	public void setOptionN(int n) {
		optionN = n;
	}

	public void setOptionR(int r) {
		optionR = r;
	}

	public int getOptionN() {
		return optionN;
	}

	public int getOptionR() {
		return optionR;
	}

	public void setJars(String jarDep) {
		this.jarDep = jarDep;
	}

	public String getJars() {
		return jarDep;
	}

	public void setRunDir(File runDir) {
		this.runDir = runDir;
	}

	public File getRunDir() {
		return runDir;
	}

	public void setKey(int key) {
		this.key = key;
	}

	public int getKey() {
		return key;
	}

	public void setFTPort(int ftPort) {
		this.ftPort = ftPort;
	}

	public void setFDPort(int fdPort) {
		this.fdPort = fdPort;
	}

	public void setMyHost(String host) {
		this.myHost = host;
	}

	public int getFTPort() {
		return ftPort;
	}

	public int getFDPort() {
		return fdPort;
	}

	public String getHost() {
		return myHost;
	}

	public void setRank(int rank) {
		this.rank = rank;
	}

	public int getRank() {
		return rank;
	}

	public String getID() {
		return hashID;
	}

	public int getCmd() {
		return cmd;
	}

	public void setURI(URI u) {
		myURI = u;
	}

	public void setURI(String host, int port) {
		try {
			myURI = new URI("tcp://" + host + ":" + port);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public URI getURI() {
		return myURI;
	}

	public void setMinPeers(int num) {
		minPeers = num;
	}
	public void setMaxPeers(int num) {
		maxPeers = num;
	}
	public void setWaitTime(int second) {
		waitTime = second;
	}

      public void setErrorMessage(String s) {
            this.errMessage = s;
      }


	public int getMinPeers() {
		return minPeers;
	}
	public int getMaxPeers() {
		return maxPeers;
	}
	public int getWaitTime() {
		return waitTime;
	}

	public void setRunCmd(String runCmd) {
		this.runCmd = runCmd;
	}

	public String getRunCmd() {
		return runCmd;
	}

	public String getErrorMessage() {
		return errMessage;
	}
	
	public void setFileCharacteristics(Vector<FileCharacteristics> fileCharacteristicsVector) {
		this.fileCharacteristicsVector = fileCharacteristicsVector;
	}
	
	public Vector<FileCharacteristics> getFileCharacteristics() {
		return (this.fileCharacteristicsVector);
	}
	
	public void setCacheIsChanged(boolean cacheIsChanged) {
		this.cacheIsChanged = cacheIsChanged;
	}
	
	public boolean getCacheIsChanged() {
		return (this.cacheIsChanged);
	}
}
