package p2pmpi.message;

import java.io.*;
import java.net.*;

public class GossipMessage implements Serializable {
	private static final long serialVersionUID = 2000016L;
	int gossipCmd = MessageCmd.NOCOMMAND;
	String hashID = null;

	int myRank;
	int myMPIRank;
	int toRank;
	int mpiPort;
	URI[] uri;
	long[] heartbeat;
	int t_gossip;
	int t_margin;
	int t_diff;
	int t_hang;
	long t_stamp;
	String gossipProtocol;

	public GossipMessage(int cmd, String id) {
		gossipCmd 	= cmd;
		hashID		= new String(id);
	}

	public void setGossipProtocol(String protocol) {
		gossipProtocol = new String(protocol);
	}

	public String getGossipProtocol() {
		return gossipProtocol;
	}

	public void setTHang(int t_hang) {
		this.t_hang = t_hang;
	}

	public int getTHang() {
		return t_hang;
	}

	public void setTDiff(long t_stamp, int t_diff) {
		this.t_stamp = t_stamp;
		this.t_diff  = t_diff;
	}

	public int getTDiff() {
		return t_diff;
	}

	public long getTStamp() {
		return t_stamp;
	}

	public void setTGossip(int t_gossip) {
		this.t_gossip = t_gossip;
	}

	public void setTMargin(int t_margin) {
		this.t_margin = t_margin;
	}

	public int getTGossip() {
		return t_gossip;
	}

	public int getTMargin() {
		return t_margin;
	}

	public void setMPIRank(int mpiRank) {
		myMPIRank = mpiRank;
	}

	public int getMPIRank() {
		return myMPIRank;
	}

	public void setToRank(int rank) {
		toRank = rank;
	}

	public int getToRank() {
		return toRank;
	}


	public void setMyRank(int rank) {
		myRank = rank;
	}

	public int getMyRank() {
		return myRank;
	}

	public int getCommand() {
		return gossipCmd;
	}

	public String getGossipID() {
		return hashID;
	}

	public void setMPIPort(int mpiPort) {
		this.mpiPort = mpiPort;
	}

	public int getMPIPort() {
		return mpiPort;
	}

	public void setURIList(URI[] uri) {
		this.uri = uri;
	}

	public void setHeartBeatList(long[] heartbeat) {
		this.heartbeat = heartbeat;
	}

	public URI[] getURIList() {
		return uri;
	}

	public long[] getHeartBeatList() {
		return heartbeat;
	}

}
