package p2pmpi.message;

import p2pmpi.common.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class FTMessage implements Serializable {
	private static final long serialVersionUID = 2000015L;
	//Common
	int cmd;
	String hashID;
	String[] onlyFileNameList;
	boolean[] notToBeSent;
	Vector<FileCharacteristics> fileCharacteristicsVector;
	long[] fileSize;

	//REGISTER
	URI[] uriList;
	URI replyURI;
	int[] keyList;

	byte[][] fileContent;
	int size;
	URI rank0URI;

	//Transfer
	int key;
	

	public FTMessage(int cmd, String hashID) {
		this.cmd = cmd;
		this.hashID = hashID;
	}

	public void setKeys(int[] keyList) {
		this.keyList = keyList;
	}

	public void setURIs(URI[] uriList) {
		this.uriList = uriList;
	}

	public int[] getKeys() {
		return (this.keyList);
	}

	public URI[] getURIs() {
		return (this.uriList);
	}

	public void setRank0URI(URI rank0URI) {
		this.rank0URI = rank0URI;
	}

	public void setReplyURI (URI replyURI) {
		this.replyURI=replyURI;
	}

	public URI getReplyURI () {
		return (this.replyURI);
	}

	/**
	 * loads files to be transfered into memory.
	 *
	 * @param fList the filenames list of files to load into memory
	 *
	 * The message to be sent will contain the files contents of files
	 * designated by their absolute path in the filelist passed as parameter
	 * (p2pmpirun -l). 
	 * To DO : If a file is designated as an URL, pass the URL not the file contents.  
	 **/

	public void setFileContent(String[] fList) throws Exception {

		File tmpfile;
		FileInputStream files;
		int fileSize;
		fileContent = new byte[fList.length][];
		for(int i = 0; i < fList.length; i++) {
			tmpfile = new File(fList[i]);
			if (fList[i].startsWith("http://")) {
				fileContent[i] = new byte[56 /* FIX ME : md5sum length */];
				/* fileContent[i]= tmpfile.md5sum(); */
			}
			else {
				// Get file size
				tmpfile = new File(fList[i]);
				fileSize = (int)(tmpfile.length());
				// Read file
				try {
					// to simulate an OutOfMemory exception :
					//fileContent[i] = new byte[1000*1000000];
					fileContent[i] = new byte[fileSize];
					// to simulate a non existing file 
					//fList[0]= "A_foo_filename_to_test";
					files = new FileInputStream(fList[i]);
					files.read(fileContent[i], 0, fileSize);
					files.close();
				} catch (OutOfMemoryError e) {
					java.lang.System.gc();
					System.out.println("** [FT] file "+ fList[i] + " to big to fit in memory.");
					throw new Exception( "OutOfMemoryError while loading "+fList[i]); 
				} catch (Exception e) { 
					System.out.println("** [FT] Error trying to access file "+ fList[i]);
					e.printStackTrace();
					throw new Exception( e );
				}
			}
		}
	}
	
	public void setFileCharacteristicsVector(Vector<FileCharacteristics> fileCharacteristicsVector) {
		this.fileCharacteristicsVector = fileCharacteristicsVector;
	}
	
	public Vector<FileCharacteristics> getFileCharacteristicsVector() {
		return (this.fileCharacteristicsVector);
	}
	
	public void setBooleanSent(boolean[] notToBeSent) {
		this.notToBeSent = notToBeSent;
	}
	
	public boolean[] getBooleanSent() {
		return (this.notToBeSent);
	}
	public void setOnlyFileNameList(String[] onlyFileNameList) {
		this.onlyFileNameList = onlyFileNameList;
	}
	
	public String[] getOnlyFileNameList() {
		return (this.onlyFileNameList);
	}

	public byte[] getFileContent(int index) {
		return fileContent[index];
	}

	public void setSize(int size) {
		this.size = size;
	}

	public URI getRank0URI() {
		return( this.rank0URI );
	}

	public void setCmd(int Cmd) {
		this.cmd=Cmd;
	}

	public int getCmd() {
		return( this.cmd );
	}

	public String getID() {
		return (this.hashID);
	}

	public int getKey(int index) {
		return (this.keyList[index]);
	}

	public URI getURI(int index) {
		return (this.uriList[index]);
	}

	public int size() {
		return (this.size);
	}

	// Transfer
	public void setKey(int key) {
		this.key = key;
	}

	public int getKey() {
		return key;
	}
}
