package p2pmpi.ft;

import java.awt.*;
import java.io.*;
import java.net.*;

//---- for MD5sum
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.math.BigInteger;


/**
   * @author genaud
   *
   * This class aims to implement 'wget'-like functionnalities.   
   *
   * Warning : the setContent() method will fill a buffer in memory of 
   * the entire data file downloaded. Future work will deal with partial
   * loading. 
   *
   * Usage : see main() method for a test-case.
*/
public class RemoteData {


     private URL url;
     private byte [] data = null;
     private String mimeType=null;
     private byte[] mybytearray;
     
     
     RemoteData (String address) 
      throws MalformedURLException, IOException
     {
		url = new URL(address);
     }
     		 
    /**
	* Lookup the mimetype returned for the given URL and store it.
	*
	* @param address URL where to find data.
	**/
    public void setMimeType(String address) 
       throws MalformedURLException, IOException 
    {
	  URLConnection conn =  url.openConnection();
        mimeType =  conn.getContentType();
    }
    /**
	* Get the mimetype of the file pointed by address, or null
	* if setMimeType has not been called yet.
	*
	* @param address URL where to find data.
	**/
    public String getMimeType() {
	     return (mimeType);
    }	     

    /**
	* Fetch the contents of a URL and stores it directly to file
      *	
      * @param address the URL to fetch data from.
	* @return true if contents has been set, false if failed.
	**/
 
    
    public boolean setContentandWriteToFile(String filename) throws MalformedURLException, IOException{
        
    	File file = new File( filename );
    	URLConnection conn =  url.openConnection();

    	boolean documentSet=true;
    	int buffersize =20*1024*1024 ; // 20 MB size buffer
    	int bytesRead=0;
    	int current = 0;


    	try{
    		FileOutputStream fos = new FileOutputStream(file);  
    		do {

    			try {
    				java.lang.System.gc();
    				mybytearray = new byte[buffersize];
    			}
    			catch (OutOfMemoryError e)
    			{
    				
    				System.out.println("** [FT] Not enough memory when trying to allocate "+buffersize+" bytes."); 
    			}
    			InputStream input = conn.getInputStream();
    			bytesRead = input.read(mybytearray, 0, buffersize);
    			if (bytesRead != -1) {
                      fos.write(mybytearray, 0, bytesRead);
    			}

    		} while (bytesRead != -1);

    		fos.close();
    	}catch (Exception e) {
    		e.printStackTrace();
    	}
    	return ( documentSet );
    }

	/**
	  * Return a hash (md5sum) of the file contents stored in memory 
	  * in the "data" variable, or null if "data" is empty.
	  *
	  **/
	public String getMD5Sum () {
		if (data == null)
			  return (null); // We have to find another way for this.

		MessageDigest md=null;
		try {
			md = MessageDigest.getInstance( "MD5" );
			md.update( data );
		} catch (java.security.NoSuchAlgorithmException e)
		{
			  System.err.println("** [Error] MD5sum is not implemented by the JVM.");
		}
		BigInteger  md5sum  = new BigInteger( 1 , md.digest()); 
		return (md5sum.toString(16));
	}


    // Test out the class.
    public static void main(String[] args) 
        throws MalformedURLException, IOException 
    {
	  // set URL of remote data
        RemoteData myinput = new RemoteData(args[0]);
	  // setContent() is the real trigger for the data copy
	  
    }
}
