
package p2pmpi.common;

import java.net.*;
import java.io.*;


public class StreamSaver {
	final int  buffersize = 10*1024*1024;
      /*
       * constructor
       */
       public StreamSaver () { }
	/**
	 * Save to a file the incoming bytes read on a socket.
	 *
	 * @param appDir the directory of the file to write
	 * @param filename the name of the file to create to save the bytes
	 * @param filesize the number of bytes to read
	 * @param sock the socket to read from (must be accept()'d)
	 */
	public long saveNetworkInputStream( File appDir, String filename, long filesize, InputStream is) {

		FileOutputStream fos = null;
		File appFile;

		appFile = new File(appDir, filename );

		byte buffer [] = new byte[ buffersize ];
		int bytesRead = 0;
		long sizeToRead = 0;
		long totalBytesRead = 0;
		boolean endMarker = false;

		System.out.println("[FT] starting to receive  "+filename+": advertized size="+ filesize);
		try {
			fos = new FileOutputStream(appFile);
		}
		catch (Exception e) { e.printStackTrace(); }

		do { 
			sizeToRead = Math.min( filesize, buffersize );
			try {
				bytesRead = is.read( buffer, 0 , (int)sizeToRead );
			}
			catch (Exception e) { 
				e.printStackTrace(); 
				endMarker = true;
			}

			if (bytesRead == -1)
				return( -1 );
			else {
				totalBytesRead += bytesRead;
				filesize -= bytesRead; 
				try {
					fos.write( buffer, 0, bytesRead );
				}
				catch (Exception e) {
					e.printStackTrace();
					endMarker = true;
				}
			}
			if ( 0 == filesize ) {
				endMarker = true; // this chunk can contain all the file
			}
		} while ( !endMarker ); // until end of file.

		try {
			fos.close();
		} catch (Exception e) {}
		System.out.println("[FT] done with "+filename+": total="+ totalBytesRead);

		return( totalBytesRead );
	}
}
