package p2pmpi.common;

import java.net.*;
import java.io.*;
import java.util.*;  // for Random



public class ReservedPort {

      ServerSocket reservedPort=null;
      int          reservedPortNumber=-1;
      String       errorMessage=null;


            /**
             * constructor
             **/
            public ReservedPort( int minPort, int maxPort ) {
                  Random r = new Random();
			int randomStart = r.nextInt(maxPort - minPort) + minPort; //avoid duplicate port
                  String errMsg=null;

			//Searching available port
			for(int i = randomStart; i <= maxPort; i++) {
				try {
					this.reservedPort = new ServerSocket(i);
					this.reservedPortNumber = i;
					break;
				} catch (Exception e) {
					this.reservedPort = null;
				}
			}
			if(reservedPort == null) {
				for(int i = minPort; i <= maxPort; i++) {
					try {
						this.reservedPort = new ServerSocket(i);
						this.reservedPortNumber = i;
						break;
					} catch (Exception e) {
						this.reservedPort = null;
                                    this.errorMessage = e.getMessage();
					}
				}
			}
           }


           /**
            * get ReservedPort
            **/
           public ServerSocket getPort() {
                        return(reservedPort);
           }
           /**
            * get port number associated to SocketServer
            **/
           public int getPortNumber() {
                        return(reservedPort.getLocalPort());
           }

           /**
            * get status (error recorded) 
            **/
           public String getErrorMessage() {
                        return(this.errorMessage);
           }



} // end of class
