package p2pmpi.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

/**
 * NIO implementation. Should be the fastest (from JDK 5).
 **/
public class NioCopier implements FileCopier {
        public void copy(File s, File t) throws IOException {
                FileChannel in = (new FileInputStream(s)).getChannel();
                FileChannel out = (new FileOutputStream(t)).getChannel();
                in.transferTo(0, s.length(), out);
                in.close();
                out.close();
        }
        /**
         * main (just to test) 
         **/
        static void main(String[] argv) throws IOException {

                if (argv.length != 2) {
                        System.out.println("[Error] requires two arguments: source and destination");
                }
                else {
                        // prefer the NIO version for perf instead of : Copier io = new IoCopier();
                        FileCopier nio = new NioCopier();
                        nio.copy(new File( argv[0]), new File(argv[1]));
                }

        }
} 
