package p2pmpi.common;

import java.net.*;
import java.util.*;

/**
 * @author choopan
 *
 * Generates a unique name for the peer. Will be used to create a private directory.
 */
public final class NameGenerator {

	    public static final String getUniqueName( )
	    {
	        String hostname="dummyhost";
	        try {
	            hostname = InetAddress.getLocalHost().getHostName();
	        }catch (Exception e){
	            System.err.println("[NameGenerator] Error: no valid hostname found:"+e.getLocalizedMessage());
	        }
	        String now = getTime();
	        Random r = new Random(); /* FIXME: add seed */
	        return ("_AT_" + hostname + "_" + now + r.nextInt());

	    }

	    private static final String getTime()
	    {
	        Calendar rightNow = Calendar.getInstance();
	        int hr  = rightNow.get(Calendar.HOUR_OF_DAY);
	        int min = rightNow.get(Calendar.MINUTE);
	        int sec = rightNow.get(Calendar.SECOND);
	        return Integer.toString(hr) + "_" + Integer.toString(min)
	            + "_" + Integer.toString(sec);
	    }

}
