package p2pmpi.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

/**
 * Classic implementation. 
 **/
public class IoCopier implements FileCopier {
        final int BUFF_SIZE = 5 * 1024 * 1024; // 5MB
        final byte[] buffer = new byte[BUFF_SIZE];

        public void copy(File s, File t) throws IOException {
                InputStream in = new FileInputStream(s);
                FileOutputStream out = new FileOutputStream(t);

                while (true) {
                        int count = in.read(buffer);
                        if (count == -1)
                                break;
                        out.write(buffer, 0, count);
                }
                out.close();
                in.close();
        }

        /**
         * main (just to test) 
         **/
        static void main(String[] argv) throws IOException {

                if (argv.length != 2) {
                        System.out.println("[Error] requires two arguments: source and destination");
                }
                else {
                        FileCopier io = new IoCopier();
                        io.copy(new File( argv[0]), new File(argv[1]));
                }
        } 


}

