/*
 * $Id
 * HostEntry : part of P2P-MPI (http://www.p2pmpi.org).

 * HostEntry is the data structure to store a host state in local cache. 
 *
 * Copyright (C) 2007, Stephane Genaud, Choopan Rattanapoka 
 *
 * This tool is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package p2pmpi.common;

import java.io.*;
import java.util.*;

public class HostEntry implements Serializable {
	private static final long serialVersionUID = 1000002L;
	String ip;
	int fdPort;
	int ftPort;
	int mpdPort;
	int rsPort;
	int numProcPerJob;
	boolean alive;
	int rtt;
	long lastUpdate;
	// for 'data-*' allocation strategies introduced p2pmpi-0.29.0,
	private Vector<String> cacheMd5sums=new Vector<String>();

      /**
       * constructor
       **/
	public HostEntry(String ip, int mpdPort, int fdPort, int ftPort, int rsPort, 
                       int numProcPerJob) {
		this.ip = ip;
		this.mpdPort = mpdPort;
		this.fdPort = fdPort;
		this.ftPort = ftPort;
		this.rsPort = rsPort;
		alive = true;
		rtt   = Integer.MAX_VALUE;
		this.numProcPerJob = numProcPerJob;
		lastUpdate = System.currentTimeMillis();
		this.cacheMd5sums=new Vector<String>();
	}

	public void setLastUpdate() {
		lastUpdate = System.currentTimeMillis();
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public void setFdPort(int fdPort) {
		this.fdPort = fdPort;
	}

	public void setFtPort(int ftPort) {
		this.ftPort = ftPort;
	}

	public void setMpdPort(int mpdPort) {
		this.mpdPort = mpdPort;
	}

	public void setAlive(boolean alive) {
		this.alive = alive;
	}

	public void setRtt(int rtt) {
		if(rtt < this.rtt)
			this.rtt = rtt;
	}

	public void setNumProcPerJob(int numProcPerJob) {
		this.numProcPerJob = numProcPerJob;
	}

	public String getIp() {
		return ip;
	}

	public int getFdPort() {
		return fdPort;
	}
	public int getFtPort() {
		return ftPort;
	}

	public int getMpdPort() {
		return mpdPort;
	}
	public boolean isAlive() {
		return alive;
	}

	public int getRtt() {
		return rtt;
	}

	public int getNumProcPerJob() {
		return numProcPerJob;
	}

	public long getLastUpdate() {
		return (System.currentTimeMillis() - lastUpdate);
	}

	public boolean isUpdate() {
		return ((System.currentTimeMillis() - lastUpdate) < 240000);
	}

	public int getRsPort() {
		return rsPort;
	}

	public String toString() {
		return ip + ":" + mpdPort + ":" + fdPort + ":" + ftPort + ":" + rsPort + ":" + numProcPerJob;
	}

      /**
       * force update of the md5sums of the files i own in my cache
       * so that others can look it up.
       * @author jagdish, genaud
       **/
	public void updateCacheMd5sums( Vector<String> md5s ) {
                    this.cacheMd5sums =md5s;
	}
	
	public Vector<String> getCacheMd5sums() {
		return (this.cacheMd5sums);
	}
}
