/**
 * FileCharacteristics : a simple class to capture the characteristics of the files to be 
 * transfered between two FTs. Typically embedded in a FTMessage.
 
 * @author: jagdish
 * @author: genaud
 */

package p2pmpi.common;

import java.io.Serializable;
import java.io.File;

public class FileCharacteristics implements Serializable {
	private static final long serialVersionUID = 1L;
	
	String fileName;
	String onlyFileName;
	String md5sum;
	long fileSize;
	boolean cached;
	
	public FileCharacteristics (String fileName, String md5sum, long fileSize, boolean cached){
		this.fileName = fileName;
		if(!this.fileName.startsWith("http://")) {
			File tmpFile = new File(this.fileName);
			this.onlyFileName = tmpFile.getName();
		}
		else {
			this.onlyFileName = this.fileName;
		}
		this.md5sum = md5sum;
		this.fileSize = fileSize;
		this.cached = cached;
		
	}
	
	public String getFileName() {
		return (this.fileName);
	}
	
	public String getOnlyFileName() {
		return (this.onlyFileName);
	}

      /**
       * return true if user requires the file to be cached 
       **/
	public boolean isToBeCached() {
		return (this.cached);
	}
	/**
	 * returns the size of the files in bytes
	 **/
	public long getFileSize() {
		return (this.fileSize);
	}
	/**
	 * return the md5sum computed by class Md5sum of this file.
	 **/
	public String getMd5sum() {
		return (this.md5sum);
	}
}
