# Windows Installer for P2P-MPI library.

Name p2pmpi

# General Symbol Definitions
!define REGKEY "SOFTWARE\$(^Name)"
!define VERSION 0.29.0
!define COMPANY "ICPS-LSIIT, University of Strasbourg and INRIA AlGorille Team"
!define URL http://grid.u-strasbg.fr/p2pmpi/
!define PRODUCT_NAME "P2P-MPI"

# For JRE checking and downloading
!define JRE_VERSION "1.5"
!define JRE_VERSION1 "1.6"
#!define JRE_URL "http://javadl.sun.com/webapps/download/AutoDL?BundleId=18675&/jre-1_5_0_21-windows-i586-p.exe"
!define JRE_URL "http://cds.sun.com/is-bin/INTERSHOP.enfinity/WFS/CDS-CDS_Developer-Site/en_US/-/USD/VerifyItem-Start/jre-1_5_0_21-windows-i586-p.exe?BundledLineItemUUID=VelIBe.lVXcAAAEjB1sQluwA&OrderID=ljNIBe.lrxcAAAEj.VoQluwA&ProductID=Li9IBe.nJeIAAAEjlhIcDnOi&FileName=/jre-1_5_0_21-windows-i586-p.exe"

# MUI Symbol Definitions
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-colorful.ico"
!define MUI_FINISHPAGE_NOAUTOCLOSE
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-colorful.ico"
!define MUI_UNFINISHPAGE_NOAUTOCLOSE
!define MUI_LANGDLL_REGISTRY_ROOT HKLM
!define MUI_LANGDLL_REGISTRY_KEY ${REGKEY}
!define MUI_LANGDLL_REGISTRY_VALUENAME InstallerLanguage

# Included files
!include Sections.nsh
!include MUI2.nsh
!include EnvVarUpdate.nsh
!include InstallOptions.nsh

# Reserved Files
!insertmacro MUI_RESERVEFILE_LANGDLL

# Using ReserveFile for my own InstallOptions INI files(SupernodeConfigPage.ini)!
ReserveFile "${NSISDIR}\Plugins\InstallOptions.dll"
ReserveFile "SupernodeConfigPage.ini"

# Installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE p2pmpi/p2pmpi-0.29.0/LICENSE
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
Page Custom MyCustomPage MyCustomLeave ": P2P-MPI.conf setting" ;Custom page for supernode setting.
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

# Installer languages
!insertmacro MUI_LANGUAGE English
!insertmacro MUI_LANGUAGE Afrikaans
!insertmacro MUI_LANGUAGE Albanian
!insertmacro MUI_LANGUAGE Arabic
!insertmacro MUI_LANGUAGE Basque
!insertmacro MUI_LANGUAGE Belarusian
!insertmacro MUI_LANGUAGE Bosnian
!insertmacro MUI_LANGUAGE Breton
!insertmacro MUI_LANGUAGE Bulgarian
!insertmacro MUI_LANGUAGE Catalan
!insertmacro MUI_LANGUAGE Croatian
!insertmacro MUI_LANGUAGE Czech
!insertmacro MUI_LANGUAGE Danish
!insertmacro MUI_LANGUAGE Dutch
!insertmacro MUI_LANGUAGE Esperanto
!insertmacro MUI_LANGUAGE Estonian
!insertmacro MUI_LANGUAGE Farsi
!insertmacro MUI_LANGUAGE Finnish
!insertmacro MUI_LANGUAGE French
!insertmacro MUI_LANGUAGE Galician
!insertmacro MUI_LANGUAGE German
!insertmacro MUI_LANGUAGE Greek
!insertmacro MUI_LANGUAGE Hebrew
!insertmacro MUI_LANGUAGE Hungarian
!insertmacro MUI_LANGUAGE Icelandic
!insertmacro MUI_LANGUAGE Indonesian
!insertmacro MUI_LANGUAGE Irish
!insertmacro MUI_LANGUAGE Italian
!insertmacro MUI_LANGUAGE Japanese
!insertmacro MUI_LANGUAGE Korean
!insertmacro MUI_LANGUAGE Kurdish
!insertmacro MUI_LANGUAGE Latvian
!insertmacro MUI_LANGUAGE Lithuanian
!insertmacro MUI_LANGUAGE Luxembourgish
!insertmacro MUI_LANGUAGE Macedonian
!insertmacro MUI_LANGUAGE Malay
!insertmacro MUI_LANGUAGE Mongolian
!insertmacro MUI_LANGUAGE Norwegian
!insertmacro MUI_LANGUAGE NorwegianNynorsk
!insertmacro MUI_LANGUAGE Polish
!insertmacro MUI_LANGUAGE Portuguese
!insertmacro MUI_LANGUAGE PortugueseBR
!insertmacro MUI_LANGUAGE Romanian
!insertmacro MUI_LANGUAGE Russian
!insertmacro MUI_LANGUAGE Serbian
!insertmacro MUI_LANGUAGE SerbianLatin
!insertmacro MUI_LANGUAGE SimpChinese
!insertmacro MUI_LANGUAGE Slovak
!insertmacro MUI_LANGUAGE Slovenian
!insertmacro MUI_LANGUAGE Spanish
!insertmacro MUI_LANGUAGE SpanishInternational
!insertmacro MUI_LANGUAGE Swedish
!insertmacro MUI_LANGUAGE Thai
!insertmacro MUI_LANGUAGE TradChinese
!insertmacro MUI_LANGUAGE Turkish
!insertmacro MUI_LANGUAGE Ukrainian
!insertmacro MUI_LANGUAGE Uzbek
!insertmacro MUI_LANGUAGE Welsh

# Installer attributes
OutFile p2pmpi-installer.exe
InstallDir $PROGRAMFILES\p2pmpi-${VERSION}
CRCCheck on
XPStyle on
ShowInstDetails show
VIProductVersion 0.29.0.0
VIAddVersionKey /LANG=${LANG_ENGLISH} ProductName p2pmpi
VIAddVersionKey /LANG=${LANG_ENGLISH} ProductVersion "${VERSION}"
VIAddVersionKey /LANG=${LANG_ENGLISH} CompanyName "${COMPANY}"
VIAddVersionKey /LANG=${LANG_ENGLISH} CompanyWebsite "${URL}"
VIAddVersionKey /LANG=${LANG_ENGLISH} FileVersion "${VERSION}"
VIAddVersionKey /LANG=${LANG_ENGLISH} FileDescription ""
VIAddVersionKey /LANG=${LANG_ENGLISH} LegalCopyright ""
InstallDirRegKey HKLM "${REGKEY}" Path
ShowUninstDetails show

# Installer sections
Section -Main SEC0000
    # Checking JRE on system and if not present, downloading it if user agrees
    Call DetectJRE
    
    # Setting Enviornment variables 
    ; include for some of the windows messages defines
    !include "winmessages.nsh"
    # Here, we using HKLM (all users) define, other option is hkcu for current user only
    !define env_hklm 'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'
    ; setting variable P2PMPI_HOME
    WriteRegExpandStr ${env_hklm} P2PMPI_HOME $INSTDIR
    ; make sure windows knows about the change
    #SendMessage ${HWND_BROADCAST} ${WM_SETTINGCHANGE} NULL "Environment" /TIMEOUT=5000
    SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
    
    ; Adding bin directory of library to 'PATH' envioronment variable
    ${EnvVarUpdate} $0 "PATH" "A" "HKLM" "%P2PMPI_HOME%\bin"
    # Setting CLASSPATH is optional (I am not sure at present, which one i should use)
    # WriteRegExpandStr ${env_hklm} CLASSPATH %CLASSPATH%;%P2PMPI_HOME%\p2pmpi.jar
    # ${EnvVarUpdate} $0 "CLASSPATH" "A" "HKLM" "%CLASSPATH%;%P2PMPI_HOME%\p2pmpi.jar"
    #SendMessage ${HWND_BROADCAST} ${WM_SETTINGCHANGE} NULL "Environment" /TIMEOUT=5000
    SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
    
    # Setting enviornment variable ends here
    
    SetOutPath $INSTDIR
    SetOverwrite on
    File /r p2pmpi\p2pmpi-0.29.0\*
    WriteRegStr HKLM "${REGKEY}\Components" Main 1
SectionEnd

Section -post SEC0001
    WriteRegStr HKLM "${REGKEY}" Path $INSTDIR
    SetOutPath $INSTDIR
    WriteUninstaller $INSTDIR\uninstall.exe
    WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" DisplayName "$(^Name)"
    WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" DisplayVersion "${VERSION}"
    WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" Publisher "${COMPANY}"
    WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" URLInfoAbout "${URL}"
    WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" DisplayIcon $INSTDIR\uninstall.exe
    WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" UninstallString $INSTDIR\uninstall.exe
    WriteRegDWORD HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" NoModify 1
    WriteRegDWORD HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)" NoRepair 1
SectionEnd

# Macro for selecting uninstaller sections
!macro SELECT_UNSECTION SECTION_NAME UNSECTION_ID
    Push $R0
    ReadRegStr $R0 HKLM "${REGKEY}\Components" "${SECTION_NAME}"
    StrCmp $R0 1 0 next${UNSECTION_ID}
    !insertmacro SelectSection "${UNSECTION_ID}"
    GoTo done${UNSECTION_ID}
next${UNSECTION_ID}:
    !insertmacro UnselectSection "${UNSECTION_ID}"
done${UNSECTION_ID}:
    Pop $R0
!macroend

# Uninstaller sections
Section /o -un.Main UNSEC0000
    # Removing enviornment variable
    ; delete variable
   DeleteRegValue ${env_hklm} P2PMPI_HOME
   
   ; make sure windows knows about the change
   SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
    
    # If classpath is added in the installer section, here, we have to remove that
    # (should use one of the below in accordance with installer section)
    # DeleteRegValue ${env_hklm} CLASSPATH
    # ${un.EnvVarUpdate} $0 "CLASSPATH" "R" "HKLM" "%CLASSPATH%;%P2PMPI_HOME%\p2pmpi.jar"
    
    # Removing bin directory of library from 'PATH' environment variable
    ${un.EnvVarUpdate} $0 "PATH" "R" "HKLM" "%P2PMPI_HOME%\bin"
    
    RmDir /r /REBOOTOK $INSTDIR
    DeleteRegValue HKLM "${REGKEY}\Components" Main
SectionEnd

Section -un.post UNSEC0001
    DeleteRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\$(^Name)"
    Delete /REBOOTOK $INSTDIR\uninstall.exe
    DeleteRegValue HKLM "${REGKEY}" Path
    DeleteRegKey /IfEmpty HKLM "${REGKEY}\Components"
    DeleteRegKey /IfEmpty HKLM "${REGKEY}"
    RmDir /REBOOTOK $INSTDIR
SectionEnd

# Installer functions
Function .onInit
    InitPluginsDir
    !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

# Uninstaller functions
Function un.onInit
    ReadRegStr $INSTDIR HKLM "${REGKEY}" Path
    !insertmacro MUI_UNGETLANGUAGE
    !insertmacro SELECT_UNSECTION Main ${UNSEC0000}
FunctionEnd

# Functions to detect and get JRE
Function GetJRE
        MessageBox MB_YESNO "${PRODUCT_NAME} uses Java ${JRE_VERSION}, it will now \
                         be downloaded and installed. Do you really want to continue?" IDYES gogogo
                         Abort
                         gogogo:
 
        StrCpy $2 "$TEMP\Java Runtime Environment.exe"
        nsisdl::download /TIMEOUT=30000 ${JRE_URL} $2
        Pop $R0 ;Get the return value
                StrCmp $R0 "success" +3
                MessageBox MB_OK "Download failed: $R0"
                Quit
        ExecWait $2
        Delete $2
FunctionEnd
 
 
Function DetectJRE
  ReadRegStr $2 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" \
             "CurrentVersion"
  StrCmp $2 ${JRE_VERSION} done
  StrCmp $2 ${JRE_VERSION1} done
  Call GetJRE
 
  done:
FunctionEnd

# Functions for custom page SupernodeConfigPage.ini
Function MyCustomPage
  # There is no need to ReserveFile SupernodeConfigPage.ini here again.
  # It is already reserved.
  # ReserveFile "SupernodeConfigPage.ini"
  !insertmacro INSTALLOPTIONS_EXTRACT "SupernodeConfigPage.ini"
  !insertmacro INSTALLOPTIONS_DISPLAY "SupernodeConfigPage.ini"
FunctionEnd
 
Function MyCustomLeave
  # Getting the supernode entry entered by the user
  !insertmacro INSTALLOPTIONS_READ $R1 "SupernodeConfigPage.ini" "Field 2" "State"
  
  ClearErrors
  FileOpen $0 "$INSTDIR\P2P-MPI.conf" "r"        ; opening P2P-MPI.conf file for reading
  GetTempFileName $R0                            ; getting new temp file name
  FileOpen $1 $R0 "w"                            ; opening temp file for writing

  loop:
   FileRead $0 $2                              ; reading line from P2P-MPI.conf file
   IfErrors done                               ; checking if end of file reached
   StrCmp $2 "SUPERNODE=tcp://pellinore.u-strasbg.fr:9700$\r$\n" 0 +2      ; compare line with search string with CR/LF
      StrCpy $2 "SUPERNODE=tcp://$R1$\r$\n"    ; change line
   StrCmp $2 "SUPERNODE=tcp://pellinore.u-strasbg.fr:9700" 0 +2            ; compare line with search string without CR/LF (at the end of the file)
      StrCpy $2 "SUPERNODE=tcp://$R1"          ; change line; Here, no need of this and previous line but just a check, in case in future,
      # it becomes the last line.
   FileWrite $1 $2                             ; write changed or unchanged line to temp file
   Goto loop
 
done:
   FileClose $0                                ; close target file
   FileClose $1                                ; close temp file
   Delete "$INSTDIR\P2P-MPI.conf"                           ; delete P2P-MPI.conf file
   CopyFiles /SILENT $R0 "P2P-MPI.conf"            ; copy temp file to P2P-MPI.conf file
   Delete $R0                                  ; delete temp file
  
FunctionEnd