/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.p2p;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.GenericConfigFile;
import p2pmpi.common.HostEntry;
import p2pmpi.p2p.message.PeerReplyMessage;
import p2pmpi.p2p.message.PeerRequestMessage;
import p2pmpi.p2p.message.QuitMessage;
import p2pmpi.p2p.message.RegisterMessage;
import p2pmpi.p2p.message.UnregisterMessage;
import p2pmpi.p2p.message.UpdateMessage;

public class SuperNode
extends Thread {
    private static Logger log;
    int port;
    HashMap<String, HostEntry> hostCache;

    public SuperNode(int n) {
        log = Logger.getLogger((String)"SUPERNODE");
        this.port = n;
        this.hostCache = new HashMap();
    }

    public void run() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (Exception exception) {
            System.err.println("port:" + this.port + " is not available");
            System.exit(1);
        }
        try {
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            while (true) {
                Vector<String> vector;
                Object object;
                HostEntry hostEntry;
                Socket socket;
                InputStream inputStream;
                ObjectInputStream objectInputStream;
                Object object2;
                if ((object2 = (objectInputStream = new ObjectInputStream(inputStream = (socket = serverSocket.accept()).getInputStream())).readObject()) instanceof RegisterMessage) {
                    hostEntry = ((RegisterMessage)object2).getHostEntry();
                    log.debug((Object)("[SuperNode] register from " + hostEntry.toString()));
                    this.hostCache.put(hostEntry.toString(), hostEntry);
                } else if (object2 instanceof UpdateMessage) {
                    hostEntry = ((UpdateMessage)object2).getHostEntry();
                    log.debug((Object)("[SuperNode] update from " + hostEntry.getIp()));
                    object = this.hostCache.get(hostEntry.toString());
                    if (object == null) {
                        log.debug((Object)("[SuperNode] converting update from " + hostEntry.getIp() + " to register."));
                        this.hostCache.put(hostEntry.toString(), hostEntry);
                    } else {
                        vector = hostEntry.getCacheMd5sums();
                        if (vector.size() > 0) {
                            ((HostEntry)object).updateCacheMd5sums(vector);
                        }
                        ((HostEntry)object).setLastUpdate();
                    }
                } else if (object2 instanceof PeerRequestMessage) {
                    object = this.hostCache.keySet();
                    vector = object.iterator();
                    PeerReplyMessage peerReplyMessage = new PeerReplyMessage();
                    while (vector.hasNext()) {
                        hostEntry = this.hostCache.get(vector.next());
                        if (!hostEntry.isUpdate()) continue;
                        peerReplyMessage.add(hostEntry);
                    }
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(peerReplyMessage);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                } else if (object2 instanceof UnregisterMessage) {
                    hostEntry = ((UnregisterMessage)object2).getHostEntry();
                    log.debug((Object)("[SuperNode] unregister from " + hostEntry.getIp()));
                    this.hostCache.remove(hostEntry.toString());
                } else if (object2 instanceof QuitMessage) {
                    System.exit(0);
                }
                objectInputStream.close();
                inputStream.close();
                socket.close();
            }
        }
        catch (Exception exception) {
            System.err.println("[Error] : " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-RDV.conf");
        GenericConfigFile genericConfigFile = new GenericConfigFile(file.toString());
        int n = Integer.parseInt(genericConfigFile.getProperty("InternalPort"));
        SuperNode superNode = new SuperNode(n);
        superNode.start();
    }
}

