/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.p2p;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.DiskCache;
import p2pmpi.common.HostEntry;
import p2pmpi.p2p.message.UpdateMessage;

public class PeerKeepAlive
extends TimerTask {
    URI superNode;
    HostEntry myHost;
    private DiskCache diskCache;
    Logger log = null;

    public PeerKeepAlive(URI uRI, HostEntry hostEntry, DiskCache diskCache) {
        this.superNode = uRI;
        this.myHost = hostEntry;
        this.diskCache = diskCache;
        this.log = Logger.getLogger((String)"MPD");
    }

    private void sendUpdate(UpdateMessage updateMessage) {
        try {
            Socket socket = new Socket(this.superNode.getHost(), this.superNode.getPort());
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(updateMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("[PeerKeepAlive] could not send an update to supernode " + this.superNode.getHost() + ":" + this.superNode.getPort()));
        }
    }

    public void sendCacheUpdate() {
        Vector<String> vector = this.diskCache.getMd5s();
        this.log.info((Object)("[PeerKeepAlive] MPD requested to recompute md5sums of cache. Found " + vector.size() + " files."));
        this.myHost.updateCacheMd5sums(vector);
        UpdateMessage updateMessage = new UpdateMessage(this.myHost);
        this.sendUpdate(updateMessage);
    }

    public void sendAliveUpdate() {
        UpdateMessage updateMessage = new UpdateMessage(this.myHost);
        this.sendUpdate(updateMessage);
    }

    public void run() {
        this.sendAliveUpdate();
    }
}

