/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import p2pmpi.common.RankTable;
import p2pmpi.message.DatMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.MessageHandler;
import p2pmpi.mpi.dev.MessageIDLog;
import p2pmpi.mpi.dev.NIORequest;
import p2pmpi.mpi.dev.P2PMPI_Buffer;
import p2pmpi.mpi.dev.RDVHeaderInformation;
import p2pmpi.mpi.dev.RecvBufferInformation;
import p2pmpi.mpi.dev.SendBufferInformation;
import p2pmpi.mpi.dev.SmallRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIODevice
extends Device
implements Runnable {
    int numReadTotal = 0;
    SocketChannel[][] outputChannels;
    SocketChannel[][] inputChannels;
    Selector selector;
    Selector selectorTmp;
    static final int INIT_BUFSIZE = 0x200000;
    ByteBuffer recvBuffer;
    ByteBuffer sendBuffer = ByteBuffer.allocateDirect(0x200000);
    ByteBuffer finalizeBuffer;
    ByteBuffer commitBuffer;
    ByteBuffer readyToSendBuffer;
    ByteBuffer readyToRecvBuffer;
    int totalConnect;
    volatile boolean doneSend;
    byte[] bMID;
    protected Map semaphoreSet;
    protected Map<String, LargeMessageSender> largeMessagePending;
    protected Map<String, RDVHeaderInformation> waitForRecvReady;

    @Override
    public boolean isDone() {
        return this.totalConnect == (this.rankTable.size() - 1) * 2;
    }

    public NIODevice() {
        this.recvBuffer = ByteBuffer.allocateDirect(0x200000);
        this.bMID = new byte[64];
        this.semaphoreSet = new HashMap();
        this.largeMessagePending = new HashMap<String, LargeMessageSender>();
        this.waitForRecvReady = new HashMap<String, RDVHeaderInformation>();
        this.finalizeBuffer = ByteBuffer.allocateDirect(6);
        this.commitBuffer = ByteBuffer.allocateDirect(20);
        this.readyToSendBuffer = ByteBuffer.allocateDirect(32);
        this.readyToRecvBuffer = ByteBuffer.allocateDirect(24);
        this.tpes = Executors.newCachedThreadPool();
    }

    @Override
    public boolean init() {
        try {
            this.selector = Selector.open();
            this.selectorTmp = Selector.open();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public int initPort(int minPort, int maxPort, String bindIP) {
        Random r = new Random();
        int randomStart = r.nextInt(maxPort - minPort) + minPort;
        int count = 2;
        while (count-- > 0) {
            for (int i = randomStart; i <= maxPort; ++i) {
                try {
                    ServerSocketChannel serv = ServerSocketChannel.open();
                    serv.configureBlocking(false);
                    InetSocketAddress isa = new InetSocketAddress(bindIP, i);
                    serv.socket().bind(isa);
                    serv.register(this.selector, 16);
                    return i;
                }
                catch (Exception e) {
                    continue;
                }
            }
            randomStart = minPort;
        }
        return -1;
    }

    public void sendReadyToRecv(short commID, int src, int dst, int tag, int numsend, int senderRIL, int senderRank, int senderRIR) {
        DatMessage readyToRecv = new DatMessage(this.readyToRecvBuffer, 7);
        readyToRecv.pack(commID);
        readyToRecv.pack(src);
        readyToRecv.pack(dst);
        readyToRecv.pack(tag);
        readyToRecv.pack(numsend);
        readyToRecv.pack(this.myRankInList);
        readyToRecv.done();
        if (this.commWorld.isAlive(senderRIL)) {
            SocketChannel socket = this.outputChannels[senderRIR][senderRank];
            Semaphore sem = (Semaphore)this.semaphoreSet.get(socket);
            try {
                sem.acquire();
                this.toleranceWrite(this.readyToRecvBuffer, socket, senderRIL);
                sem.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int readUntilSize(SocketChannel socket) {
        int totalRead = 0;
        try {
            int numRead;
            do {
                numRead = socket.read(this.recvBuffer);
                totalRead += numRead;
            } while (numRead > 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return totalRead;
        }
        return totalRead;
    }

    public void readWithTmpSelector(SocketChannel socket, int haveSize, int wantSize) {
        int totalRead = haveSize;
        try {
            int currentPosition = this.recvBuffer.position();
            int currentLimit = this.recvBuffer.limit();
            this.recvBuffer.limit(this.recvBuffer.capacity());
            this.recvBuffer.position(currentLimit);
            SelectionKey kregister = socket.register(this.selectorTmp, 1);
            while (this.selectorTmp.select(20000L) > 0) {
                Set<SelectionKey> readyKeys = this.selectorTmp.selectedKeys();
                Iterator<SelectionKey> it = readyKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    if (!key.isReadable() || (totalRead += this.readUntilSize(socket)) < wantSize) continue;
                    this.recvBuffer.limit(this.recvBuffer.position());
                    this.recvBuffer.position(currentPosition);
                    kregister.cancel();
                    this.selectorTmp.selectNow();
                    return;
                }
            }
            this.recvBuffer.limit(this.recvBuffer.position());
            this.recvBuffer.position(currentPosition);
            kregister.cancel();
            this.selectorTmp.selectNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean init(ServerSocket cmdSocket, String myHash, int mpdPort, int fdPort) {
        this.myHash = myHash;
        this.fdPort = fdPort;
        this.mpdPort = mpdPort;
        this.msgHandle = new MessageHandler(this, cmdSocket, myHash, mpdPort, fdPort);
        Thread msgHandleThread = new Thread(this.msgHandle);
        msgHandleThread.setDaemon(true);
        msgHandleThread.start();
        try {
            this.selector = Selector.open();
            this.selectorTmp = Selector.open();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void spawnMessageHandler(ServerSocket cmdSocket, int numPeers, RankTable rankTable, String hash, int mpdPort, int fdPort, int tGossip, int tMargin, int tHang, String protocol) {
        this.myHash = hash;
        this.fdPort = fdPort;
        this.mpdPort = mpdPort;
        this.msgHandle = new MessageHandler(this, cmdSocket, numPeers, rankTable, hash, mpdPort, fdPort);
        this.msgHandle.setTGossip(tGossip);
        this.msgHandle.setTMargin(tMargin);
        this.msgHandle.setTHang(tHang);
        this.msgHandle.setGossipProtocol(protocol);
        Thread msgHandleThread = new Thread(this.msgHandle);
        msgHandleThread.setDaemon(true);
        msgHandleThread.start();
    }

    @Override
    public void connect(int rank, int rankInRep, int rankInList, RankTable rankTable, int numProc, int numRep) {
        this.myRank = rank;
        this.myRankInRep = rankInRep;
        this.myRankInList = rankInList;
        this.rankTable = rankTable;
        this.numReplica = numRep;
        this.numProc = numProc;
        for (int i = 2; i <= numProc; i *= 2) {
            if (i != numProc) continue;
            this.N_POWER2 = true;
        }
        this.inputChannels = new SocketChannel[numRep][numProc];
        this.outputChannels = new SocketChannel[numRep][numProc];
    }

    @Override
    public boolean connectToNode(URI uri, int itsRank, int itsRankInRep, SocketChannel[][] socketChannels, byte isInput) {
        this.sendBuffer.clear();
        InetSocketAddress isa = null;
        try {
            isa = new InetSocketAddress(InetAddress.getByName(uri.getHost()), uri.getPort());
        }
        catch (Exception e) {
            return false;
        }
        try {
            SocketChannel sock = SocketChannel.open();
            sock.configureBlocking(false);
            sock.socket().setSendBufferSize(524288);
            sock.socket().setReceiveBufferSize(524288);
            sock.socket().setTcpNoDelay(true);
            boolean connected = sock.connect(isa);
            SelectionKey key = sock.register(this.selector, 8);
            key.attach(new Byte(isInput));
            socketChannels[itsRankInRep][itsRank] = sock;
        }
        catch (ConnectException ce) {
            System.out.println("[Error] : connect to address : " + ce.getMessage());
            return false;
        }
        catch (Exception e) {
            System.out.println("[Error] : connect to address : " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        int totalNode = this.rankTable.size();
        int numNodetoWait = totalNode - this.myRankInList - 1;
        int numNodetoConnect = totalNode - numNodetoWait - 1;
        try {
            for (int i = 0; i < numNodetoConnect; ++i) {
                int itsRankInRep;
                int itsRank;
                URI toConnect = this.rankTable.getDataURI(i);
                if (!this.connectToNode(toConnect, itsRank = this.rankTable.getRank(i), itsRankInRep = this.rankTable.getRankInReplica(toConnect, i), this.outputChannels, (byte)0)) {
                    System.out.println("[Error] : Failed to create MPI communicator");
                    System.exit(1);
                }
                if (this.connectToNode(toConnect = this.rankTable.getCtrlURI(i), itsRank, itsRankInRep, this.inputChannels, (byte)1)) continue;
                System.out.println("[Error] : Failed to create MPI communicator");
                System.exit(1);
            }
            block3: while (true) {
                this.selector.select();
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (true) {
                    if (!it.hasNext()) continue block3;
                    SelectionKey selKey = it.next();
                    it.remove();
                    this.processSelectionKey(selKey);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encodeMessage(SocketChannel sc, SelectionKey selKey) {
        try {
            block50: do {
                if (this.recvBuffer.remaining() < 2) {
                    return false;
                }
                byte magicnumber = this.recvBuffer.get();
                if (magicnumber != 13) {
                    try {
                        selKey.cancel();
                        sc.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return false;
                }
                byte messageType = this.recvBuffer.get();
                switch (messageType) {
                    case 1: {
                        if (this.recvBuffer.remaining() < 9) {
                            this.recvBuffer.position(this.recvBuffer.position() - 2);
                            return false;
                        }
                        int fromRank = this.recvBuffer.getInt();
                        int fromRankInRep = this.recvBuffer.getInt();
                        byte isInput = this.recvBuffer.get();
                        if (isInput != 0) {
                            this.outputChannels[fromRankInRep][fromRank] = sc;
                            selKey.cancel();
                            sc.configureBlocking(true);
                            this.semaphoreSet.put(sc, new Semaphore(1, true));
                        } else {
                            this.inputChannels[fromRankInRep][fromRank] = sc;
                        }
                        ++this.totalConnect;
                        break;
                    }
                    case 3: {
                        boolean logExist;
                        if (this.recvBuffer.remaining() < 18) {
                            this.recvBuffer.position(this.recvBuffer.position() - 2);
                            return false;
                        }
                        short commID = this.recvBuffer.getShort();
                        int src = this.recvBuffer.getInt();
                        int dst = this.recvBuffer.getInt();
                        int tag = this.recvBuffer.getInt();
                        int numsend = this.recvBuffer.getInt();
                        String mid = this.getMessageID(commID, src, dst, tag, numsend);
                        while (this.sendLog == null) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {}
                        }
                        Object object = this.sendLog;
                        synchronized (object) {
                            logExist = this.sendLog.isExist(mid);
                        }
                        if (logExist) {
                            object = this.sendLog;
                            synchronized (object) {
                                this.sendLog.remove(mid);
                            }
                            object = this.backupBuffer;
                            synchronized (object) {
                                int backupBufferSize = this.backupBuffer.size();
                                for (int i = 0; i < backupBufferSize; ++i) {
                                    if (!mid.equals(((SendBufferInformation)this.backupBuffer.elementAt(i)).toString())) continue;
                                    this.backupBuffer.removeElementAt(i);
                                    break;
                                }
                                break;
                            }
                        }
                        object = this.sendLog;
                        synchronized (object) {
                            this.sendLog.add(mid);
                            break;
                        }
                    }
                    case 4: {
                        if (this.recvBuffer.remaining() < 4) {
                            this.recvBuffer.position(this.recvBuffer.position() - 2);
                            return false;
                        }
                        int doneNodeRank = this.recvBuffer.getInt();
                        RankTable backupBufferSize = this.rankTable;
                        synchronized (backupBufferSize) {
                            this.rankTable.setTerminated(doneNodeRank, true);
                            break;
                        }
                    }
                    case 5: {
                        this.terminated = true;
                        break;
                    }
                    case 7: {
                        if (this.recvBuffer.remaining() < 22) {
                            this.recvBuffer.position(this.recvBuffer.position() - 2);
                            return false;
                        }
                        short commID = this.recvBuffer.getShort();
                        int src = this.recvBuffer.getInt();
                        int dst = this.recvBuffer.getInt();
                        int tag = this.recvBuffer.getInt();
                        int numsend = this.recvBuffer.getInt();
                        int senderRIL = this.recvBuffer.getInt();
                        LargeMessageSender largeMessageSender = this.largeMessagePending.get(this.getHashKey(commID, src, dst, tag, numsend));
                        if (this.numReplica == 1) {
                            this.tpes.execute(largeMessageSender);
                            this.largeMessagePending.remove(this.getHashKey(commID, src, dst, tag, numsend));
                            break;
                        }
                        largeMessageSender.setReady(senderRIL);
                        if (!largeMessageSender.isReady()) continue block50;
                        this.tpes.execute(largeMessageSender);
                        this.largeMessagePending.remove(this.getHashKey(commID, src, dst, tag, numsend));
                        break;
                    }
                    case 6: {
                        Object object;
                        Vector vector;
                        if (this.recvBuffer.remaining() < 30) {
                            this.recvBuffer.position(this.recvBuffer.position() - 2);
                            return false;
                        }
                        short commID = this.recvBuffer.getShort();
                        int src = this.recvBuffer.getInt();
                        int dst = this.recvBuffer.getInt();
                        int tag = this.recvBuffer.getInt();
                        int numsend = this.recvBuffer.getInt();
                        int senderRIL = this.recvBuffer.getInt();
                        int senderRank = this.recvBuffer.getInt();
                        int senderRIR = this.recvBuffer.getInt();
                        IStatus status = new IStatus();
                        Vector vector2 = this.unexpectedQueue;
                        synchronized (vector2) {
                            vector = this.expectedQueue;
                            synchronized (vector) {
                                object = this.waitForRecvReady;
                                synchronized (object) {
                                    if (this.isRequestInExpectedQueue(commID, src, dst, tag, numsend)) {
                                        this.sendReadyToRecv(commID, src, dst, tag, numsend, senderRIL, senderRank, senderRIR);
                                    } else {
                                        RDVHeaderInformation rdvInfo = new RDVHeaderInformation(commID, src, dst, tag, numsend, senderRIL, senderRank, senderRIR);
                                        this.waitForRecvReady.put(rdvInfo.toString(), rdvInfo);
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        Object object;
                        String mid;
                        if (this.recvBuffer.remaining() < 22) {
                            this.recvBuffer.position(this.recvBuffer.position() - 2);
                            return false;
                        }
                        short commID = this.recvBuffer.getShort();
                        int src = this.recvBuffer.getInt();
                        int dst = this.recvBuffer.getInt();
                        int tag = this.recvBuffer.getInt();
                        int numsend = this.recvBuffer.getInt();
                        int size = this.recvBuffer.getInt();
                        if (this.recvBuffer.remaining() < size) {
                            this.recvBuffer.position(this.recvBuffer.position() - 24);
                            return false;
                        }
                        IStatus status = new IStatus();
                        Vector vector = this.unexpectedQueue;
                        synchronized (vector) {
                            object = this.expectedQueue;
                            synchronized (object) {
                                NIORequest recvReq = this.getRequestFromExpectedQueue(commID, src, dst, tag, numsend, status);
                                mid = this.getMessageID(commID, src, dst, tag, numsend);
                                if (recvReq != null) {
                                    int length = recvReq.addData(this.recvBuffer, size);
                                    recvReq.fillStatus(status, length);
                                    recvReq.complete();
                                } else {
                                    byte[] bData = new byte[size];
                                    this.recvBuffer.get(bData, 0, size);
                                    ByteBuffer unexpectedBuffer = ByteBuffer.allocateDirect(size);
                                    unexpectedBuffer.put(bData, 0, size);
                                    unexpectedBuffer.flip();
                                    if (!this.recvLog.isExist(mid)) {
                                        RecvBufferInformation buff = new RecvBufferInformation(commID, src, dst, unexpectedBuffer, tag, numsend, null);
                                        this.unexpectedQueue.addElement(buff);
                                    }
                                }
                                MessageIDLog messageIDLog = this.recvLog;
                                synchronized (messageIDLog) {
                                    this.recvLog.add(mid);
                                }
                            }
                        }
                        System.gc();
                        break;
                    }
                    default: {
                        try {
                            selKey.cancel();
                            sc.close();
                            break;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                }
            } while (this.recvBuffer.hasRemaining());
            return true;
        }
        catch (Exception e) {
            System.exit(1);
            return false;
        }
    }

    public void processSelectionKey(SelectionKey selKey) {
        String debugMessage = null;
        SocketChannel sChannel = null;
        try {
            if (selKey.isValid() && selKey.isConnectable()) {
                sChannel = (SocketChannel)selKey.channel();
                boolean success = sChannel.finishConnect();
                if (!success) {
                    selKey.cancel();
                }
                Byte isInputByte = (Byte)selKey.attachment();
                byte isInput = isInputByte;
                boolean donePrepareMsg = false;
                while (!donePrepareMsg) {
                    try {
                        DatMessage m = new DatMessage(this.sendBuffer, 1);
                        m.pack(this.myRank);
                        m.pack(this.myRankInRep);
                        m.pack(isInput);
                        m.done();
                        donePrepareMsg = true;
                    }
                    catch (BufferOverflowException e) {
                        this.sendBuffer = ByteBuffer.allocateDirect(this.sendBuffer.capacity() * 2);
                    }
                }
                if (sChannel.write(this.sendBuffer) > 0) {
                    sChannel.register(this.selector, 1);
                    ++this.totalConnect;
                    if (isInput == 0) {
                        sChannel.keyFor(this.selector).cancel();
                        sChannel.configureBlocking(true);
                        sChannel.socket().setTcpNoDelay(true);
                        this.semaphoreSet.put(sChannel, new Semaphore(1, true));
                    }
                }
            }
            if (selKey.isValid() && selKey.isReadable()) {
                int numRead;
                boolean increaseBufferSize = false;
                SocketAttachment attachment = null;
                int lastRecvBufferPosition = 0;
                ByteBuffer tmpBuffer = null;
                this.recvBuffer.clear();
                SocketChannel sc = (SocketChannel)selKey.channel();
                debugMessage = "[isReadable]: from " + sc.toString();
                attachment = (SocketAttachment)selKey.attachment();
                if (attachment != null) {
                    tmpBuffer = this.recvBuffer;
                    this.recvBuffer = attachment.getBuffer();
                    lastRecvBufferPosition = attachment.getPosition();
                }
                int totalRead = 0;
                do {
                    numRead = sc.read(this.recvBuffer);
                    totalRead += numRead;
                    if (this.recvBuffer.hasRemaining()) continue;
                    ByteBuffer tmp = ByteBuffer.allocateDirect(this.recvBuffer.capacity() * 2);
                    if (attachment != null) {
                        tmpBuffer = ByteBuffer.allocateDirect(this.recvBuffer.capacity() * 2);
                    }
                    int oldPosition = this.recvBuffer.position();
                    this.recvBuffer.position(0);
                    this.recvBuffer.limit(this.recvBuffer.capacity());
                    tmp.put(this.recvBuffer);
                    tmp.position(oldPosition);
                    this.recvBuffer = tmp;
                } while (numRead > 0);
                if (totalRead < 0) {
                    try {
                        selKey.cancel();
                        sc.close();
                    }
                    catch (Exception e) {
                        return;
                    }
                } else if (totalRead == 0) {
                    return;
                }
                this.recvBuffer.flip();
                this.recvBuffer.position(lastRecvBufferPosition);
                if (!this.encodeMessage(sc, selKey)) {
                    if (this.recvBuffer.hasRemaining()) {
                        if (attachment != null) {
                            attachment.setPosition(this.recvBuffer.position());
                            this.recvBuffer.position(this.recvBuffer.limit());
                            this.recvBuffer.limit(this.recvBuffer.capacity());
                            attachment.setBuffer(this.recvBuffer);
                            this.recvBuffer = tmpBuffer;
                        } else {
                            ByteBuffer attachBuffer = ByteBuffer.allocateDirect(this.recvBuffer.capacity());
                            attachBuffer.put(this.recvBuffer);
                            attachBuffer.limit(this.recvBuffer.capacity());
                            attachment = new SocketAttachment(attachBuffer, 0);
                            selKey.attach(attachment);
                        }
                    }
                } else if (attachment != null) {
                    this.recvBuffer.clear();
                    attachment.setBuffer(this.recvBuffer);
                    attachment.setPosition(0);
                    this.recvBuffer = tmpBuffer;
                }
            }
            if (selKey.isValid() && selKey.isAcceptable()) {
                ServerSocketChannel serv = (ServerSocketChannel)selKey.channel();
                SocketChannel sock = serv.accept();
                sock.configureBlocking(false);
                sock.socket().setSendBufferSize(524288);
                sock.socket().setReceiveBufferSize(524288);
                sock.socket().setTcpNoDelay(true);
                sock.register(this.selector, 1);
            }
        }
        catch (Exception e) {
            System.out.println("[Error] Socket Channel: " + sChannel.toString());
            if (debugMessage != null) {
                System.out.println("[Error] extra info:" + debugMessage);
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFailureRepair(int deadNodeRankInList) {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            this.rankTable.setAlive(deadNodeRankInList, false);
            this.rankTable.setTerminated(deadNodeRankInList, true);
        }
        int numPeers = this.rankTable.size();
        if (deadNodeRankInList == 0) {
            this.cleanupProcess();
            System.exit(1);
        }
        int commSize = this.msgHandle.getCommSize();
        boolean[] rankAliveNode = new boolean[commSize];
        for (int i = 0; i < commSize; ++i) {
            rankAliveNode[i] = false;
        }
        RankTable i = this.rankTable;
        synchronized (i) {
            for (int i2 = 0; i2 < numPeers; ++i2) {
                if (!this.rankTable.isAlive(i2)) continue;
                rankAliveNode[this.rankTable.getRank((int)i2)] = true;
            }
        }
        for (int i3 = 0; i3 < commSize; ++i3) {
            if (rankAliveNode[i3]) continue;
            System.err.println("** [Error] rank " + i3 + " process failed (i.e. all replicas for that rank failed). Application did not completed. <<detected by rank in list: " + this.myRankInList + ">>");
            this.cleanupProcess();
            System.exit(1);
        }
        NotifyMessage noMPDMsg = new NotifyMessage(this.myHash + "--" + this.myRank, deadNodeRankInList);
        try {
            Socket so = new Socket("127.0.0.1", this.mpdPort);
            OutputStream oout = so.getOutputStream();
            ObjectOutputStream ooos = new ObjectOutputStream(oout);
            ooos.writeObject(noMPDMsg);
            ooos.flush();
            ooos.close();
            oout.close();
            so.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (deadNodeRankInList == this.myMaster) {
            int myNewMaster = this.myRankInList;
            int myCommSize = this.rankTable.size();
            for (int i4 = 0; i4 < myCommSize; ++i4) {
                if (this.myRank != this.rankTable.getRank(i4) || !this.rankTable.isAlive(i4)) continue;
                if (myNewMaster <= i4) {
                    this.myMaster = i4;
                    this.master = true;
                    break;
                }
                this.master = false;
                this.myMaster = i4;
                break;
            }
            if (this.master) {
                Vector i4 = this.backupBuffer;
                synchronized (i4) {
                    while (this.backupBuffer.size() != 0) {
                        SendBufferInformation binfo = (SendBufferInformation)this.backupBuffer.elementAt(0);
                        String backupDataMID = this.getMessageID(binfo.getCommID(), binfo.getSrc(), binfo.getDst(), binfo.getTag(), binfo.getNumSend());
                        this.send(binfo.getRankTable(), binfo.getData(), binfo.getDestinations(), binfo.getCommID(), binfo.getSrc(), binfo.getDst(), binfo.getTag(), binfo.getNumSend(), binfo.getReplicaRankInList());
                        this.backupBuffer.removeElementAt(0);
                        this.sendLog.remove(backupDataMID);
                    }
                }
            }
        }
        for (String map : this.largeMessagePending.keySet()) {
            LargeMessageSender largeMessageSender = this.largeMessagePending.get(map);
            largeMessageSender.setReady(deadNodeRankInList);
            if (!largeMessageSender.isReady()) continue;
            Thread largeMessageThread = new Thread(largeMessageSender);
            largeMessageThread.setDaemon(true);
            largeMessageThread.start();
            this.largeMessagePending.remove(map);
        }
    }

    @Override
    public int send(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {
        NIORequest req = this.isend(commTable, data, dest, commID, src, dst, tag, numsend, repRankInList);
        IStatus istatus = req.Wait();
        return 0;
    }

    @Override
    public int ssend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {
        NIORequest req = this.issend(commTable, data, dest, commID, src, dst, tag, numsend, repRankInList);
        IStatus istatus = req.Wait();
        return 0;
    }

    @Override
    public NIORequest issend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {
        int numDest = dest.size();
        LargeMessageSender largeMessageSender = null;
        NIORequest nioRequest = new NIORequest();
        DatMessage readyToSend = new DatMessage(this.readyToSendBuffer, 6);
        readyToSend.pack(commID);
        readyToSend.pack(src);
        readyToSend.pack(dst);
        readyToSend.pack(tag);
        readyToSend.pack(numsend);
        readyToSend.pack(this.myRankInList);
        readyToSend.pack(this.myRank);
        readyToSend.pack(this.myRankInRep);
        readyToSend.done();
        largeMessageSender = new LargeMessageSender(commTable, repRankInList, commID, src, dst, tag, numsend, this.readyToSendBuffer, data);
        for (int i = 0; i < numDest; ++i) {
            int ril = dest.elementAt(i);
            if (!this.commWorld.isAlive(ril)) continue;
            SocketChannel socket = this.outputChannels[i][this.getMapRankTable(commID).getWorldRank(ril)];
            SmallRequest smallRequest = new SmallRequest(ril);
            nioRequest.add(smallRequest);
            Semaphore sem = (Semaphore)this.semaphoreSet.get(socket);
            try {
                sem.acquire();
                largeMessageSender.addDestination(socket, smallRequest, ril);
                sem.release();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
        largeMessageSender.sendReadyToSend();
        nioRequest.fillStatus(src, tag, 0);
        return nioRequest;
    }

    @Override
    public NIORequest isend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {
        boolean eagerMode;
        int numDest = dest.size();
        int messageSize = data.limit();
        LargeMessageSender largeMessageSender = null;
        NIORequest nioRequest = new NIORequest();
        if (messageSize < EAGER_SIZE) {
            eagerMode = true;
        } else {
            eagerMode = false;
            DatMessage readyToSend = new DatMessage(this.readyToSendBuffer, 6);
            readyToSend.pack(commID);
            readyToSend.pack(src);
            readyToSend.pack(dst);
            readyToSend.pack(tag);
            readyToSend.pack(numsend);
            readyToSend.pack(this.myRankInList);
            readyToSend.pack(this.myRank);
            readyToSend.pack(this.myRankInRep);
            readyToSend.done();
            largeMessageSender = new LargeMessageSender(commTable, repRankInList, commID, src, dst, tag, numsend, this.readyToSendBuffer, data);
        }
        for (int i = 0; i < numDest; ++i) {
            int ril = dest.elementAt(i);
            if (!this.commWorld.isAlive(ril)) continue;
            SocketChannel socket = this.outputChannels[i][this.getMapRankTable(commID).getWorldRank(ril)];
            SmallRequest smallRequest = new SmallRequest(ril);
            nioRequest.add(smallRequest);
            Semaphore sem = (Semaphore)this.semaphoreSet.get(socket);
            try {
                sem.acquire();
                if (eagerMode) {
                    this.toleranceWrite(data, socket, ril);
                    smallRequest.complete();
                    data.rewind();
                } else {
                    largeMessageSender.addDestination(socket, smallRequest, ril);
                }
                sem.release();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (eagerMode) {
            this.commit(commTable, repRankInList, commID, src, dst, tag, numsend);
        } else {
            this.largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
            largeMessageSender.sendReadyToSend();
        }
        nioRequest.fillStatus(src, tag, 0);
        return nioRequest;
    }

    @Override
    public synchronized void commit(RankTable commTable, int[] repRankInList, short commID, int src, int dst, int tag, int numsend) {
        DatMessage m = new DatMessage(this.commitBuffer, 3);
        m.pack(commID);
        m.pack(src);
        m.pack(dst);
        m.pack(tag);
        m.pack(numsend);
        m.done();
        for (int i = 0; i < this.numReplica; ++i) {
            if (repRankInList[i] == this.myRankInList || !this.commWorld.isAlive(repRankInList[i])) continue;
            SocketChannel socket = this.outputChannels[i][this.getMapRankTable(commID).getWorldRank(this.myRankInList)];
            Semaphore sem = (Semaphore)this.semaphoreSet.get(socket);
            try {
                sem.acquire();
                this.toleranceWrite(this.commitBuffer, socket, repRankInList[i]);
                sem.release();
                this.commitBuffer.rewind();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void finalize(int rankInList) {
        DatMessage m = new DatMessage(this.finalizeBuffer, 4);
        m.pack(rankInList);
        m.done();
        SocketChannel socket = this.outputChannels[0][0];
        Semaphore sem = (Semaphore)this.semaphoreSet.get(socket);
        try {
            sem.acquire();
            this.toleranceWrite(this.finalizeBuffer, socket, 0);
            sem.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void finalizeConfirm() {
        ByteBuffer finalizeConfirmBuffer = ByteBuffer.allocate(3);
        finalizeConfirmBuffer.putShort((short)13);
        finalizeConfirmBuffer.put((byte)5);
        finalizeConfirmBuffer.flip();
        int numNode = this.rankTable.size();
        for (int i = 1; i < numNode; ++i) {
            URI dst = this.rankTable.getDataURI(i);
            int dstRank = this.rankTable.getRank(i);
            int dstRankInRep = this.rankTable.getRankInReplica(dst, i);
            SocketChannel socket = this.outputChannels[dstRankInRep][dstRank];
            Semaphore sem = (Semaphore)this.semaphoreSet.get(socket);
            try {
                sem.acquire();
                this.toleranceWrite(finalizeConfirmBuffer, socket, i);
                sem.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finalizeConfirmBuffer.position(0);
        }
    }

    private boolean reconnect(int ril) {
        URI toConnect = this.rankTable.getDataURI(ril);
        int itsRank = this.rankTable.getRank(ril);
        int itsRankInRep = this.rankTable.getRankInReplica(toConnect, ril);
        while (this.rankTable.isAlive(ril)) {
            if (!this.connectToNode(toConnect, itsRank, itsRankInRep, this.outputChannels, (byte)0)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {}
                continue;
            }
            return true;
        }
        return false;
    }

    public void toleranceWrite(ByteBuffer data, SocketChannel socket, int ril) {
        while (data.hasRemaining()) {
            try {
                int numWrite = socket.write(data);
                if (numWrite >= 0 || this.reconnect(ril)) continue;
                return;
            }
            catch (Exception e) {
                if (this.reconnect(ril)) continue;
                return;
            }
        }
    }

    @Override
    public IStatus recv(Object recvBuffer, int offset, int count, short commID, int src, int dst, int tag, int numsend, P2PMPI_Buffer buffer) {
        NIORequest req = this.irecv(recvBuffer, offset, count, commID, src, dst, tag, numsend, buffer);
        IStatus istatus = req.Wait();
        return istatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NIORequest irecv(Object recvBuffer, int offset, int count, short commID, int src, int dst, int tag, int numsend, P2PMPI_Buffer buffer) {
        NIORequest req = new NIORequest(recvBuffer, offset, count, src, dst, tag, buffer);
        Vector vector = this.unexpectedQueue;
        synchronized (vector) {
            Vector vector2 = this.expectedQueue;
            synchronized (vector2) {
                Map<String, RDVHeaderInformation> map = this.waitForRecvReady;
                synchronized (map) {
                    IStatus status = new IStatus();
                    ByteBuffer data = this.getDataFromUnexpectedQueue(commID, src, dst, tag, numsend, status);
                    if (data != null) {
                        int length = req.addData(data, data.remaining());
                        req.fillStatus(status, length);
                        req.complete();
                        return req;
                    }
                    RDVHeaderInformation rdvInfo = this.waitForRecvReady.remove(this.getHashKey(commID, src, dst, tag, numsend));
                    if (rdvInfo != null) {
                        this.sendReadyToRecv(rdvInfo.getCommID(), rdvInfo.getSrc(), rdvInfo.getDst(), rdvInfo.getTag(), rdvInfo.getNumSend(), rdvInfo.getSenderRIL(), rdvInfo.getSenderRank(), rdvInfo.getSenderRIR());
                    }
                    RecvBufferInformation buff = new RecvBufferInformation(commID, src, dst, null, tag, numsend, req);
                    this.expectedQueue.addElement(buff);
                }
            }
        }
        return req;
    }

    public class SocketAttachment {
        ByteBuffer buffer;
        int position;

        public SocketAttachment(ByteBuffer buffer, int position) {
            this.buffer = buffer;
            this.position = position;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getPosition() {
            return this.position;
        }

        public void setBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    public class MessageSender {
        SocketChannel socket;
        SmallRequest smallRequest;
        int rankInList;
        boolean readyToSend;

        public MessageSender(SocketChannel socket, SmallRequest smallRequest, int rankInList) {
            this.socket = socket;
            this.smallRequest = smallRequest;
            this.rankInList = rankInList;
            this.readyToSend = false;
        }

        public void setReady() {
            this.readyToSend = true;
        }

        public boolean isReady() {
            return this.readyToSend;
        }

        public SocketChannel getSocket() {
            return this.socket;
        }

        public int getDestination() {
            return this.rankInList;
        }

        public SmallRequest getSmallRequest() {
            return this.smallRequest;
        }
    }

    public class LargeMessageSender
    implements Runnable {
        Vector<MessageSender> senderList = new Vector();
        RankTable commTable;
        int[] repRankInList;
        short commID;
        int src;
        int dst;
        int tag;
        int numsend;
        ByteBuffer dataBuffer;
        int numSender;
        ByteBuffer readyToSendBuffer;
        long t1;
        long t2;
        long t3;
        long t4;
        SocketChannel destinationSocket;
        SmallRequest destinationSmallRequest;
        int destinationRankInList;
        boolean readyToSend = false;

        public LargeMessageSender(RankTable commTable, int[] repRankInList, short commID, int src, int dst, int tag, int numsend, ByteBuffer readyToSendBuffer, ByteBuffer data) {
            this.commTable = commTable;
            this.repRankInList = repRankInList;
            this.commID = commID;
            this.src = src;
            this.dst = dst;
            this.tag = tag;
            this.numsend = numsend;
            this.numSender = 0;
            this.readyToSendBuffer = readyToSendBuffer;
            this.dataBuffer = data;
        }

        public String getKey() {
            return this.commID + "_" + this.src + "_" + this.dst + "_" + this.tag + "_" + this.numsend;
        }

        public void sendReadyToSend() {
            if (NIODevice.this.numReplica == 1) {
                Semaphore sem = (Semaphore)NIODevice.this.semaphoreSet.get(this.destinationSocket);
                try {
                    sem.acquire();
                    NIODevice.this.toleranceWrite(this.readyToSendBuffer, this.destinationSocket, this.destinationRankInList);
                    sem.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.numSender; ++i) {
                    MessageSender sender = this.senderList.elementAt(i);
                    SocketChannel socket = sender.getSocket();
                    int ril = sender.getDestination();
                    Semaphore sem = (Semaphore)NIODevice.this.semaphoreSet.get(socket);
                    try {
                        sem.acquire();
                        NIODevice.this.toleranceWrite(this.readyToSendBuffer, socket, ril);
                        this.readyToSendBuffer.rewind();
                        sem.release();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void addDestination(SocketChannel socket, SmallRequest smallRequest, int rankInList) {
            if (NIODevice.this.numReplica == 1) {
                this.destinationSocket = socket;
                this.destinationSmallRequest = smallRequest;
                this.destinationRankInList = rankInList;
            } else {
                MessageSender sender = new MessageSender(socket, smallRequest, rankInList);
                this.senderList.add(sender);
                ++this.numSender;
            }
        }

        public void setReady(int dstRIL) {
            block2: {
                block1: {
                    if (NIODevice.this.numReplica != 1) break block1;
                    if (this.destinationRankInList != dstRIL) break block2;
                    this.readyToSend = true;
                    break block2;
                }
                for (int i = 0; i < this.numSender; ++i) {
                    MessageSender sender = this.senderList.elementAt(i);
                    if (sender.getDestination() != dstRIL) continue;
                    sender.setReady();
                    break;
                }
            }
        }

        public boolean isReady() {
            if (NIODevice.this.numReplica == 1) {
                return this.readyToSend;
            }
            for (int i = 0; i < this.numSender; ++i) {
                MessageSender sender = this.senderList.elementAt(i);
                if (sender.isReady()) continue;
                return false;
            }
            return true;
        }

        public void run() {
            if (NIODevice.this.numReplica == 1) {
                Semaphore sem = (Semaphore)NIODevice.this.semaphoreSet.get(this.destinationSocket);
                try {
                    sem.acquire();
                    NIODevice.this.toleranceWrite(this.dataBuffer, this.destinationSocket, this.destinationRankInList);
                    if (this.destinationSmallRequest != null) {
                        this.destinationSmallRequest.complete();
                    }
                    sem.release();
                }
                catch (Exception e) {
                    // empty catch block
                }
                NIODevice.this.commit(this.commTable, this.repRankInList, this.commID, this.src, this.dst, this.tag, this.numsend);
            } else {
                for (int i = 0; i < this.numSender; ++i) {
                    MessageSender sender = this.senderList.elementAt(i);
                    SocketChannel socket = sender.getSocket();
                    int ril = sender.getDestination();
                    SmallRequest smallRequest = sender.getSmallRequest();
                    Semaphore sem = (Semaphore)NIODevice.this.semaphoreSet.get(socket);
                    try {
                        sem.acquire();
                        NIODevice.this.toleranceWrite(this.dataBuffer, socket, ril);
                        if (smallRequest != null) {
                            smallRequest.complete();
                        }
                        this.dataBuffer.rewind();
                        sem.release();
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                NIODevice.this.commit(this.commTable, this.repRankInList, this.commID, this.src, this.dst, this.tag, this.numsend);
            }
        }
    }
}

