/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.RankTable;
import p2pmpi.message.AliveMessage;
import p2pmpi.message.IsAliveMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.NoAliveMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.message.RequestQuitMessage;
import p2pmpi.mpi.dev.Device;

public class MessageHandler
implements Runnable {
    private String key;
    private boolean ready;
    private ServerSocket servSocket = null;
    private RankTable rankTable;
    private int myRank;
    private int myRankInList;
    private int commSize;
    private int t_gossip;
    private String gossipProtocol;
    private int t_margin;
    private int t_diff;
    private int t_hang;
    private volatile boolean shutdown = false;
    private boolean rankZero;
    private Device dev;

    public MessageHandler(Device dev, ServerSocket servSocket, int commSize, RankTable rankTable, String key, int mpdPort, int fdPort) {
        this.dev = dev;
        this.commSize = commSize;
        this.key = key;
        this.rankTable = rankTable;
        this.ready = false;
        this.rankZero = true;
        this.shutdown = false;
        this.servSocket = servSocket;
        try {
            this.servSocket.setSoTimeout(0);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public MessageHandler(Device dev, ServerSocket servSocket, String key, int mpdPort, int fdPort) {
        this.dev = dev;
        this.key = key;
        this.ready = false;
        this.shutdown = false;
        this.rankZero = false;
        this.servSocket = servSocket;
        try {
            this.servSocket.setSoTimeout(0);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.servSocket != null) {
                this.servSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRankTable(RankTable rankTable) {
        this.rankTable = rankTable;
    }

    public void setTHang(int t_hang) {
        this.t_hang = t_hang;
    }

    public int getTHang() {
        return this.t_hang;
    }

    public RankTable getRankTable() {
        return this.rankTable;
    }

    public void run() {
        Socket socket = null;
        InputStream in = null;
        ObjectInputStream ois = null;
        Object msg = null;
        Object buff = null;
        if (!this.rankZero) {
            try {
                this.servSocket.setSoTimeout(600000);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        while (!this.shutdown) {
            try {
                socket = this.servSocket.accept();
            }
            catch (SocketTimeoutException soe) {
                System.exit(1);
            }
            catch (IOException e) {
                continue;
            }
            try {
                in = socket.getInputStream();
                ois = new ObjectInputStream(in);
                msg = ois.readObject();
            }
            catch (Exception e) {
                try {
                    ois.close();
                    in.close();
                    socket.close();
                }
                catch (Exception ee) {}
                continue;
            }
            if (msg instanceof MPIMessage) {
                MPIMessage mpiMsg = (MPIMessage)msg;
                switch (mpiMsg.getCmd()) {
                    case 13: {
                        this.ready = true;
                        this.myRank = mpiMsg.getRank();
                        this.myRankInList = mpiMsg.getRankInList();
                        this.commSize = mpiMsg.getSize();
                        this.setRankTable(mpiMsg.getCommTable());
                        this.t_gossip = mpiMsg.getTGossip();
                        this.t_margin = mpiMsg.getTMargin();
                        this.t_hang = mpiMsg.getTHang();
                        this.t_diff = mpiMsg.getTDiff();
                        this.gossipProtocol = mpiMsg.getGossipProtocol();
                        try {
                            this.servSocket.setSoTimeout(0);
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            } else if (msg instanceof NotifyMessage) {
                NotifyMessage noMsg = (NotifyMessage)msg;
                int deadNodeRank = noMsg.getRankInList();
                this.dev.doFailureRepair(deadNodeRank);
            } else if (msg instanceof IsAliveMessage) {
                IsAliveMessage isAliveMsg = (IsAliveMessage)msg;
                Object s = null;
                OutputStream out = null;
                ObjectOutputStream oos = null;
                if (this.key.equals(isAliveMsg.getKey())) {
                    AliveMessage aliveMsg = new AliveMessage(this.key);
                    try {
                        out = socket.getOutputStream();
                        oos = new ObjectOutputStream(out);
                        oos.writeObject(aliveMsg);
                        oos.close();
                        out.close();
                    }
                    catch (Exception e) {}
                } else {
                    NoAliveMessage noaliveMsg = new NoAliveMessage();
                    try {
                        out = socket.getOutputStream();
                        oos = new ObjectOutputStream(out);
                        oos.writeObject(noaliveMsg);
                        oos.close();
                        out.close();
                    }
                    catch (Exception e) {}
                }
            } else if (msg instanceof RequestQuitMessage) {
                System.exit(0);
            } else if (msg instanceof OutputMessage) {
                OutputMessage outputMsg = (OutputMessage)msg;
                System.out.println(outputMsg.getOutput());
            } else {
                System.err.println("** [Warning] received unknow type of message.");
            }
            try {
                ois.close();
                in.close();
                socket.close();
            }
            catch (Exception e) {
                System.err.println("** [Error] cannot close communication, maybe a network problem.");
            }
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setTGossip(int t_gossip) {
        this.t_gossip = t_gossip;
    }

    public void setTMargin(int t_margin) {
        this.t_margin = t_margin;
    }

    public int getTDiff() {
        return this.t_diff;
    }

    public int getTGossip() {
        return this.t_gossip;
    }

    public void setGossipProtocol(String protocol) {
        this.gossipProtocol = new String(protocol);
    }

    public String getGossipProtocol() {
        return this.gossipProtocol;
    }

    public int getTMargin() {
        return this.t_margin;
    }

    public int getRank() {
        return this.myRank;
    }

    public int getRankInList() {
        return this.myRankInList;
    }

    public int getCommSize() {
        return this.commSize;
    }

    public void stop() {
        try {
            this.servSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

