/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import p2pmpi.mpi.dev.P2PMPI_Buffer;

public class BufferLong
extends P2PMPI_Buffer {
    public BufferLong(int baseSize) {
        super(baseSize);
    }

    public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
        LongBuffer lBuffer = myBuffer.asLongBuffer();
        lBuffer.put((long[])buffer, offset, count);
        myBuffer.position(myBuffer.position() + count * this.baseSize);
        return myBuffer;
    }

    public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
        int recvData = dataSize / this.baseSize < count ? dataSize / this.baseSize : count;
        LongBuffer lBuffer = data.asLongBuffer();
        lBuffer.get((long[])buffer, offset, recvData);
        data.position(data.position() + recvData * this.baseSize);
        return (recvData - offset) * this.baseSize;
    }

    public Object createArrayBuffer(int count) {
        return new long[count];
    }
}

