/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

public class BinomialTree {
    int numNode;
    int maxDegree;

    public BinomialTree(int numNode) {
        this.numNode = numNode;
        this.maxDegree = (int)Math.ceil(Math.log(numNode) / Math.log(2.0));
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public int getParentChildren(int myRank, int[] children) {
        int rootBranch = 0;
        int findIndex = myRank;
        if (myRank == 0) {
            for (int i = 0; i < this.maxDegree; ++i) {
                children[i] = (int)Math.pow(2.0, i);
            }
            children[i] = -1;
            return -1;
        }
        while (true) {
            int numBranch;
            int nodeValue;
            if (rootBranch + (nodeValue = (int)Math.pow(2.0, numBranch = (int)Math.floor(Math.log(findIndex) / Math.log(2.0)))) == myRank) {
                if (numBranch == 0) {
                    children[0] = -1;
                    break;
                }
                for (int i = 0; i < numBranch; ++i) {
                    int childNode = myRank + (int)Math.pow(2.0, i);
                    children[i] = childNode < this.numNode ? childNode : -1;
                }
                children[i] = -1;
                break;
            }
            findIndex = myRank - (rootBranch += nodeValue);
        }
        return rootBranch;
    }

    public int getParentChildrenInverse(int myRank, int[] children) {
        int rootBranch = 0;
        int findIndex = myRank;
        if (myRank == 0) {
            for (int i = 0; i < this.maxDegree; ++i) {
                children[this.maxDegree - i - 1] = (int)Math.pow(2.0, i);
            }
            children[i] = -1;
            return -1;
        }
        while (true) {
            int numBranch;
            int nodeValue;
            if (rootBranch + (nodeValue = (int)Math.pow(2.0, numBranch = (int)Math.floor(Math.log(findIndex) / Math.log(2.0)))) == myRank) {
                int i;
                if (numBranch == 0) {
                    children[0] = -1;
                    break;
                }
                for (i = 0; i < this.maxDegree; ++i) {
                    children[i] = -1;
                }
                for (i = numBranch - 1; i >= 0; --i) {
                    int childNode = myRank + (int)Math.pow(2.0, i);
                    if (childNode >= this.numNode) continue;
                    children[i] = childNode;
                }
                break;
            }
            findIndex = myRank - (rootBranch += nodeValue);
        }
        return rootBranch;
    }
}

