/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import p2pmpi.common.FileCharacteristics;
import p2pmpi.common.Getopt;
import p2pmpi.common.HashGenerator;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.Md5sum;
import p2pmpi.common.NetIface;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.RankTable;
import p2pmpi.common.ReservedPort;
import p2pmpi.common.Tag;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.FTMessage;
import p2pmpi.message.FoundNodeMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.message.RSMessage;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.DevicePort;
import p2pmpi.mpi.IntraComm;
import p2pmpi.mpi.MPIClient;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.NIODevice;
import p2pmpi.mpi.dev.NormalDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPI {
    public static Datatype NULL;
    public static Datatype BYTE;
    public static Datatype CHAR;
    public static Datatype SHORT;
    public static Datatype BOOLEAN;
    public static Datatype INT;
    public static Datatype LONG;
    public static Datatype FLOAT;
    public static Datatype DOUBLE;
    public static Datatype STRING;
    public static Datatype OBJECT;
    public static Datatype BYTE2;
    public static Datatype CHAR2;
    public static Datatype SHORT2;
    public static Datatype INT2;
    public static Datatype LONG2;
    public static Datatype FLOAT2;
    public static Datatype DOUBLE2;
    public static Datatype PACKED;
    public static int ANY_SOURCE;
    public static int ANY_TAG;
    public static int UNEQUAL;
    public static int SIMILAR;
    public static int IDENT;
    public static int UNDEFINED;
    public static Op MAX;
    public static Op MIN;
    public static Op SUM;
    public static Op PROD;
    public static Op BAND;
    public static Op MAXLOC;
    public static Op MINLOC;
    public static IntraComm COMM_WORLD;
    protected static RankTable rankTable;
    protected static MapRankTable mapRankTable;
    protected static String myHash;
    protected static int fdPort;
    protected static int mpdPort;
    protected static int rsPort;
    protected static int ftPort;
    protected static int myRank;
    protected static Device myDevice;
    protected static Random mpiRandom;
    protected static URI rank0URI;
    private static String externalIP;
    private static String internalIP;
    private static int t_sent;
    private static String CACHE_REQ_KEYWORD;

    private static void setLocalhostIp() {
        P2PMPI_ConfigFile conf = new P2PMPI_ConfigFile();
        NetIface extIf = new NetIface(conf.getIface(), conf.getExternalIP());
        externalIP = extIf.getExternalIfIpv4();
        internalIP = extIf.getInternalIfIpv4();
    }

    protected static String getLocalhostExtIp() {
        return externalIP;
    }

    protected static String getLocalhostIntIp() {
        return internalIP;
    }

    protected static void unregisterAppToMPD() {
        Socket conn = null;
        OutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            AppUnregisterMessage unRegMsg = new AppUnregisterMessage(myHash, myRank);
            conn = new Socket("127.0.0.1", mpdPort);
            os = conn.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(unRegMsg);
            oos.flush();
            oos.close();
            os.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("MPD Service is not running");
        }
    }

    private static Vector<FileCharacteristics> buildXferList(String xferfilename, Vector<String> vresult) {
        Vector<FileCharacteristics> fileCharacteristicsVector = new Vector<FileCharacteristics>();
        File fileTransferList = new File(xferfilename);
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(fileTransferList));
        }
        catch (Exception FileNotFoundException) {
            System.err.println("** [Error] File " + xferfilename + " is not found. Please, check" + " it in your current directory. Program will exit.");
            System.exit(1);
        }
        try {
            int counter = 0;
            while (true) {
                String fileName;
                if ((fileName = fileReader.readLine()) == null) {
                    if (counter == 0) {
                        System.err.println("** [Error] File " + xferfilename + " can not be left blank. " + "It should have at least full path of " + vresult.elementAt(0) + " class file " + "or the 'jar' file if it's a part of jar file. Program will exit.");
                        System.exit(1);
                    }
                    break;
                }
                if (!fileName.startsWith("http://")) {
                    File tmpFile;
                    StringTokenizer tok = new StringTokenizer(fileName);
                    boolean cached = false;
                    if (fileName.endsWith(CACHE_REQ_KEYWORD) && tok.countTokens() > 1) {
                        cached = true;
                        int last = fileName.lastIndexOf(" " + CACHE_REQ_KEYWORD);
                        fileName = fileName.substring(0, last);
                        fileName = fileName.trim();
                    }
                    if (!(tmpFile = new File(fileName)).isFile()) {
                        System.err.println("** [Error] File : " + tmpFile + " in " + xferfilename + " is not a regular file.");
                        System.exit(1);
                    }
                    String md5sum = Md5sum.md5sum(tmpFile);
                    long fileSize = tmpFile.length();
                    FileCharacteristics fileCharacteristics = new FileCharacteristics(fileName, md5sum, fileSize, cached);
                    fileCharacteristicsVector.addElement(fileCharacteristics);
                } else {
                    String md5sum = "";
                    long fileSize = 0L;
                    boolean cached = false;
                    FileCharacteristics fileCharacteristics = new FileCharacteristics(fileName, md5sum, fileSize, cached);
                    fileCharacteristicsVector.addElement(fileCharacteristics);
                }
                ++counter;
            }
        }
        catch (Exception e) {
            System.err.println("** [Error] Could not read file " + xferfilename);
            System.exit(1);
        }
        return fileCharacteristicsVector;
    }

    public static String[] Init(String[] args) {
        String[] result = null;
        String runCmd = null;
        Socket conn = null;
        OutputStream os = null;
        ObjectOutputStream oos = null;
        InputStream in = null;
        ObjectInputStream ois = null;
        MPIMessage mpiMsg = null;
        P2PMPI_ConfigFile conf = new P2PMPI_ConfigFile();
        mpdPort = conf.getMPDPort();
        ftPort = conf.getFTPort();
        rsPort = conf.getRSPort();
        fdPort = conf.getFDPort();
        int tGossip = conf.getTGossip();
        int tHang = conf.getTHang();
        String gossipProtocol = conf.getGossipProtocol();
        MPI.setLocalhostIp();
        int minPort = conf.getMinPort();
        int maxPort = conf.getMaxPort();
        String mode = System.getProperty("mode");
        if (mode.equals("server")) {
            int i;
            int c;
            int numPeers = -1;
            int maxWaitTime = -1;
            int numReplica = 1;
            String allocationMode = null;
            String fileDep = null;
            boolean interactive = true;
            String msgIntArg = "must be followed by a positive integer number";
            Getopt g = new Getopt("P2P-MPI", args, "w:n:r:l:a:X:D:");
            g.setOpterr(false);
            String javaXOption = "";
            String javaDOption = "";
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 119: {
                        String arg = g.getOptarg();
                        try {
                            maxWaitTime = Integer.parseInt(arg);
                        }
                        catch (Exception e) {
                            System.err.println("** [Error] -w  " + msgIntArg);
                            System.exit(1);
                        }
                        if (maxWaitTime >= -1) break;
                        System.err.println("** [Error] -w  " + msgIntArg);
                        System.exit(1);
                        break;
                    }
                    case 110: {
                        String arg = g.getOptarg();
                        try {
                            numPeers = Integer.parseInt(arg);
                        }
                        catch (Exception e) {
                            System.err.println("** [Error] -n  " + msgIntArg);
                            System.exit(1);
                        }
                        if (numPeers >= 1) break;
                        System.err.println("** [Error] -n  " + msgIntArg);
                        System.exit(1);
                        break;
                    }
                    case 114: {
                        String arg = g.getOptarg();
                        try {
                            numReplica = Integer.parseInt(arg);
                        }
                        catch (Exception e) {
                            System.err.println("** [Error] -r  " + msgIntArg);
                            System.exit(1);
                        }
                        if (numReplica >= 1) break;
                        System.err.println("** [Error] -r  " + msgIntArg);
                        System.exit(1);
                        break;
                    }
                    case 108: {
                        String arg = g.getOptarg();
                        fileDep = new String(arg);
                        break;
                    }
                    case 97: {
                        String arg = g.getOptarg();
                        allocationMode = new String(arg);
                        if (allocationMode.equalsIgnoreCase("spread") || allocationMode.equalsIgnoreCase("concentrate") || allocationMode.equalsIgnoreCase("dataconcentrate") || allocationMode.equalsIgnoreCase("dataspread")) break;
                        System.err.println("** [Error] -a must be followed by \"spread\" or \"concentrate\" or \"dataspread\" or \"dataconcentrate\"");
                        System.exit(1);
                        break;
                    }
                    case 88: {
                        String arg = g.getOptarg();
                        javaXOption = "-X" + arg + " ";
                        break;
                    }
                    case 68: {
                        String arg = g.getOptarg();
                        javaDOption = "-D" + arg + " ";
                    }
                }
            }
            Vector<String> vresult = new Vector<String>();
            for (int i2 = g.getOptind(); i2 < args.length; ++i2) {
                vresult.addElement(args[i2]);
            }
            runCmd = new String(javaXOption + javaDOption + (String)vresult.elementAt(0));
            int numargs = vresult.size();
            result = new String[numargs - 1];
            for (int i3 = 0; i3 < numargs - 1; ++i3) {
                result[i3] = new String((String)vresult.elementAt(i3 + 1));
                runCmd = runCmd + " " + result[i3];
            }
            int minPeers = numReplica;
            int maxPeers = (numPeers - 1) * numReplica;
            ReservedPort rank0Port = new ReservedPort(minPort, maxPort);
            if (rank0Port.getPort() == null) {
                System.err.println("[Error] No available ports in the range allowed [" + minPort + " - " + maxPort + "] to run this application. Creating a server socket failed with \"" + rank0Port.getErrorMessage() + "\"");
                System.exit(1);
            } else {
                try {
                    rank0URI = new URI("tcp://" + MPI.getLocalhostExtIp() + ":" + rank0Port.getPortNumber());
                }
                catch (Exception e) {
                    System.err.println("[MPI] internal error: malformed URI tcp://" + MPI.getLocalhostExtIp() + ":" + rank0Port.getPortNumber());
                }
            }
            myHash = HashGenerator.gen();
            mpiRandom = new Random(Long.parseLong(myHash));
            String dev = System.getProperty("device");
            if (dev == null) {
                System.err.println("[Error] \"device\" property undefined. Use java -Ddevice. Exiting.");
                System.exit(1);
            }
            if (!(myDevice = dev.equals("niodevice") ? new NIODevice() : (dev.equals("normal") ? new NormalDevice() : new NIODevice())).init()) {
                System.err.println("[Error] : MPI NIO device init failed");
                System.exit(1);
            }
            DevicePort datadev = new DevicePort(minPort, maxPort, "data port");
            DevicePort ctrldev = new DevicePort(minPort, maxPort, "control port");
            if (numPeers == 1) {
                rankTable = new RankTable();
                rankTable.addProcess(0, rank0URI, ctrldev.getExtURI(), datadev.getExtURI(), fdPort);
                rankTable.setNumProcess(1);
                rankTable.setNumReplica(1);
                mapRankTable = new MapRankTable();
                mapRankTable.addMap(0, 0, 0);
                AppRegisterMessage appMsg = new AppRegisterMessage();
                appMsg.setID(myHash + "--0");
                appMsg.setRunCmd(runCmd);
                appMsg.setIPRank0(MPI.getLocalhostExtIp());
                appMsg.setRunDir("");
                appMsg.setRank(0);
                appMsg.setPort(rank0Port.getPortNumber());
                appMsg.setMPISize(numPeers);
                appMsg.setRealSize(rankTable.size());
                appMsg.setRankTable(rankTable);
                try {
                    conn = new Socket("127.0.0.1", mpdPort);
                    os = conn.getOutputStream();
                    oos = new ObjectOutputStream(os);
                    oos.writeObject(appMsg);
                    oos.flush();
                    in = conn.getInputStream();
                    ois = new ObjectInputStream(in);
                    PingReplyMessage replyMsg = (PingReplyMessage)ois.readObject();
                    ois.close();
                    oos.close();
                    os.close();
                    in.close();
                    conn.close();
                }
                catch (Exception e) {
                    System.err.println("** [Error] Please make sure that MPD is running.");
                    System.exit(1);
                }
                myDevice.connect(0, 0, 0, rankTable, numPeers, numReplica);
                myDevice.spawnMessageHandler(rank0Port.getPort(), numPeers, rankTable, myHash, mpdPort, fdPort, conf.getTGossip(), t_sent * rankTable.size(), conf.getTHang(), conf.getGossipProtocol());
                Thread devThread = new Thread(myDevice);
                devThread.setDaemon(true);
                devThread.start();
                COMM_WORLD = new IntraComm(myDevice, rankTable, 0, 0, numPeers, mapRankTable);
                return result;
            }
            if (maxWaitTime < 0) {
                maxWaitTime = maxPeers * 2;
            }
            Vector<FileCharacteristics> fileCharacteristicsVector = new Vector();
            if (fileDep == null) {
                String execName = new String(vresult.elementAt(0));
                File fileExecName = new File(System.getProperty("user.dir"), execName);
                execName = new String(fileExecName.toString() + ".class");
                File tmpFile = new File(execName);
                String md5sum = Md5sum.md5sum(tmpFile);
                long fileSize = tmpFile.length();
                boolean cached = false;
                FileCharacteristics fileCharacteristics = new FileCharacteristics(execName, md5sum, fileSize, cached);
                fileCharacteristicsVector.addElement(fileCharacteristics);
            } else {
                fileCharacteristicsVector = MPI.buildXferList(fileDep, vresult);
            }
            MPDMessage msg = new MPDMessage(8, myHash);
            msg.setOptionN(numPeers - 1);
            msg.setOptionR(numReplica);
            msg.setMinPeers(minPeers);
            msg.setMaxPeers(maxPeers);
            msg.setWaitTime(maxWaitTime);
            msg.setURI(MPI.getLocalhostExtIp(), rank0Port.getPortNumber());
            msg.setRunCmd(runCmd);
            msg.setAllocationMode(allocationMode);
            msg.setFileCharacteristics(fileCharacteristicsVector);
            System.out.println("Searching nodes for a maximum of " + maxWaitTime + " seconds ...");
            Socket requestConn = null;
            try {
                requestConn = new Socket("127.0.0.1", mpdPort);
                os = requestConn.getOutputStream();
                in = requestConn.getInputStream();
                oos = new ObjectOutputStream(os);
                oos.writeObject(msg);
                oos.flush();
                ois = new ObjectInputStream(in);
                FoundNodeMessage tmp = (FoundNodeMessage)ois.readObject();
                boolean canrun = tmp.isEnough();
                int foundNode = tmp.getNumFoundNode();
                int availableSlot = tmp.getNumSlotAvailable();
                ois.close();
                oos.close();
                in.close();
                os.close();
                requestConn.close();
                if (!canrun) {
                    if (availableSlot == 0) {
                        System.err.println("** [Error] Not enough hosts (found only " + foundNode + ").");
                    } else {
                        System.err.println("** [Error] Not enough hosts (found only " + foundNode + " nodes that can provide only " + availableSlot + " slots).");
                    }
                    System.err.println("**         You may try to search longer with -w option.");
                    System.exit(1);
                }
                if (!allocationMode.equalsIgnoreCase("gather") && foundNode < maxPeers + 1) {
                    System.out.println("** [Warning] Found only " + foundNode + " host(s).");
                    System.out.println("**           Several processes will be executed on a same host.");
                }
            }
            catch (Exception e) {
                System.err.println("** [Error] Cannot connect to local MPD (127.0.0.1:" + mpdPort + ").");
                System.err.println("**         Make sure you have run \"mpiboot\"");
                System.exit(1);
            }
            System.out.print("* Waiting reply from other nodes..");
            System.out.flush();
            conn = null;
            MPDMessage replyMsg = null;
            int replyNode = 0;
            URI[] uriList = new URI[maxPeers];
            int[] keyList = new int[maxPeers];
            try {
                rank0Port.getPort().setSoTimeout(120000);
            }
            catch (Exception e) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            System.out.println(" (listening on port " + rank0Port.getPortNumber() + ")");
            while (true) {
                try {
                    conn = rank0Port.getPort().accept();
                    in = conn.getInputStream();
                    ois = new ObjectInputStream(in);
                    replyMsg = (MPDMessage)ois.readObject();
                    ois.close();
                    in.close();
                    conn.close();
                }
                catch (SocketTimeoutException se) {
                    System.err.println("** [Error] No reply from at least one of the hosts.");
                    System.err.println("**         Check no firewall blocks port " + rank0Port.getPort().getLocalPort());
                    System.exit(1);
                }
                catch (IOException e) {
                    continue;
                }
                catch (ClassNotFoundException ce) {
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
                switch (replyMsg.getCmd()) {
                    case 10: {
                        System.out.println("* got ACCEPT (FT " + replyMsg.getHost() + ":" + replyMsg.getFTPort() + ",key=" + replyMsg.getRank() + ")");
                        try {
                            uriList[replyNode] = new URI("tcp://" + replyMsg.getHost() + ":" + replyMsg.getFTPort());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        keyList[replyNode] = replyMsg.getRank();
                        ++replyNode;
                        break;
                    }
                    default: {
                        System.out.println("Unknown command");
                    }
                }
                if (replyNode >= maxPeers) break;
            }
            FTMessage ftMsg = new FTMessage(4, myHash);
            ftMsg.setKeys(keyList);
            ftMsg.setURIs(uriList);
            ftMsg.setRank0URI(rank0URI);
            ftMsg.setSize(replyNode);
            ftMsg.setFileCharacteristicsVector(fileCharacteristicsVector);
            System.out.print("* Requesting FT to transfer files ... [ ");
            int numFiles = fileCharacteristicsVector.size();
            for (int i4 = 0; i4 < numFiles; ++i4) {
                File tmpFile = new File(fileCharacteristicsVector.elementAt(i4).getFileName());
                if (fileCharacteristicsVector.elementAt(i4).isToBeCached()) {
                    System.out.print(tmpFile.getName() + "(C) ");
                    continue;
                }
                System.out.print(tmpFile.getName() + " ");
            }
            System.out.print("] ...");
            try {
                requestConn = new Socket("127.0.0.1", ftPort);
                os = requestConn.getOutputStream();
                oos = new ObjectOutputStream(os);
                oos.writeObject(ftMsg);
                oos.flush();
                oos.close();
                os.close();
                requestConn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println(" done.");
            System.out.println("* Waiting for processes to acknowledge file transfer ...");
            rankTable = new RankTable();
            rankTable.addProcess(0, rank0URI, ctrldev.getExtURI(), datadev.getExtURI(), fdPort);
            mapRankTable = new MapRankTable();
            mapRankTable.addMap(0, 0, 0);
            int readyNode = 0;
            try {
                rank0Port.getPort().setSoTimeout(0);
            }
            catch (Exception e) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            boolean receiveAllPeer = false;
            while (true) {
                try {
                    while (true) {
                        System.out.println("* Wait for SYN message ...");
                        conn = rank0Port.getPort().accept();
                        in = conn.getInputStream();
                        ois = new ObjectInputStream(in);
                        Object oMsg = ois.readObject();
                        if (oMsg instanceof MPIMessage) {
                            mpiMsg = (MPIMessage)oMsg;
                            ois.close();
                            in.close();
                            conn.close();
                            break;
                        }
                        if (oMsg instanceof MPDMessage) {
                            MPDMessage m = (MPDMessage)oMsg;
                            if (m.getCmd() == 7) {
                                System.err.println("** [Error] FT at " + m.getURI().getHost() + " failed to stage file: " + m.getErrorMessage());
                                System.exit(1);
                            } else {
                                System.err.println("* Received unexpected MPDMessage(cmd=" + m.getCmd() + ")");
                            }
                            break;
                        }
                        if (!(oMsg instanceof OutputMessage)) continue;
                        OutputMessage outMsg = (OutputMessage)oMsg;
                        System.out.println(">>>>" + outMsg.getOutput());
                        ois.close();
                        in.close();
                        conn.close();
                    }
                }
                catch (SocketTimeoutException se) {
                    se.printStackTrace();
                    System.err.println("** [Error] Not enough peers to form an execution platform.");
                    System.err.println("**         At least one of the requested hosts is behind a firewall.");
                    System.exit(1);
                }
                catch (IOException e) {
                    continue;
                }
                catch (ClassNotFoundException ce) {
                    continue;
                }
                if (mpiMsg.getCmd() != 12) continue;
                System.out.println("SYN:" + mpiMsg.getRank() + ":" + mpiMsg.getURI());
                rankTable.addProcess(mpiMsg.getRank(), mpiMsg.getURI(), mpiMsg.getCtrlURI(), mpiMsg.getDataURI(), mpiMsg.getFDPort());
                mapRankTable.addMap(mpiMsg.getRank(), mpiMsg.getRank(), ++readyNode);
                if (readyNode >= replyNode) break;
            }
            receiveAllPeer = true;
            rankTable.setNumProcess(numPeers);
            rankTable.setNumReplica(numReplica);
            System.out.println("* Check Receive all peers");
            if (!receiveAllPeer) {
                boolean[] rankExist = new boolean[numPeers];
                int tableSize = rankTable.size();
                for (i = 0; i < numPeers; ++i) {
                    rankExist[i] = false;
                }
                for (i = 0; i < tableSize; ++i) {
                    rankExist[MPI.rankTable.getRank((int)i)] = true;
                }
                for (i = 0; i < numPeers; ++i) {
                    if (rankExist[i]) continue;
                    System.err.println("*** Not enough peer to form an execution platform. ***");
                    System.exit(1);
                }
            }
            int numNode = rankTable.size();
            boolean[] masterRank = new boolean[numPeers];
            for (i = 0; i < numPeers; ++i) {
                masterRank[i] = false;
            }
            System.out.println("============================================");
            for (i = 0; i < numNode; ++i) {
                int tmpRank = rankTable.getRank(i);
                if (!masterRank[tmpRank]) {
                    System.out.println("[Master of Rank " + tmpRank + "]: IP = " + rankTable.getCmdHost(i));
                    masterRank[tmpRank] = true;
                    continue;
                }
                System.out.println("Rank " + tmpRank + ": IP = " + rankTable.getCmdHost(i));
            }
            System.out.println("============================================");
            long startSendRankTableTime = System.currentTimeMillis();
            System.out.println("* Using protocol = " + gossipProtocol);
            for (int i5 = 1; i5 < numNode; ++i5) {
                mpiMsg = new MPIMessage(13);
                mpiMsg.setCommTable(rankTable);
                mpiMsg.setRank(rankTable.getRank(i5));
                mpiMsg.setRankInList(i5);
                mpiMsg.setSize(numPeers);
                mpiMsg.setTGossip(tGossip);
                mpiMsg.setTHang(tHang);
                mpiMsg.setTMargin(t_sent * rankTable.size());
                mpiMsg.setGossipProtocol(gossipProtocol);
                mpiMsg.setTDiff((int)(System.currentTimeMillis() - startSendRankTableTime));
                try {
                    System.out.println("* send SYN2: " + rankTable.getCmdHost(i5) + ":" + rankTable.getCmdPort(i5));
                    conn = new Socket(rankTable.getCmdHost(i5), rankTable.getCmdPort(i5));
                    os = conn.getOutputStream();
                    oos = new ObjectOutputStream(os);
                    oos.writeObject(mpiMsg);
                    oos.flush();
                    oos.close();
                    os.close();
                    conn.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            myDevice.connect(0, 0, 0, rankTable, numPeers, numReplica);
            myDevice.spawnMessageHandler(rank0Port.getPort(), numPeers, rankTable, myHash, mpdPort, fdPort, conf.getTGossip(), t_sent * rankTable.size(), conf.getTHang(), conf.getGossipProtocol());
            Thread devThread = new Thread(myDevice);
            devThread.setDaemon(true);
            devThread.start();
            COMM_WORLD = new IntraComm(myDevice, rankTable, 0, 0, numPeers, mapRankTable);
            AppRegisterMessage appMsg = new AppRegisterMessage();
            appMsg.setID(myHash + "--0");
            appMsg.setRunCmd(runCmd);
            appMsg.setIPRank0(MPI.getLocalhostExtIp());
            appMsg.setRunDir(System.getProperty("user.dir"));
            appMsg.setRank(0);
            appMsg.setPort(rank0Port.getPortNumber());
            appMsg.setMPISize(numPeers);
            appMsg.setRealSize(rankTable.size());
            appMsg.setRankTable(rankTable);
            try {
                conn = new Socket("127.0.0.1", mpdPort);
                os = conn.getOutputStream();
                oos = new ObjectOutputStream(os);
                oos.writeObject(appMsg);
                oos.flush();
                in = conn.getInputStream();
                ois = new ObjectInputStream(in);
                PingReplyMessage repMsg = (PingReplyMessage)ois.readObject();
                ois.close();
                oos.close();
                os.close();
                in.close();
                conn.close();
            }
            catch (Exception e) {
                System.err.println("** [Error] Please make sure that MPD is running.");
                System.exit(1);
            }
            System.out.println("* Create a gossip instance.");
            GossipMessage gossipMsg = new GossipMessage(0, myHash);
            gossipMsg.setMyRank(0);
            gossipMsg.setMPIRank(0);
            gossipMsg.setMPIPort(rank0Port.getPortNumber());
            gossipMsg.setURIList(rankTable.getFDURIs());
            gossipMsg.setTGossip(conf.getTGossip());
            gossipMsg.setTHang(conf.getTHang());
            gossipMsg.setTMargin(t_sent * rankTable.size());
            gossipMsg.setGossipProtocol(conf.getGossipProtocol());
            gossipMsg.setTDiff(System.currentTimeMillis(), (int)(System.currentTimeMillis() - startSendRankTableTime));
            try {
                conn = new Socket("127.0.0.1", fdPort);
                os = conn.getOutputStream();
                oos = new ObjectOutputStream(os);
                oos.writeObject(gossipMsg);
                oos.flush();
                oos.close();
                os.close();
                conn.close();
            }
            catch (Exception e) {
                System.err.println("** [Error] Fault Detection Service is not running");
                System.exit(1);
            }
            System.out.println("* Program is executing ...");
        } else {
            MPIClient MPIWorker = new MPIClient(minPort, maxPort);
            result = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                result[i] = new String(args[i]);
            }
        }
        RSMessage rsMsg = new RSMessage(7, myHash);
        try {
            conn = new Socket("127.0.0.1", rsPort);
            os = conn.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(rsMsg);
            oos.flush();
            oos.close();
            os.close();
            conn.close();
        }
        catch (Exception e) {
            System.err.println("** [Error] Reservation Service is not running");
            System.exit(1);
        }
        while (!myDevice.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        COMM_WORLD.Barrier();
        return result;
    }

    public static int Rand() {
        return mpiRandom.nextInt();
    }

    public static int Rand(int n) {
        return mpiRandom.nextInt(n);
    }

    public static void Finalize() {
        Socket conn = null;
        OutputStream os = null;
        ObjectOutputStream oos = null;
        COMM_WORLD.Barrier();
        if (rankTable.size() == 1) {
            if (myDevice != null) {
                myDevice.shutdown();
            }
            MPI.unregisterAppToMPD();
            return;
        }
        if (myDevice.getRankInList() == 0) {
            myDevice.meTerminated();
            while (!myDevice.isAllTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {}
            }
            myDevice.finalizeConfirm();
        } else {
            myDevice.finalize(myDevice.getRankInList());
            while (!myDevice.isTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {}
            }
        }
        try {
            GossipMessage gossipMsg = new GossipMessage(2, myHash);
            int rankInList = myDevice.getRankInList();
            gossipMsg.setMyRank(rankInList);
            conn = new Socket("127.0.0.1", fdPort);
            os = conn.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(gossipMsg);
            oos.flush();
            oos.close();
            os.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("Fault Detection Service is not running");
        }
        MPI.unregisterAppToMPD();
        int nbmsg = myDevice.getUnexpectedQueueSize();
        if (nbmsg != 0) {
            System.err.println("** [rank " + myDevice.getRank() + "] Warning : there was " + nbmsg + " message(s) left in reception buffer. **");
        }
        if (myDevice != null) {
            myDevice.shutdown();
        }
    }

    public static double Wtime() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double Wtick() {
        double resolution = 1.0E-4;
        double tick = 0.0;
        if (tick == 0.0) {
            tick = System.currentTimeMillis();
            tick = (double)System.currentTimeMillis() - tick;
            for (int counter = 0; counter < 10; ++counter) {
                double t = System.currentTimeMillis();
                t = (double)System.currentTimeMillis() - t;
                if (!(t < tick)) continue;
                tick = t;
            }
            tick = tick > 0.0 ? tick : 1.0E-5;
        }
        return tick / 1000.0;
    }

    public static String Get_processor_name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        myHash = null;
        myDevice = null;
        externalIP = null;
        internalIP = null;
        t_sent = 1000;
        CACHE_REQ_KEYWORD = "cache";
        NULL = new Datatype(0);
        BYTE = new Datatype(1);
        CHAR = new Datatype(2);
        SHORT = new Datatype(3);
        BOOLEAN = new Datatype(4);
        INT = new Datatype(5);
        LONG = new Datatype(6);
        FLOAT = new Datatype(7);
        DOUBLE = new Datatype(8);
        PACKED = new Datatype(9);
        STRING = new Datatype(10);
        OBJECT = new Datatype(11);
        BYTE2 = BYTE.Contiguous(2);
        CHAR2 = CHAR.Contiguous(2);
        SHORT2 = SHORT.Contiguous(2);
        INT2 = INT.Contiguous(2);
        LONG2 = LONG.Contiguous(2);
        FLOAT2 = FLOAT.Contiguous(2);
        DOUBLE2 = DOUBLE.Contiguous(2);
        ANY_SOURCE = Tag.MPI_ANYSOURCE;
        ANY_TAG = Tag.MPI_ANYTAG;
        UNDEFINED = -3;
        UNEQUAL = 0;
        SIMILAR = 1;
        IDENT = 2;
        MAX = new Op(1);
        MIN = new Op(2);
        SUM = new Op(3);
        PROD = new Op(4);
        BAND = new Op(6);
        MAXLOC = new Op(12);
        MINLOC = new Op(11);
    }
}

